/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.symbols;

import de.fzi.delphi.OPDebug;
import de.fzi.delphi.OPProjectManager;
import de.fzi.delphi.parser.debug.ScopeTree;
import de.fzi.delphi.symbols.CompilationUnit;
import de.fzi.delphi.symbols.Method;
import de.fzi.delphi.symbols.MethodComposite;
import de.fzi.delphi.symbols.ScopePath;
import de.fzi.delphi.symbols.ScopingEngine;
import de.fzi.delphi.symbols.ScopingException;
import de.fzi.delphi.symbols.SimpleSymbol;
import de.fzi.delphi.symbols.StringTabelle;
import de.fzi.delphi.symbols.SubScoped;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.symbols.UnknownSymbol;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.delphi.symbols.types.Typed;
import de.fzi.delphi.types.Type;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Scope
implements Serializable {
    private Scope parent = null;
    private Map symbolTable = null;
    private List childScopes = null;
    private String name = null;
    private String fullQualifiedName = null;
    private int sourceLine = -1;
    private List methodCalls = null;
    public static String ROOT_SCOPE_NAME = "[root]";
    public static String UNRESOLVED_SCOPE_NAME = "[Unresolved]";
    private static boolean unresolvedScope = false;
    private static Map scopeCache = new HashMap();
    private Symbol correspondingSymbol;
    private static boolean isDeclarationAnalysisFinished = false;

    public Scope(Scope parent, String name) {
        this(parent, name, -1);
    }

    public Scope(Scope parent, String name, int sourceline) {
        if (isDeclarationAnalysisFinished) {
            OPDebug.debugPrintln(1, "WARNING! Scope " + parent.getFullName() + "." + name + " created after declarationAnalysis.");
        }
        this.setParent(parent);
        this.setName(name);
        this.setSourceLine(sourceline);
        this.symbolTable = new HashMap();
        this.childScopes = new Vector();
        if (parent != null) {
            parent.addChildScope(this);
        }
        this.fullQualifiedName = parent != null ? String.valueOf(parent.getFullName()) + "." + name : name;
        scopeCache.put(this.getFullName().toLowerCase(), this);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullQualifiedName;
    }

    public Scope getParent() {
        return this.parent;
    }

    private void setName(String scopeName) {
        this.name = scopeName;
    }

    private void setParent(Scope scope) {
        this.parent = scope;
    }

    public void setSourceLine(int i) {
        this.sourceLine = i;
    }

    public boolean isRootScope() {
        return this.parent == null;
    }

    public boolean isUnresolvedScope() {
        return this.getName().equals(UNRESOLVED_SCOPE_NAME);
    }

    public Symbol addSymbol(Symbol symbol) {
        assert (this.symbolTable != null);
        if (symbol == null) {
            return null;
        }
        if (symbol.isInstanceOf("Method")) {
            MethodComposite dm = null;
            if (!this.symbolTable.containsKey(new Integer(symbol.getNameHash()))) {
                dm = new MethodComposite(symbol);
                dm.setScope(this);
                this.symbolTable.put(new Integer(dm.getNameHash()), dm);
            } else {
                Symbol existingSymbol = (Symbol)this.symbolTable.get(new Integer(symbol.getNameHash()));
                if (existingSymbol.isInstanceOf("MethodComposite")) {
                    dm = (MethodComposite)existingSymbol;
                } else {
                    OPDebug.debugPrintln(1, "Found conflicting symbol type in symbol table: " + symbol.getFullName());
                    return null;
                }
            }
            for (Method m : dm.getOverloadedMethods()) {
                if (!m.getNameWithParameters().equalsIgnoreCase(((Method)symbol).getNameWithParameters())) continue;
                return m;
            }
            symbol.setScope(this);
            dm.addOverloadedMethod((Method)symbol);
            return symbol;
        }
        if (this.symbolTable.containsKey(new Integer(symbol.getNameHash()))) {
            return this.getSymbol(symbol);
        }
        symbol.setScope(this);
        this.symbolTable.put(new Integer(symbol.getNameHash()), symbol);
        return this.getSymbol(symbol);
    }

    protected void addChildScope(Scope childScope) {
        assert (this.childScopes != null);
        this.childScopes.add(childScope);
    }

    public List getOverloadedMethods(Symbol method) {
        SimpleSymbol newSym = new SimpleSymbol();
        int pos = method.getName().indexOf("/");
        if (pos != -1) {
            newSym.setName(method.getName().substring(0, pos));
        } else {
            newSym.setName(method.getName());
        }
        Vector<Method> results = new Vector<Method>();
        for (Symbol current : this.getSymbols()) {
            if (!current.isMethod()) continue;
            if (current.getName().equalsIgnoreCase(newSym.getName())) {
                results.add((Method)current);
                continue;
            }
            int pos1 = current.getName().indexOf("/");
            int n = pos1 = pos1 == -1 ? current.getName().length() : pos1;
            if (!newSym.getName().equalsIgnoreCase(current.getName().substring(0, pos1))) continue;
            results.add((Method)current);
        }
        return results;
    }

    public Scope getRootScope() {
        if (this.isRootScope()) {
            return this;
        }
        return this.getParent().getRootScope();
    }

    public static String calculateFullPath(String basePath, String relativePath) {
        StringTokenizer stBasePath = new StringTokenizer(basePath, ".");
        StringTokenizer stRelativePath = new StringTokenizer(relativePath, ".");
        if (basePath.equalsIgnoreCase(relativePath)) {
            return basePath;
        }
        new Vector();
        String currentRelToken = null;
        if (stRelativePath.hasMoreTokens()) {
            currentRelToken = stRelativePath.nextToken();
        }
        String newPath = null;
        while (stBasePath.hasMoreTokens()) {
            String currentBaseToken = stBasePath.nextToken();
            newPath = newPath == null ? currentBaseToken : String.valueOf(newPath) + "." + currentBaseToken;
            if (!currentBaseToken.equalsIgnoreCase(currentRelToken)) continue;
            if (!stRelativePath.hasMoreTokens()) break;
            currentRelToken = stRelativePath.nextToken();
        }
        newPath = String.valueOf(newPath) + "." + currentRelToken;
        while (stRelativePath.hasMoreTokens()) {
            newPath = String.valueOf(newPath) + "." + stRelativePath.nextToken();
        }
        return newPath;
    }

    public Scope getSubScope(String unqualifiedName) {
        for (Scope current : this.childScopes) {
            if (!current.getName().equalsIgnoreCase(unqualifiedName)) continue;
            return current;
        }
        return null;
    }

    public Scope findSubScope(String unqualifiedName) {
        Iterator childScopeIterator = this.getChildScopes().iterator();
        Scope hit = null;
        while (childScopeIterator.hasNext()) {
            Scope currentSubScope = (Scope)childScopeIterator.next();
            if (currentSubScope.getName().equalsIgnoreCase(unqualifiedName)) {
                hit = currentSubScope;
                break;
            }
            hit = currentSubScope.findSubScope(unqualifiedName);
            if (hit != null) break;
        }
        return hit;
    }

    public Scope getPartialSubScope(String partialQualifiedName) {
        if (partialQualifiedName.indexOf(".") != -1) {
            String subScopeName = partialQualifiedName.substring(partialQualifiedName.indexOf(".") + 1);
            for (Scope current : this.childScopes) {
                ScopePath partialQualifiedPath = new ScopePath(partialQualifiedName);
                ScopePath thisPath = new ScopePath(this.getName());
                if (!thisPath.isPartOf(partialQualifiedPath) || current.getPartialSubScope(subScopeName) == null) continue;
                return current.getPartialSubScope(subScopeName);
            }
            return null;
        }
        if (partialQualifiedName.equalsIgnoreCase(this.getName())) {
            return this;
        }
        return null;
    }

    public Scope getScope(String qualifiedName) {
        return (Scope)scopeCache.get(qualifiedName.toLowerCase());
    }

    public String toString() {
        String temp = this.getFullName();
        if (temp == null) {
            temp = "<null>";
        }
        if (this.sourceLine != -1) {
            temp = String.valueOf(temp) + ", l." + this.sourceLine;
        }
        return temp;
    }

    public void printAllSubScopes() {
        System.out.println("Scope: " + this.getFullName());
        if (this.getSymbols() != null) {
            for (Symbol sym : this.getSymbols()) {
                System.out.println(sym.toString());
            }
        }
        if (this.childScopes != null) {
            for (Scope scope : this.childScopes) {
                scope.printAllSubScopes();
            }
        }
        System.out.println("-------------------");
    }

    public List getChildScopes() {
        return this.childScopes;
    }

    public Collection getSymbols() {
        Vector symbolList = new Vector();
        for (Symbol currentSymbol : this.symbolTable.values()) {
            if (currentSymbol.isInstanceOf("MethodComposite")) {
                Iterator overloadedMethodListIterator = ((MethodComposite)currentSymbol).getOverloadedMethods().iterator();
                while (overloadedMethodListIterator.hasNext()) {
                    symbolList.add(overloadedMethodListIterator.next());
                }
                continue;
            }
            symbolList.add(currentSymbol);
        }
        return symbolList;
    }

    public String getHtmlInfoString() {
        StringBuffer returnString = new StringBuffer();
        returnString.append("<tr><th>Name:</th>");
        returnString.append("<td>" + this.getName() + "</td></tr>");
        if (!this.isRootScope()) {
            returnString.append("<tr><th>Scope:</th>");
            returnString.append("<td>" + this.getParent().getFullName() + "</td></tr>");
        }
        returnString.append("<tr><th>direct Subscopes:</th>");
        returnString.append("<td>" + this.getChildScopes().size() + "</td></tr>");
        returnString.append("<tr><th>Symbols:</th>");
        returnString.append("<td>" + this.getSymbols().size() + "</td></tr>");
        returnString.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
        if (!this.isRootScope()) {
            Symbol sym = this.getCorrespondingSymbol();
            if (sym != null) {
                returnString.append("<tr><th>Corresponds to:</th>");
                returnString.append("<td>" + sym.getFullName() + " {" + sym.getClass().getName().substring(sym.getClass().getName().lastIndexOf(".") + 1) + "}" + "</td></tr>");
                returnString.append(sym.getHtmlInfoString());
            }
            if (this.getMethodCalls() != null) {
                returnString.append("<tr><th>Calls:</th>");
                returnString.append("<td>");
                Iterator li = this.getMethodCalls().iterator();
                while (li.hasNext()) {
                    returnString.append(String.valueOf((String)li.next()) + ",");
                }
                returnString.append("</td></tr>");
            }
        }
        return returnString.toString();
    }

    public boolean isScopeOfMethod() {
        Symbol sym = this.getCorrespondingSymbol();
        if (sym != null) {
            return sym.isInstanceOf("Method");
        }
        return false;
    }

    public int countUnresolvedSymbols() {
        return this.getUnresolvedScope().getSymbols().size();
    }

    private Scope getUnresolvedScope() {
        return this.getRootScope().getSubScope(UNRESOLVED_SCOPE_NAME);
    }

    public void processUnresolvedScope() {
        Scope unresolvedScope = this;
        if (!unresolvedScope.equals(OPProjectManager.getUnresolvedScope())) {
            return;
        }
        Vector symbolTableCopy = new Vector();
        symbolTableCopy.addAll(unresolvedScope.getSymbols());
        for (Symbol currentUnresolvedSymbol : symbolTableCopy) {
            if (!currentUnresolvedSymbol.isInstanceOf("UnknownSymbol")) continue;
            Vector referenceListCopy = new Vector();
            referenceListCopy.addAll(((UnknownSymbol)((Object)currentUnresolvedSymbol)).getReferences());
            for (Symbol currentReference : referenceListCopy) {
                if (currentReference.isInstanceOf("ClassType")) {
                    ClassType currentClass = (ClassType)currentReference;
                    ListIterator superTypeIterator = currentClass.getSuperClasses().listIterator();
                    while (superTypeIterator.hasNext()) {
                        ClassType currentSuperClass = (ClassType)superTypeIterator.next();
                        if (!currentSuperClass.isInstanceOf("UnknownClassType") || !currentSuperClass.getName().equalsIgnoreCase(currentUnresolvedSymbol.getName()) || currentClass.getScope() == null) continue;
                        Symbol s = null;
                        try {
                            ScopingEngine se = new ScopingEngine(this.getRootScope(), currentClass.getScope());
                            se.setInterface(currentReference.isInterfaceDeclaration());
                            s = se.resolve(currentSuperClass.getName());
                        }
                        catch (ScopingException e) {
                            e.printStackTrace();
                        }
                        if (s == null || !s.isInstanceOf("ClassType") || s.isInstanceOf("UnknownSymbol")) continue;
                        currentClass.replaceSuperClass(currentSuperClass, (ClassType)s);
                        ((UnknownSymbol)((Object)currentUnresolvedSymbol)).getReferences().remove(currentReference);
                    }
                    continue;
                }
                if (!currentReference.isInstanceOf("TypedSymbol")) continue;
                Symbol resolvedSymbol = null;
                if (currentReference.getScope() == null) continue;
                try {
                    ScopingEngine se = new ScopingEngine(this.getRootScope(), currentReference.getScope());
                    se.setInterface(currentReference.isInterfaceDeclaration());
                    resolvedSymbol = se.resolve(((Typed)((Object)currentUnresolvedSymbol)).getType().getName());
                }
                catch (ScopingException e) {
                    e.printStackTrace();
                }
                if (!currentReference.isInstanceOf("Typed") || resolvedSymbol == null || !resolvedSymbol.isInstanceOf("Type") || resolvedSymbol.isInstanceOf("UnknownSymbol")) continue;
                ((Typed)((Object)currentReference)).setType((Type)resolvedSymbol);
                ((UnknownSymbol)((Object)currentUnresolvedSymbol)).getReferences().remove(currentReference);
            }
            if (!((UnknownSymbol)((Object)currentUnresolvedSymbol)).getReferences().isEmpty() || unresolvedScope.removeSymbol(currentUnresolvedSymbol)) continue;
            OPDebug.debugPrintln(2, "WARNING! Symbol '" + currentUnresolvedSymbol + "' could not be removed from Unresolved-Scope.");
        }
    }

    public void addMethodCall(String m) {
        if (this.methodCalls == null) {
            this.methodCalls = new Vector();
        }
        this.methodCalls.add(m);
    }

    public List getMethodCalls() {
        return this.methodCalls;
    }

    public void show() {
        ScopeTree scopeTree = new ScopeTree(this);
        scopeTree.setCloseAction(ScopeTree.DISPOSE_ON_CLOSE);
        scopeTree.display();
    }

    public boolean isCompilationUnit() {
        if (this.isRootScope() || this.getParent() == null || this == OPProjectManager.getUnresolvedScope()) {
            return false;
        }
        return this.getParent().isRootScope();
    }

    public Scope getCompilationUnitScope() {
        if (this.isCompilationUnit()) {
            return this;
        }
        if (this.getParent() != null) {
            return this.getParent().getCompilationUnitScope();
        }
        return null;
    }

    public CompilationUnit getCompilationUnit() {
        if (!this.isRootScope() && this.getParent().isRootScope()) {
            for (Symbol sym : this.getParent().getSymbols()) {
                if (!sym.getName().equalsIgnoreCase(this.getName()) || !sym.isInstanceOf("CompilationUnit")) continue;
                return (CompilationUnit)sym;
            }
            return null;
        }
        if (!this.isRootScope() && !this.getParent().isRootScope()) {
            return this.getParent().getCompilationUnit();
        }
        return null;
    }

    public void setCorrespondingSymbol(Symbol sym) {
        if (sym == null) {
            return;
        }
        this.correspondingSymbol = sym;
        if (sym.isInstanceOf("SubScoped")) {
            ((SubScoped)((Object)sym)).setSubScope(this);
        }
    }

    public Symbol getCorrespondingSymbol() {
        return this.correspondingSymbol;
    }

    public Symbol searchInSubscopes(Symbol sym) {
        for (Scope current : this.getChildScopes()) {
            if (current == null) continue;
            if (current.getSymbol(sym) != null) {
                return current.getSymbol(sym);
            }
            if (current.searchInSubscopes(sym) == null) continue;
            return current.searchInSubscopes(sym);
        }
        return null;
    }

    public boolean contains(Symbol symbol) {
        return this.symbolTable.containsKey(new Integer(symbol.getNameHash()));
    }

    Symbol findSymbolByName(String name) {
        return (Symbol)this.symbolTable.get(new Integer(StringTabelle.findOrCreate(name)));
    }

    public boolean removeSymbol(Symbol symbolToRemove) {
        return this.symbolTable.remove(new Integer(symbolToRemove.getNameHash())) != null;
    }

    Symbol getSymbol(Symbol symbol) {
        if (this.symbolTable.containsKey(new Integer(symbol.getNameHash()))) {
            return (Symbol)this.symbolTable.get(new Integer(symbol.getNameHash()));
        }
        return null;
    }

    public boolean interfaceContains(Symbol symbol) {
        return this.contains(symbol) && this.getSymbol(symbol).isInterfaceDeclaration();
    }

    public int countAllSymbols() {
        int counter = 0;
        for (Symbol currentSym : this.getSymbols()) {
            Type currentSymType;
            if (currentSym.isInstanceOf("Typed") && (currentSymType = ((Typed)((Object)currentSym)).getType()) != null && !currentSymType.isResolved()) {
                ++counter;
            }
            ++counter;
        }
        for (Scope scope : this.childScopes) {
            counter += scope.countAllSymbols();
        }
        return counter;
    }

    public static boolean isDeclarationAnalysisFinished() {
        return isDeclarationAnalysisFinished;
    }

    public static void setDeclarationAnalysisFinished() {
        isDeclarationAnalysisFinished = true;
    }
}

