/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.symbols;

import de.fzi.delphi.symbols.CompilationUnit;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.symbols.TypedSymbol;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.delphi.symbols.types.Modified;
import de.fzi.delphi.types.Type;

public abstract class ModifiedSymbol
extends TypedSymbol
implements Modified {
    protected int visibility = 0;

    public ModifiedSymbol() {
    }

    public ModifiedSymbol(int hash) {
        super(hash);
    }

    public ModifiedSymbol(int nameHash, Type type) {
        super(nameHash, type);
    }

    public ModifiedSymbol(String name, Type type) {
        super(name, type);
    }

    public ModifiedSymbol(String name) {
        super(name);
    }

    @Override
    public boolean isPrivate() {
        return this.visibility == 4;
    }

    @Override
    public boolean isProtected() {
        return this.visibility == 3;
    }

    @Override
    public boolean isPublic() {
        return this.visibility == 1;
    }

    @Override
    public boolean isPublished() {
        return this.visibility == 2;
    }

    @Override
    public boolean isAutomated() {
        return this.visibility == 5;
    }

    @Override
    public boolean isStrictlyPrivate() {
        return this.visibility == 6;
    }

    @Override
    public boolean isStrictlyProtected() {
        return this.visibility == 7;
    }

    public boolean isVisibleFrom(ClassType cls) {
        if (this.isPublic() || this.isPublished() || this.isAutomated()) {
            return true;
        }
        if (cls == null) {
            return false;
        }
        ClassType parentClass = null;
        CompilationUnit parentFile = null;
        if (this.scope != null) {
            Symbol res = this.scope.getCorrespondingSymbol();
            if (res != null && res.isInstanceOf("ClassType")) {
                parentClass = (ClassType)res;
            }
            parentFile = this.scope.getCompilationUnit();
        }
        if (parentClass != null && cls.hasAncestor(parentClass) && (this.isStrictlyProtected() || this.isProtected())) {
            return true;
        }
        Scope clsScope = cls.getScope();
        return clsScope != null && parentFile != null && parentFile == cls.getScope().getCompilationUnit() && this.isPrivate();
    }

    @Override
    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public String getHtmlInfoString() {
        StringBuffer returnString = new StringBuffer();
        returnString.append(super.getHtmlInfoString());
        returnString.append("<tr><th>Visibility:</th>");
        returnString.append("<td>" + this.getVisibilityString() + "</td></tr>");
        return returnString.toString();
    }

    public String getVisibilityString() {
        String returnString;
        switch (this.getVisibility()) {
            case 1: {
                returnString = "public";
                break;
            }
            case 5: {
                returnString = "automated";
                break;
            }
            case 2: {
                returnString = "published";
                break;
            }
            case 3: {
                returnString = "protected";
                break;
            }
            case 4: {
                returnString = "private";
                break;
            }
            default: {
                returnString = "";
            }
        }
        return returnString;
    }

    @Override
    public String getSymbolTypeCheckerIdentifier() {
        return String.valueOf(super.getSymbolTypeCheckerIdentifier()) + "/Modified//ModifiedSymbol/";
    }
}

