/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.symbols;

import de.fzi.delphi.CodeblockInfo;
import de.fzi.delphi.symbols.Attribute;
import de.fzi.delphi.symbols.MethodComposite;
import de.fzi.delphi.symbols.ModifiedSymbol;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.ScopingEngine;
import de.fzi.delphi.symbols.ScopingException;
import de.fzi.delphi.symbols.SimpleSymbol;
import de.fzi.delphi.symbols.SubScoped;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.symbols.TypedSymbol;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.delphi.symbols.types.IntegerType;
import de.fzi.delphi.symbols.types.Range;
import de.fzi.delphi.symbols.types.RealType;
import de.fzi.delphi.symbols.types.SimpleType;
import de.fzi.delphi.types.Type;
import de.fzi.sissy.metamod.BlockStatement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class Method
extends ModifiedSymbol
implements SubScoped {
    public static final int UNKNOWN = 0;
    public static final int PROCEDURE = 1;
    public static final int FUNCTION = 2;
    public static final int CONSTRUCTOR = 3;
    public static final int DESTRUCTOR = 4;
    public static final int UNIT_INITIALIZER = 5;
    public static final int UNIT_FINALIZER = 6;
    private int category = 0;
    private List parameters = null;
    private CodeblockInfo codeblockInfo = null;
    private BlockStatement body;
    private boolean overloaded = false;
    private boolean classMethod = false;
    private boolean isAbstract = false;
    private boolean isOverride = false;
    private boolean isVirtual = false;
    private Scope correspondingScope;

    public Method() {
    }

    public Method(int nameHash) {
        super(nameHash);
    }

    public Method(int nameHash, Type returnType) {
        super(nameHash, returnType);
    }

    public Method(String name) {
        super(name);
    }

    public Method(String name, Type type) {
        super(name, type);
    }

    public Method(String name, Type type, List params) {
        super(name, type);
        this.setParameters(params);
    }

    public Method(SimpleSymbol sym) {
        super(sym.getNameHash(), Type.NULL);
        this.setScope(sym.getScope());
    }

    public Method(SimpleSymbol sym, Type t) {
        super(sym.getNameHash(), t);
        this.setScope(sym.getScope());
    }

    public void setParameters(List c) {
        if (c == null) {
            this.parameters = new Vector();
        } else {
            ListIterator li = c.listIterator();
            this.parameters = new Vector();
            while (li.hasNext()) {
                Object current = li.next();
                if (current == null) continue;
                this.parameters.add(current);
            }
        }
    }

    public boolean isCompatible(Method m) {
        if (!this.getName().equalsIgnoreCase(m.getName())) {
            return false;
        }
        if (this.getScope().getFullName().compareToIgnoreCase(m.getScope().getFullName()) != 0) {
            return false;
        }
        if (this.getParameters().size() == m.getParameters().size()) {
            ListIterator thisParams = this.getParameters().listIterator();
            ListIterator mParams = m.getParameters().listIterator();
            while (thisParams.hasNext()) {
                Type thisCurrentParam;
                Type mCurrentParam = ((TypedSymbol)mParams.next()).getType();
                if (mCurrentParam == (thisCurrentParam = ((TypedSymbol)thisParams.next()).getType()) || mCurrentParam.isAssignmentCompatible(thisCurrentParam)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public Method getCompatibleMethodInSameScope() {
        List overloadedMethods = this.getScope().getOverloadedMethods(this);
        if (!overloadedMethods.isEmpty()) {
            ListIterator candidates = overloadedMethods.listIterator();
            while (candidates.hasNext()) {
                Method current = (Method)candidates.next();
                if (!current.isCompatible(this)) continue;
                return current;
            }
        }
        return null;
    }

    public List getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        return new Vector();
    }

    @Override
    public String toString() {
        String path = "";
        String ret = "";
        if (this.getScope() != null) {
            path = this.getScope().getFullName();
            if (!this.getScope().isRootScope()) {
                path = String.valueOf(path) + ".";
            }
        }
        ret = String.valueOf(path) + this.getName();
        ret = this.isOverloaded() ? String.valueOf(ret) + "(" + this.getParameters() + ")" : String.valueOf(ret);
        if (this.getType() != null) {
            ret = String.valueOf(ret) + " {" + this.getType().toString() + ":'" + this.getType().getName() + "'";
            if (this.getScope() != null) {
                ret = String.valueOf(ret) + "/" + this.getScope().toString();
            }
            ret = String.valueOf(ret) + "}";
        } else {
            ret = String.valueOf(ret) + " {<procedure>}";
        }
        return ret;
    }

    public boolean isOverloaded() {
        return this.overloaded;
    }

    public boolean isInnerMethod() {
        Symbol sym;
        if (this.getScope() != null && (sym = this.getScope().getCorrespondingSymbol()) != null) {
            return sym.isInstanceOf("Method");
        }
        return false;
    }

    public void setOverloaded(boolean b) {
        this.overloaded = b;
    }

    @Override
    public String getHtmlInfoString() {
        StringBuffer returnString = new StringBuffer();
        returnString.append(super.getHtmlInfoString());
        if (this.getCategory() >= 1 && this.getCategory() <= 4) {
            returnString.append("<tr><th>Category:</th>");
            returnString.append("<td>");
            switch (this.getCategory()) {
                case 1: {
                    returnString.append("Procedure");
                    break;
                }
                case 2: {
                    returnString.append("Function");
                    break;
                }
                case 3: {
                    returnString.append("Constructor");
                    break;
                }
                case 4: {
                    returnString.append("Destructor");
                }
            }
            returnString.append("</td>");
            returnString.append("</tr>");
        }
        if (this.getParameters() != null) {
            returnString.append("<tr><th>Parameters:</th>");
            returnString.append("<td>");
            ListIterator li = this.getParameters().listIterator();
            while (li.hasNext()) {
                Symbol current = (Symbol)li.next();
                returnString.append(current.getName());
                if (current.isInstanceOf("Attribute") && ((Attribute)current).getType() != null) {
                    returnString.append(":" + ((Attribute)current).getType().getFullName());
                }
                if (!li.hasNext()) continue;
                returnString.append(",&nbsp;");
            }
            returnString.append("</td>");
            returnString.append("</tr>");
        }
        returnString.append("<tr><th>Overloaded:</th>");
        returnString.append("<td>" + this.isOverloaded() + "</td></tr>");
        returnString.append("<tr><th>Class-Method:</th>");
        returnString.append("<td>" + this.isClassMethod() + "</td></tr>");
        returnString.append("<tr><th>Inner-Method:</th>");
        returnString.append("<td>" + this.isInnerMethod() + "</td></tr>");
        returnString.append("<tr><th>isAbstract::</th>");
        returnString.append("<td>" + this.isAbstract() + "</td></tr>");
        returnString.append("<tr><th>isVirtual:</th>");
        returnString.append("<td>" + this.isVirtual() + "</td></tr>");
        returnString.append("<tr><th>isOverride:</th>");
        returnString.append("<td>" + this.isOverride() + "</td></tr>");
        if (this.getCodeblockInfo() != null) {
            returnString.append("<tr><th colspan=\"2\">Complexity:</th></tr>");
            returnString.append("<tr><th># total lines:</th>");
            returnString.append("<td>" + this.getCodeblockInfo().getTotalLines() + "</td></tr>");
            returnString.append("<tr><th># of branches:</th>");
            returnString.append("<td>" + this.getCodeblockInfo().getBranches() + "</td></tr>");
            returnString.append("<tr><th># of statements:</th>");
            returnString.append("<td>" + this.getCodeblockInfo().getStatements() + "</td></tr>");
            returnString.append("<tr><th># lines of comments:</th>");
            returnString.append("<td>" + this.getCodeblockInfo().getCommentLines() + "</td></tr>");
        }
        return returnString.toString();
    }

    public boolean isClassMethod() {
        return this.classMethod;
    }

    public void setClassMethod(boolean b) {
        this.classMethod = b;
    }

    public String parameterListToString() {
        return Method.parameterListToString(this.parameters);
    }

    public static String parameterListToString(List parameters) {
        if (parameters == null || parameters.size() == 0) {
            return "";
        }
        ListIterator li = parameters.listIterator();
        StringBuffer scopeIdent = new StringBuffer();
        while (li.hasNext()) {
            TypedSymbol current = (TypedSymbol)li.next();
            if (current != null && current.getType() != null) {
                scopeIdent.append(current.getType().getName());
            }
            if (current == null || !li.hasNext()) continue;
            scopeIdent.append("/");
        }
        return scopeIdent.toString();
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int i) {
        this.category = i;
    }

    public CodeblockInfo getCodeblockInfo() {
        return this.codeblockInfo;
    }

    public void setCodeblockInfo(CodeblockInfo info) {
        this.codeblockInfo = info;
    }

    public Scope getCorrespondingScope() {
        return this.getSubScope();
    }

    @Override
    public String getFullName() {
        if (this.getScope() != null) {
            return String.valueOf(this.getScope().getFullName()) + "." + this.getName();
        }
        return this.getName();
    }

    @Override
    public String getName() {
        String tempName = super.getName();
        if (tempName.lastIndexOf(".") != -1) {
            tempName = tempName.substring(tempName.lastIndexOf(".") + 1);
        }
        if (tempName.indexOf("/") != -1) {
            tempName = tempName.substring(0, tempName.indexOf("/"));
        }
        return tempName;
    }

    public String getFullNameWithParameters() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return this.getFullName();
        }
        return String.valueOf(this.getFullName()) + "/" + this.parameterListToString();
    }

    public String getNameWithParameters() {
        if (this.getParameters().size() > 0) {
            return String.valueOf(this.getName()) + "/" + this.parameterListToString();
        }
        return this.getName();
    }

    @Override
    public Scope getSubScope() {
        return this.correspondingScope;
    }

    @Override
    public void setSubScope(Scope scope) {
        this.correspondingScope = scope;
    }

    @Override
    public Type getType() {
        Type returnType = super.getType();
        if (returnType == null) {
            returnType = Type.getNilType();
            return returnType;
        }
        return returnType;
    }

    public BlockStatement getBody() {
        return this.body;
    }

    public void setBody(BlockStatement body) {
        this.body = body;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public void setOverride(boolean isOverride) {
        this.isOverride = isOverride;
    }

    private List getAllOverloadedMethods() {
        if (this.getScope() != null) {
            Iterator symbols = this.getScope().getSymbols().iterator();
            Vector<Symbol> resultList = new Vector<Symbol>();
            while (symbols.hasNext()) {
                Symbol currentSymbol = (Symbol)symbols.next();
                if (!currentSymbol.isInstanceOf("Method") || !((Method)currentSymbol).isOverloaded() || !currentSymbol.getName().equalsIgnoreCase(this.getName())) continue;
                resultList.add(currentSymbol);
            }
            return resultList;
        }
        return new Vector();
    }

    protected Method getMethodForThisCall(ScopingEngine myse) {
        Collection methods = null;
        ScopingEngine se = myse;
        if (se == null) {
            try {
                se = new ScopingEngine(this.getScope().getRootScope(), this.getScope());
            }
            catch (ScopingException scopingException) {
                return null;
            }
        }
        if (se != null) {
            Symbol sym = se.resolve(this.getName());
            if (sym != null && sym.isInstanceOf("MethodComposite")) {
                methods = ((MethodComposite)sym).getOverloadedMethods();
            }
        } else {
            return null;
        }
        if (methods == null) {
            return null;
        }
        Iterator allMethods = methods.iterator();
        if (!allMethods.hasNext()) {
            return null;
        }
        Method bestMatchSoFar = (Method)allMethods.next();
        while (allMethods.hasNext()) {
            Method currentMethod = (Method)allMethods.next();
            Method currentBest = this.getBestFittingMethodForThisCall(bestMatchSoFar, currentMethod);
            if (currentBest == null) continue;
            bestMatchSoFar = currentBest;
        }
        return bestMatchSoFar;
    }

    private Method getBestFittingMethodForThisCall(Method firstCandidate, Method secondCandidate) {
        if (firstCandidate.getParameters().size() != this.getParameters().size() && secondCandidate.getParameters().size() != this.getParameters().size()) {
            return null;
        }
        if (firstCandidate.getParameters().size() == this.getParameters().size() && secondCandidate.getParameters().size() != this.getParameters().size()) {
            return firstCandidate;
        }
        if (firstCandidate.getParameters().size() != this.getParameters().size() && secondCandidate.getParameters().size() == this.getParameters().size()) {
            return secondCandidate;
        }
        Iterator thisParameterIterator = this.getParameters().iterator();
        Iterator firstsParameterIterator = firstCandidate.getParameters().iterator();
        Iterator secondsParameterIterator = secondCandidate.getParameters().iterator();
        while (thisParameterIterator.hasNext()) {
            Symbol tmpSym = (Symbol)thisParameterIterator.next();
            Type thisCurrentParameter = tmpSym.isInstanceOf("Type") ? (Type)tmpSym : ((Attribute)tmpSym).getType();
            tmpSym = (Symbol)firstsParameterIterator.next();
            Type firstsCurrentParameter = tmpSym.isInstanceOf("Type") ? (Type)tmpSym : ((Attribute)tmpSym).getType();
            tmpSym = (Symbol)secondsParameterIterator.next();
            Type secondsCurrentParameter = tmpSym.isInstanceOf("Type") ? (Type)tmpSym : ((Attribute)tmpSym).getType();
            if (thisCurrentParameter.equals(firstsCurrentParameter) && thisCurrentParameter.equals(secondsCurrentParameter)) continue;
            if (thisCurrentParameter.equals(firstsCurrentParameter) && !thisCurrentParameter.equals(secondsCurrentParameter)) {
                return firstCandidate;
            }
            if (!thisCurrentParameter.equals(firstsCurrentParameter) && thisCurrentParameter.equals(secondsCurrentParameter)) {
                return secondCandidate;
            }
            if (thisCurrentParameter.isTypeCompatible(firstsCurrentParameter) && !thisCurrentParameter.isTypeCompatible(secondsCurrentParameter)) {
                return firstCandidate;
            }
            if (!thisCurrentParameter.isTypeCompatible(firstsCurrentParameter) && thisCurrentParameter.isTypeCompatible(secondsCurrentParameter)) {
                return secondCandidate;
            }
            if (!thisCurrentParameter.isTypeCompatible(firstsCurrentParameter) || !thisCurrentParameter.isTypeCompatible(secondsCurrentParameter)) continue;
            if (!thisCurrentParameter.isAssignmentCompatible(firstsCurrentParameter) && thisCurrentParameter.isAssignmentCompatible(secondsCurrentParameter)) {
                return firstCandidate;
            }
            if (thisCurrentParameter.isAssignmentCompatible(firstsCurrentParameter) && !thisCurrentParameter.isAssignmentCompatible(secondsCurrentParameter)) {
                return secondCandidate;
            }
            if (!thisCurrentParameter.isAssignmentCompatible(firstsCurrentParameter) || !thisCurrentParameter.isAssignmentCompatible(secondsCurrentParameter) || !thisCurrentParameter.isRangedType() || !firstsCurrentParameter.isRangedType() || !secondsCurrentParameter.isRangedType()) continue;
            if (thisCurrentParameter.isSubrangeOf(firstsCurrentParameter) && !thisCurrentParameter.isSubrangeOf(secondsCurrentParameter)) {
                return firstCandidate;
            }
            if (thisCurrentParameter.isSubrangeOf(secondsCurrentParameter) && !thisCurrentParameter.isSubrangeOf(firstsCurrentParameter)) {
                return secondCandidate;
            }
            if (!thisCurrentParameter.isSubrangeOf(secondsCurrentParameter) || !thisCurrentParameter.isSubrangeOf(firstsCurrentParameter)) continue;
            if (secondsCurrentParameter.isSubrangeOf(firstsCurrentParameter)) {
                return secondCandidate;
            }
            if (!firstsCurrentParameter.isSubrangeOf(secondsCurrentParameter)) continue;
            return firstCandidate;
        }
        return null;
    }

    public static void main(String[] args) {
        Method.test();
    }

    private static void test() {
        Scope rootScope = new Scope(null, Scope.ROOT_SCOPE_NAME);
        RealType real = new RealType("real");
        IntegerType integer = new IntegerType("Integer");
        integer.setRange(new Range("-2147483648", "2147483647"));
        IntegerType longword = new IntegerType("longword");
        longword.setRange(new Range("0", "4294967295"));
        IntegerType cardinal = new IntegerType("cardinal");
        cardinal.setRange(new Range("0", "4294967295"));
        IntegerType longint = new IntegerType("LongInt");
        longint.setRange(new Range("-2147483648", "2147483647"));
        IntegerType smallintType = new IntegerType("Smallint");
        smallintType.setRange(new Range("-32768", "32767"));
        IntegerType shortintType = new IntegerType("Shortint");
        shortintType.setRange(new Range("-128", "127"));
        Vector<SimpleType> method1Params = new Vector<SimpleType>();
        method1Params.add(integer);
        method1Params.add(real);
        Method method1 = new Method("m", integer, method1Params);
        method1.setOverloaded(true);
        method1.setScope(rootScope);
        rootScope.addSymbol(method1);
        Scope sc = new Scope(rootScope, method1.getNameWithParameters());
        sc.setCorrespondingSymbol(method1);
        Vector<IntegerType> method2Params = new Vector<IntegerType>();
        method2Params.add(integer);
        method2Params.add(integer);
        Method method2 = new Method("m", integer, method2Params);
        method2.setOverloaded(true);
        method2.setScope(rootScope);
        rootScope.addSymbol(method2);
        sc = new Scope(rootScope, method2.getNameWithParameters());
        sc.setCorrespondingSymbol(method2);
        if (!method1.isCompatible(method2)) {
            System.err.println("Error: Can't call Method " + method1 + " like this: " + method2);
        }
        if (!method2.isCompatible(method1)) {
            System.err.println("Error: Can't call Method " + method2 + " like this: " + method1);
        }
        Vector<IntegerType> method4Params = new Vector<IntegerType>();
        method4Params.add(integer);
        method4Params.add(smallintType);
        Method method4 = new Method("m", integer, method4Params);
        method4.setOverloaded(true);
        method4.setScope(rootScope);
        rootScope.addSymbol(method4);
        sc = new Scope(rootScope, method4.getNameWithParameters());
        sc.setCorrespondingSymbol(method4);
        System.out.println(method4.getAllOverloadedMethods());
        Vector<IntegerType> method3Params = new Vector<IntegerType>();
        method3Params.add(integer);
        method3Params.add(shortintType);
        Method method3 = new Method("m", integer, method3Params);
        method3.setOverloaded(true);
        method3.setScope(rootScope);
        Method best = method3.getBestFittingMethodForThisCall(method1, method2);
        if (best != method2) {
            System.err.println("Error: wrong method chosen");
        }
        if ((best = method3.getMethodForThisCall(null)) != method4) {
            System.err.println("Error: wrong method chosen");
        }
        ClassType typeTObject = new ClassType("TObject");
        rootScope.addSymbol(typeTObject);
        ClassType typeTDate = new ClassType("TDate", typeTObject);
        rootScope.addSymbol(typeTDate);
        ClassType typeTForm = new ClassType("TForm", typeTObject);
        rootScope.addSymbol(typeTForm);
        Vector<Type> method5Params = new Vector<Type>();
        method5Params.add(integer);
        method5Params.add(typeTDate);
        Method method5 = new Method("m1", integer, method5Params);
        method5.setOverloaded(true);
        method5.setScope(rootScope);
        rootScope.addSymbol(method5);
        sc = new Scope(rootScope, method5.getNameWithParameters());
        sc.setCorrespondingSymbol(method5);
        Vector<Type> method6Params = new Vector<Type>();
        method6Params.add(integer);
        method6Params.add(typeTObject);
        Method method6 = new Method("m1", integer, method6Params);
        method6.setOverloaded(true);
        method6.setScope(rootScope);
        rootScope.addSymbol(method6);
        sc = new Scope(rootScope, method6.getNameWithParameters());
        sc.setCorrespondingSymbol(method6);
        Vector<Type> method7Params = new Vector<Type>();
        method7Params.add(integer);
        method7Params.add(typeTForm);
        Method method7 = new Method("m1", integer, method7Params);
        method7.setOverloaded(true);
        method7.setScope(rootScope);
        best = method7.getMethodForThisCall(null);
        if (best == null) {
            System.out.println("ambiguous call for " + method7);
        } else if (best != method6) {
            System.err.println("Error: Can't call " + best + " by " + method7);
        }
        Method method8 = new Method("m1", (Type)integer);
        method8.setOverloaded(true);
        method8.setScope(rootScope);
        rootScope.addSymbol(method8);
        sc = new Scope(rootScope, method8.getNameWithParameters());
        sc.setCorrespondingSymbol(method8);
        best = method7.getMethodForThisCall(null);
        if (best == null) {
            System.out.println("ambiguous call for " + method7);
        } else if (best != method6) {
            System.err.println("Error: Can't call " + best + " by " + method7);
        }
        method7.setParameters(new Vector());
        best = method7.getMethodForThisCall(null);
        if (best == null) {
            System.out.println("ambiguous call for " + method7);
        } else if (best != method8) {
            System.err.println("Error: Can't call " + best + " by " + method7);
        }
        rootScope.show();
    }

    @Override
    public String getSymbolTypeCheckerIdentifier() {
        return String.valueOf(super.getSymbolTypeCheckerIdentifier()) + "/SubScoped//Method/";
    }
}

