/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.parser.debug;

import de.fzi.delphi.OPProjectManager;
import de.fzi.delphi.ProjectListEntry;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.ScopingEngine;
import de.fzi.delphi.symbols.StringTabelle;
import de.fzi.delphi.symbols.Symbol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import java.util.zip.ZipInputStream;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.DefaultMutableTreeNode;

public class ScopeTree {
    Scope rootScope;
    int closeAction = 3;
    public static int EXIT_ON_CLOSE = 3;
    public static int DISPOSE_ON_CLOSE = 2;
    private static boolean useSystemLookAndFeel = true;

    public ScopeTree(Scope scope) {
        this.rootScope = scope;
    }

    public void display(DefaultMutableTreeNode root) {
        if (useSystemLookAndFeel) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.err.println("Couldn't use system look and feel.");
            }
        }
        final JTree tree = new JTree(root);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JFrame.setDefaultLookAndFeelDecorated(true);
        tree.getSelectionModel().setSelectionMode(1);
        JScrollPane treeView = new JScrollPane(tree);
        panel.add((Component)treeView, "Center");
        panel.setPreferredSize(new Dimension(500, 600));
        final JEditorPane htmlPane = new JEditorPane();
        htmlPane.setContentType("text/html");
        HTMLEditorKit htmlkit = new HTMLEditorKit();
        StyleSheet stylesheet = new StyleSheet();
        stylesheet.addRule("table { background-color:#999999; }");
        stylesheet.addRule("th { background-color:#BBBBBB; font-weight:bold; }");
        stylesheet.addRule("td { background-color:#DDDDDD; }");
        htmlkit.setStyleSheet(stylesheet);
        htmlPane.setEditorKit(htmlkit);
        htmlPane.setEditable(false);
        JScrollPane htmlView = new JScrollPane(htmlPane);
        treeView.setPreferredSize(new Dimension(500, 400));
        htmlPane.setPreferredSize(new Dimension(500, 200));
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("Scope-Tree: " + this.rootScope.getFullName());
        frame.setDefaultCloseOperation(this.closeAction);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(treeView);
        splitPane.setBottomComponent(htmlView);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Scope scope;
                String currentPathcomp;
                String temp;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                node.getUserObject();
                if (node.isLeaf()) {
                    temp = "";
                    int i = 0;
                    while (i < e.getPath().getPath().length) {
                        currentPathcomp = e.getPath().getPath()[i].toString();
                        temp = currentPathcomp.indexOf(" ") != -1 ? String.valueOf(temp) + "." + currentPathcomp.substring(0, currentPathcomp.indexOf(" ")) : String.valueOf(temp) + "." + currentPathcomp;
                        ++i;
                    }
                    String path = temp.substring(1, temp.lastIndexOf("."));
                    scope = OPProjectManager.getProjectScope().getPartialSubScope(path);
                    if (!($assertionsDisabled || temp != null && scope != null)) {
                        throw new AssertionError();
                    }
                    Symbol sym = null;
                    sym = new ScopingEngine(scope).resolve(temp.substring(temp.lastIndexOf(".") + 1));
                    if (sym != null) {
                        htmlPane.setText("<table cellspacing=\"1\" cellpadding=\"1\">" + sym.getHtmlInfoString() + "</table>");
                    }
                }
                if (!node.isLeaf()) {
                    temp = "";
                    int i = 0;
                    while (i < e.getPath().getPath().length) {
                        currentPathcomp = e.getPath().getPath()[i].toString();
                        temp = currentPathcomp.indexOf(" ") != -1 ? String.valueOf(temp) + "." + currentPathcomp.substring(0, currentPathcomp.indexOf(" ")) : String.valueOf(temp) + "." + currentPathcomp;
                        ++i;
                    }
                    temp = temp.substring(1);
                    StringBuffer paneText = new StringBuffer();
                    paneText.append("<table cellspacing=\"0\" cellpadding=\"1\">" + OPProjectManager.getProjectScope().getPartialSubScope(temp).getHtmlInfoString() + "</table>");
                    scope = OPProjectManager.getProjectScope().getPartialSubScope(temp);
                    if (!scope.isRootScope()) {
                        if (scope.isCompilationUnit()) {
                            ProjectListEntry pe = OPProjectManager.getProjectListEntry(scope.getName());
                            if (scope.equals(OPProjectManager.getUnresolvedScope())) {
                                paneText.append("<h3>Unresolved Symbol Scope:</h3>");
                            } else {
                                paneText.append("<h3>Project list entry:</h3>");
                                paneText.append(pe.getHtmlInfoString());
                            }
                        }
                    } else {
                        paneText.append(scope.getHtmlInfoString());
                    }
                    htmlPane.setText(paneText.toString());
                }
            }
        });
        frame.setContentPane(splitPane);
        frame.pack();
        frame.setVisible(true);
    }

    public void display() {
        DefaultMutableTreeNode root = this.renderScope(this.rootScope);
        this.display(root);
    }

    private DefaultMutableTreeNode renderScope(Scope scope) {
        DefaultMutableTreeNode currentNode;
        ProjectListEntry pe = OPProjectManager.getProjectListEntry(scope.getName().toLowerCase());
        if (pe != null) {
            String append = "";
            append = pe.isPrimaryProjectFile() ? String.valueOf(append) + " (primary)" : String.valueOf(append) + " (interface)";
            if (!pe.isAnalyzed()) {
                append = String.valueOf(append) + "*";
            }
            currentNode = new DefaultMutableTreeNode(String.valueOf(scope.getName()) + append);
        } else if (scope != null && scope.getParent() != null) {
            if (scope.getCorrespondingSymbol() != null && scope.getCorrespondingSymbol().isInstanceOf("SubScoped")) {
                String className = scope.getCorrespondingSymbol().getClass().getName();
                className = className.substring(className.lastIndexOf(46) + 1);
                currentNode = new DefaultMutableTreeNode(String.valueOf(scope.getName()) + " {" + className + "}");
            } else {
                currentNode = new DefaultMutableTreeNode(String.valueOf(scope.getName()) + " {Scope}");
            }
        } else {
            currentNode = new DefaultMutableTreeNode(scope.getName());
        }
        Vector childScopes = new Vector(scope.getChildScopes());
        Collections.sort(childScopes, new ScopeComparator());
        Vector<String> childScopeNames = new Vector<String>();
        if (scope.getChildScopes().size() > 0) {
            ListIterator li = childScopes.listIterator();
            while (li.hasNext()) {
                Scope currentSubScope = (Scope)li.next();
                currentNode.add(this.renderScope(currentSubScope));
                childScopeNames.add(currentSubScope.getName());
            }
        }
        if (scope.getSymbols().size() > 0) {
            Vector symbolTable = new Vector(scope.getSymbols());
            Collections.sort(symbolTable, new SymbolComparator());
            ListIterator li = symbolTable.listIterator();
            while (li.hasNext()) {
                Symbol currentSymbol = (Symbol)li.next();
                if (childScopeNames.contains(currentSymbol.getName())) continue;
                currentNode.add(new DefaultMutableTreeNode(String.valueOf(currentSymbol.getName()) + " {" + currentSymbol.getClass().getName().substring(currentSymbol.getClass().getName().lastIndexOf(".") + 1) + "}"));
            }
        }
        if (scope.getSymbols().size() == 0 && scope.getChildScopes().size() == 0 && !scope.getName().equalsIgnoreCase("[error]")) {
            currentNode.add(new DefaultMutableTreeNode("(empty)"));
        }
        return currentNode;
    }

    public void setCloseAction(int closeAction) {
        this.closeAction = closeAction;
    }

    public static void main(String[] argv) {
        String filename = argv[0];
        Scope scope = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            ZipInputStream zis = new ZipInputStream(fis);
            zis.getNextEntry();
            ObjectInputStream ois = new ObjectInputStream(zis);
            StringTabelle.setTable((Hashtable)ois.readObject());
            scope = (Scope)ois.readObject();
            ois.close();
            zis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (scope != null) {
            ScopeTree st = new ScopeTree(scope);
            st.display();
        }
    }

    private Scope getRootScope() {
        return this.rootScope;
    }

    private void setRootScope(Scope scope) {
        this.rootScope = scope;
    }

    private class ScopeComparator
    implements Comparator {
        private ScopeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Scope && o2 instanceof Scope) {
                if (((Scope)o1).getName().equalsIgnoreCase("[Unresolved]")) {
                    return 1;
                }
                if (((Scope)o2).getName().equalsIgnoreCase("[Unresolved]")) {
                    return -1;
                }
                return ((Scope)o1).getName().compareTo(((Scope)o2).getName());
            }
            return 0;
        }
    }

    private class SymbolComparator
    implements Comparator {
        private SymbolComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Symbol && o2 instanceof Symbol) {
                return ((Symbol)o1).getName().compareTo(((Symbol)o2).getName());
            }
            return 0;
        }
    }
}

