/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.parser;

import de.fzi.delphi.symbols.types.PointerType;
import de.fzi.delphi.types.Type;

public class DelphiOperators {
    public static Type plus(Type t1, Type t2) {
        if (t1.isNilType() || t2.isNilType()) {
            return Type.getNilType();
        }
        if (t1.isNumber() && t2.isNumber()) {
            if (t1.isAssignmentCompatible(t2)) {
                return t2;
            }
            return t1;
        }
        if ((t1.isStringType() || t1.isPackedStringType() || t1.isCharacterType()) && (t2.isStringType() || t2.isPackedStringType() || t2.isCharacterType())) {
            if (t1.isAssignmentCompatible(t2)) {
                return t2;
            }
            return t1;
        }
        if (t1.isPointerType() && ((PointerType)t1).getBaseType().isCharacterType() && t2.isIntegerType()) {
            return t1;
        }
        if (t2.isPointerType() && ((PointerType)t2).getBaseType().isCharacterType() && t1.isIntegerType()) {
            return t2;
        }
        if (t1.isSetType() && t2.isSetType()) {
            return t1;
        }
        return Type.getNilType();
    }

    static Type minus(Type t1, Type t2) {
        if (t1.isNilType() || t2.isNilType()) {
            return Type.getNilType();
        }
        if (t1.isNumber() && t2.isNumber()) {
            if (t1.isAssignmentCompatible(t2)) {
                return t2;
            }
            return t1;
        }
        if (t1.isPointerType() && ((PointerType)t1).getBaseType().isCharacterType() && t2.isIntegerType()) {
            return t1;
        }
        if (t1.isPointerType() && t2.isPointerType() && ((PointerType)t1).isCharacterType() && ((PointerType)t2).isCharacterType()) {
            return Type.getIntegerType();
        }
        if (t1.isSetType() && t2.isSetType()) {
            return t1;
        }
        return Type.getNilType();
    }

    static Type multiply(Type t1, Type t2) {
        if (t1.isNilType() || t2.isNilType()) {
            return Type.getNilType();
        }
        if (t1.isNumber() && t2.isNumber()) {
            if (t1.isAssignmentCompatible(t2)) {
                return t2;
            }
            return t1;
        }
        if (t1.isSetType() && t2.isSetType()) {
            return t1;
        }
        return Type.getNilType();
    }

    static Type divide(Type t1, Type t2) {
        if (t1.isNilType() || t2.isNilType()) {
            return Type.getNilType();
        }
        if (t1.isNumber() && t2.isNumber()) {
            if (t1.isRealType() || t2.isRealType()) {
                return Type.getExtendedType();
            }
            if (t1.isInt64() || t2.isInt64()) {
                return Type.getInt64Type();
            }
            return Type.getIntegerType();
        }
        return Type.getNilType();
    }

    static Type integer(Type t1, Type t2) {
        if (t1.isIntegerType() && t2.isIntegerType()) {
            return t1;
        }
        return Type.getNilType();
    }

    static Type and(Type t1, Type t2) {
        if (t1.isBoolean() && t2.isBoolean()) {
            return t1;
        }
        if (t1.isIntegerType() && t2.isIntegerType()) {
            if (t1.isAssignmentCompatible(t2)) {
                return t1;
            }
            return t2;
        }
        return Type.getNilType();
    }

    static Type or(Type t1, Type t2) {
        return DelphiOperators.and(t1, t2);
    }

    static Type xor(Type t1, Type t2) {
        return DelphiOperators.and(t1, t2);
    }

    static Type not(Type t1) {
        if (t1.isBoolean()) {
            return t1;
        }
        if (t1.isIntegerType()) {
            return t1;
        }
        return Type.getNilType();
    }

    static Type shift(Type t1, Type t2) {
        if (t1.isIntegerType() && t2.isIntegerType()) {
            return t1;
        }
        return Type.getNilType();
    }

    static Type inEquality(Type t1, Type t2) {
        return Type.getBooleanType();
    }

    static Type equality(Type t1, Type t2) {
        return Type.getBooleanType();
    }

    static Type lesser(Type t1, Type t2) {
        return Type.getBooleanType();
    }

    static Type lesserOrEqual(Type t1, Type t2) {
        return Type.getBooleanType();
    }

    static Type greater(Type t1, Type t2) {
        return Type.getBooleanType();
    }

    static Type isA(Type t1, Type t2) {
        return Type.getBooleanType();
    }

    static Type as(Type t1, Type t2) {
        return t2;
    }

    static Type greaterOrEqual(Type t1, Type t2) {
        return Type.getBooleanType();
    }

    static Type unaryPlus(Type t1) {
        if (t1.isNumber()) {
            return t1;
        }
        return Type.getNilType();
    }

    static Type unaryMinus(Type t1) {
        if (t1.isNumber()) {
            return t1;
        }
        return Type.getNilType();
    }

    static Type inSet(Type t1, Type t2) {
        return Type.getBooleanType();
    }

    static Type dereference(Type t1) {
        if (t1 != null && t1.isInstanceOf("PointerType")) {
            return ((PointerType)t1).getBaseType();
        }
        return Type.getNilType();
    }

    static Type addressOp(Type t1) {
        return new PointerType("@" + t1.getName(), t1);
    }
}

