/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.output;

import de.fzi.delphi.OPProjectManager;
import de.fzi.delphi.output.IOPOutput;
import de.fzi.delphi.output.IOPOutputImplementation;
import de.fzi.delphi.symbols.Attribute;
import de.fzi.delphi.symbols.Method;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.ScopingEngine;
import de.fzi.delphi.symbols.ScopingException;
import de.fzi.delphi.symbols.SimpleSymbol;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.symbols.TypedSymbol;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.delphi.types.Type;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class SRFOutput
extends IOPOutputImplementation
implements IOPOutput {
    PrintStream out;
    public static String FIELD_SEP = "\t";
    private String rootScopeName = "";
    private String rootScopePath = String.valueOf(Scope.ROOT_SCOPE_NAME) + "." + this.rootScopeName;
    private String unresolvedScopePath = String.valueOf(this.rootScopePath) + "[unresolved]";
    private boolean headerWritten = false;

    public SRFOutput(OutputStream ostream) {
        this.setOutStream(ostream);
    }

    private String stringPreFormatter(String ident) {
        return ident;
    }

    private void createSymbolIfUnresolved(Symbol sym) {
        if (sym != null && sym.isInstanceOf("Type")) {
            if (!sym.isResolved()) {
                this.out.println("UnresolvedType" + FIELD_SEP + this.getFormattedString(sym.getScope(), (Type)sym));
            }
        } else if (sym != null && sym.isInstanceOf("Attribute") && !sym.isResolved()) {
            this.out.println("UnresolvedAtribute" + FIELD_SEP + this.getFormattedString(sym.getScope(), (Attribute)sym));
        }
    }

    public void writeHeader() {
        if (this.headerWritten) {
            return;
        }
        this.headerWritten = true;
        this.out.println("ENTITY-TYPE" + FIELD_SEP + "Class" + FIELD_SEP + "name" + FIELD_SEP + "isAbstract" + FIELD_SEP + "isInterface" + FIELD_SEP + "isFinal");
        this.out.println("ENTITY-TYPE" + FIELD_SEP + "Attribute" + FIELD_SEP + "sourceName" + FIELD_SEP + "hasType" + FIELD_SEP + "visibility");
        this.out.println("ENTITY-TYPE" + FIELD_SEP + "Method" + FIELD_SEP + "sourceName" + FIELD_SEP + "unqualifiedName" + FIELD_SEP + "totalLines" + FIELD_SEP + "commentLines" + FIELD_SEP + "branches" + FIELD_SEP + "statements");
        this.out.println("ENTITY-TYPE" + FIELD_SEP + "CompilationUnit" + FIELD_SEP + "name");
        this.out.println("ENTITY-TYPE" + FIELD_SEP + "File" + FIELD_SEP + "filename");
        this.out.println("ENTITY-TYPE" + FIELD_SEP + "UnresolvedType" + FIELD_SEP + "name");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "hasAttribute" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName" + FIELD_SEP + "visibility");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "containsAttribute" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName" + FIELD_SEP + "visibility");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "hasMethod" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "inheritsFrom" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "returns" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "calls" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "hasOverload" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "accesses" + FIELD_SEP + "method" + FIELD_SEP + "class");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "castsTo" + FIELD_SEP + "class" + FIELD_SEP + "class");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "usesCompilationUnit" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "containsGlobalClass" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "containsGlobalMethod" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "containsGlobalVariable" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "containsLocalVariable" + FIELD_SEP + "sourceName" + FIELD_SEP + "targetName");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "fileContainsClass" + FIELD_SEP + "fileName" + FIELD_SEP + "className");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "fileContainsCompilationUnit" + FIELD_SEP + "fileName" + FIELD_SEP + "unit");
        this.out.println("RELATION-TYPE" + FIELD_SEP + "hasParameter" + FIELD_SEP + "methodName" + FIELD_SEP + "parameterType");
    }

    @Override
    public void markAttributeReference(Scope location, Attribute v) {
    }

    @Override
    public void markTypeReference(Scope location, Type t) {
        String temp = this.getFormattedString(t.getScope(), t);
        StackTraceElement[] se = new RuntimeException().getStackTrace();
        int i = 0;
        while (i < se.length) {
            if (se[i].toString().startsWith("de.fzi.delphi.parser.OPReferencesParser")) break;
            ++i;
        }
        if (!t.isNilType()) {
            this.out.println("accesses" + FIELD_SEP + this.getFormattedString(location) + FIELD_SEP + temp);
            this.createSymbolIfUnresolved(t);
        }
    }

    @Override
    public void markTypeCast(Scope location, Type t) {
        this.out.println("castsTo" + FIELD_SEP + this.getFormattedString(location) + FIELD_SEP + this.getFormattedString(t.getScope(), t));
    }

    @Override
    public void markMethodReference(Scope source, Method f) {
        this.out.println("calls" + FIELD_SEP + this.getFormattedString(source) + FIELD_SEP + this.getFormattedString(f.getScope(), f));
    }

    @Override
    public void markAttributeDeclaration(Scope location, Attribute v) {
        Type t = v.getType();
        if (t != null) {
            if (v.isResolved()) {
                this.out.println("Attribute" + FIELD_SEP + this.getFormattedString(v.getScope(), v) + FIELD_SEP + "-" + FIELD_SEP + this.getFormattedString(t.getScope(), t) + FIELD_SEP + v.getVisibilityString());
            } else {
                this.out.println("UnresolvedAttribute" + FIELD_SEP + this.getFormattedString(v.getScope(), v) + FIELD_SEP + "-" + FIELD_SEP + this.getFormattedString(t.getScope(), t) + FIELD_SEP + v.getVisibilityString());
            }
            if (!t.isResolved()) {
                this.createSymbolIfUnresolved(t);
            }
        }
        if (v.getScope() != null) {
            if (v.getScope().isRootScope() || v.getScope().isCompilationUnit()) {
                if (t != null && t.getScope() != null) {
                    this.out.println("containsGlobalVariable" + FIELD_SEP + v.getScope() + FIELD_SEP + this.getFormattedString(t.getScope(), t));
                }
            } else if (v.getScope().isScopeOfMethod() && v.getType() != null) {
                if (!this.attributeIsParameter(v)) {
                    this.out.println("containsLocalVariable" + FIELD_SEP + this.getFormattedString(location) + FIELD_SEP + this.getFormattedString(v.getType().getScope(), v.getType()));
                }
            } else {
                this.out.println("containsAttribute" + FIELD_SEP + this.getFormattedString(location) + FIELD_SEP + this.getFormattedString(v.getScope(), v));
                if (t != null && !this.attributeIsParameter(v)) {
                    this.out.println("hasAttribute" + FIELD_SEP + this.getFormattedString(location) + FIELD_SEP + this.getFormattedString(t == null ? null : t.getScope(), t));
                }
            }
            if (t != null && !t.isResolved()) {
                this.out.println("UnresolvedType" + FIELD_SEP + this.getFormattedString(t == null ? null : t.getScope(), t));
            }
        }
    }

    @Override
    public void markTypeDeclaration(Scope location, Type t) {
        String filename;
        if (t.isResolved()) {
            this.out.print("Class" + FIELD_SEP);
            this.out.println(this.getFormattedString(t.getScope(), t));
        } else {
            this.out.print("UnresolvedType" + FIELD_SEP);
            this.out.println(this.getFormattedString(t.getScope(), t));
        }
        if (t.isInstanceOf("ClassType")) {
            for (Type currentSuperType : ((ClassType)t).getSuperClasses()) {
                if (currentSuperType == null || currentSuperType.getScope() == null || !currentSuperType.isResolved()) continue;
                this.out.println("inheritsFrom" + FIELD_SEP + this.getFormattedString(location, t) + FIELD_SEP + this.getFormattedString(currentSuperType.getScope(), currentSuperType));
            }
        }
        if (t != null && t.getScope() != null && t.getScope().getCompilationUnitScope() != null && (filename = this.getFilenameForScope(t.getScope().getCompilationUnitScope())).length() > 0) {
            this.out.println("fileContainsClass" + FIELD_SEP + filename + FIELD_SEP + this.getFormattedString(t.getScope(), t));
        }
        if (t.getScope() != null && (t.getScope().isCompilationUnit() || t.getScope().isRootScope())) {
            this.out.println("containsGlobalClass" + FIELD_SEP + t.getScope() + FIELD_SEP + this.getFormattedString(t.getScope(), t));
        }
    }

    @Override
    public void markMethodDeclaration(Scope location, Method f) {
        if (f.isResolved()) {
            this.out.print("Method" + FIELD_SEP + this.getFormattedString(f.getScope(), f) + FIELD_SEP + "-" + FIELD_SEP + this.getFormattedString(f) + FIELD_SEP + f.getVisibilityString());
        } else {
            this.out.print("UnresolvedMethod" + FIELD_SEP + this.getFormattedString(f.getScope(), f) + FIELD_SEP + "-" + FIELD_SEP + this.getFormattedString(f) + FIELD_SEP + f.getVisibilityString());
        }
        if (f.getCodeblockInfo() != null) {
            this.out.println(String.valueOf(FIELD_SEP) + f.getCodeblockInfo().getTotalLines() + FIELD_SEP + f.getCodeblockInfo().getCommentLines() + FIELD_SEP + f.getCodeblockInfo().getBranches() + FIELD_SEP + f.getCodeblockInfo().getStatements());
        } else {
            this.out.println(String.valueOf(FIELD_SEP) + "0" + FIELD_SEP + "0" + FIELD_SEP + "0" + FIELD_SEP + "0");
        }
        if (f.isOverloaded()) {
            String fullNameWithoutParameters = this.getFormattedString(f.getScope(), f);
            fullNameWithoutParameters = fullNameWithoutParameters.substring(0, fullNameWithoutParameters.indexOf(47));
            this.out.print("Method" + FIELD_SEP + fullNameWithoutParameters);
            String shortNameWithoutParams = this.getFormattedString(f);
            shortNameWithoutParams = shortNameWithoutParams.substring(0, shortNameWithoutParams.indexOf(47));
            this.out.print(String.valueOf(FIELD_SEP) + "-" + FIELD_SEP + shortNameWithoutParams);
            this.out.println(String.valueOf(FIELD_SEP) + "0" + FIELD_SEP + "0" + FIELD_SEP + "0" + FIELD_SEP + "0");
            this.out.println("hasOverload" + FIELD_SEP + fullNameWithoutParameters + FIELD_SEP + this.getFormattedString(f.getScope(), f));
        }
        if (f.getScope() != null && (f.getScope().isCompilationUnit() || f.getScope().isRootScope())) {
            this.out.println("containsGlobalMethod" + FIELD_SEP + this.getFormattedString(f.getScope()) + FIELD_SEP + this.getFormattedString(f.getScope(), f));
        } else {
            this.out.println("hasMethod" + FIELD_SEP + this.getFormattedString(f.getScope()) + FIELD_SEP + this.getFormattedString(f.getScope(), f));
        }
        if (f.getType() != null && !f.getType().isNilType() && f.getCategory() != 1) {
            this.out.println("returns" + FIELD_SEP + this.getFormattedString(f.getScope(), f) + FIELD_SEP + this.getFormattedString(f.getType().getScope(), f.getType()));
        }
        if (f.isResolved() && f.getParameters() != null) {
            for (Symbol currentParam : f.getParameters()) {
                Type currentParamType;
                if (!currentParam.isInstanceOf("TypedSymbol") || (currentParamType = ((TypedSymbol)currentParam).getType()) == null) continue;
                this.out.println("hasParameter" + FIELD_SEP + this.getFormattedString(f.getScope(), f) + FIELD_SEP + this.getFormattedString(currentParamType.getScope(), currentParamType));
            }
        }
    }

    @Override
    public void close() {
    }

    private String getFormattedString(Scope scope, SimpleSymbol sym) {
        String temp = "";
        if (sym != null) {
            if (sym.getScope() != null && sym.getScope().isRootScope()) {
                temp = String.valueOf(Scope.ROOT_SCOPE_NAME) + "." + sym.getName();
            } else {
                temp = this.getFormattedString(scope);
                if (temp.length() > 0) {
                    temp = String.valueOf(temp) + ".";
                }
                temp = String.valueOf(temp) + this.getFormattedString(sym);
            }
        }
        return this.stringPreFormatter(temp);
    }

    private String getFormattedString(Scope scope) {
        String temp = "";
        temp = scope == null || scope.isRootScope() && scope.getName() == null ? this.rootScopeName : scope.getFullName();
        return this.stringPreFormatter(temp);
    }

    private String getFormattedString(SimpleSymbol sym) {
        StringBuffer temp = new StringBuffer(this.stringPreFormatter(sym.getName()));
        if (sym.isMethod() && ((Method)sym).isOverloaded()) {
            temp.append("/" + ((Method)sym).parameterListToString());
        }
        return temp.toString();
    }

    public void setOutStream(OutputStream stream) {
        this.out = new PrintStream(stream);
    }

    public void setRootScopeName(String string) {
        this.rootScopeName = string;
        this.rootScopePath = String.valueOf(string) + ".";
    }

    @Override
    public void markNewCompilationUnit(String name) {
        this.out.println("CompilationUnit" + FIELD_SEP + name);
        if (this.getFilenameForQualifier(name) == null) {
            return;
        }
        this.out.println("File" + FIELD_SEP + this.getFilenameForQualifier(name));
        this.out.println("fileContainsCompilationUnit" + FIELD_SEP + this.getFilenameForQualifier(name) + FIELD_SEP + name);
    }

    @Override
    public void markUsesCompilationUnit(Scope location, String name) {
        this.out.println("usesCompilationUnit" + FIELD_SEP + this.getFormattedString(location) + FIELD_SEP + name);
    }

    private void markSymbol(Symbol sym) {
        if (sym == null) {
            return;
        }
        if (sym.isInstanceOf("SimpleSymbol")) {
            if (sym.isInstanceOf("Attribute")) {
                this.markAttributeDeclaration(((SimpleSymbol)sym).getScope(), (Attribute)sym);
            }
            if (sym.isInstanceOf("Method")) {
                this.markMethodDeclaration(((SimpleSymbol)sym).getScope(), (Method)sym);
            }
            if (sym.isInstanceOf("Type")) {
                this.markTypeDeclaration(((SimpleSymbol)sym).getScope(), (Type)sym);
            }
        }
    }

    @Override
    public void printAllScopeEntities(Scope scope) {
        if (!scope.isRootScope()) {
            if (scope.getParent().isRootScope()) {
                if (scope.getCorrespondingSymbol() != null && scope.getCorrespondingSymbol().isInstanceOf("CompilationUnit")) {
                    this.markNewCompilationUnit(scope.getFullName());
                } else if (scope.isUnresolvedScope() && scope.getSymbols().size() > 0) {
                    this.markNewCompilationUnit(scope.getFullName());
                }
            }
        } else {
            this.printCommentLine("dumping declarations");
            this.markNewCompilationUnit(scope.getFullName());
        }
        Iterator symbolIterator = scope.getSymbols().iterator();
        while (symbolIterator.hasNext()) {
            this.markSymbol((Symbol)symbolIterator.next());
        }
        Iterator scopeIterator = scope.getChildScopes().iterator();
        while (scopeIterator.hasNext()) {
            this.printAllScopeEntities((Scope)scopeIterator.next());
        }
    }

    @Override
    public void printCommentLine(String comment) {
        this.out.println("% " + comment);
    }

    private String getFilenameForScope(Scope scope) {
        if (scope != null && this.getFilenameForQualifier(scope.getFullName()) != null) {
            return this.getFilenameForQualifier(scope.getFullName());
        }
        return "";
    }

    private String getFilenameForQualifier(String scopeQualifier) {
        String unitName = null;
        String name = scopeQualifier;
        String filename = null;
        if (scopeQualifier == null || scopeQualifier.equalsIgnoreCase(Scope.ROOT_SCOPE_NAME) || scopeQualifier.equalsIgnoreCase(String.valueOf(Scope.ROOT_SCOPE_NAME) + ".[Unresolved]")) {
            return null;
        }
        if (name.indexOf(".") != -1 && (unitName = name.substring(name.indexOf(".") + 1)).indexOf(".") != -1) {
            unitName = unitName.substring(unitName.indexOf("."));
        }
        if (unitName != null && OPProjectManager.getFilenameForCompilationUnit(unitName) != null) {
            filename = OPProjectManager.getFilenameForCompilationUnit(unitName);
        }
        if (filename == null) {
            if (unitName != null && !unitName.toLowerCase().endsWith(this.unresolvedScopePath.substring(this.unresolvedScopePath.lastIndexOf(".") + 1))) {
                filename = String.valueOf(unitName) + ".pas";
            } else if (name != null && !name.toLowerCase().endsWith(this.unresolvedScopePath.substring(this.unresolvedScopePath.lastIndexOf(".") + 1))) {
                filename = String.valueOf(name) + ".pas";
            }
        }
        if (filename != null) {
            filename = filename.replaceFirst("\\.pas$", "_PAS");
        }
        return filename;
    }

    private boolean attributeIsParameter(Attribute attr) {
        if (attr.getScope() != null && attr.getScope().isScopeOfMethod() && attr.getScope().getParent() != null) {
            Symbol sym = attr.getScope().getCorrespondingSymbol();
            ScopingEngine se = null;
            try {
                se = new ScopingEngine(attr.getScope().getRootScope(), attr.getScope().getParent());
            }
            catch (ScopingException e) {
                throw new RuntimeException(e);
            }
            sym = se.resolve(attr.getScope().getFullName());
            if (sym != null && sym.isInstanceOf("Method") && ((Method)sym).getParameters().contains(attr)) {
                return true;
            }
        }
        return false;
    }
}

