/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.output;

import de.fzi.delphi.output.IOPOutput;
import de.fzi.delphi.output.IOPOutputImplementation;
import de.fzi.delphi.symbols.Attribute;
import de.fzi.delphi.symbols.Method;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.SimpleSymbol;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.delphi.types.Type;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ListIterator;

public class GraphvizOutput
extends IOPOutputImplementation
implements IOPOutput {
    PrintStream out;
    private static String rootScopeName = "<root-scope>";
    private static String rootScopePath = "";
    private static String rootScopeStyle = "[shape=house,style=filled,color=\"violetred\"]";
    private static String variableStyle = "[shape=box,style=filled,color=\"springgreen\"]";
    private static String variableDeclStyle = "[label=\"declares\",color=\"springgreen\"]";
    private static String variableRefStyle = "[label=\"uses\",color=\"springgreen\"]";
    private static String typeStyle = "[shape=diamond,style=filled,color=\".7 .3 1.0\"]";
    private static String preDefTypeStyle = "[shape=diamond,style=filled,color=\".6 .3 1.0\"]";
    private static String typeDeclStyle = "[label=\"declares\",color=\".7 .3 1.0\"]";
    private static String typeRefStyle = "[label=\"usesType\",color=\".7 .3 1.0\"]";
    private static String hasTypeStyle = "[label=\"hasType\",color=\".7 .3 1.0\"]";
    private static String methodStyle = "[shape=triangle,style=filled,color=\"crimson\"]";
    private static String methodDeclStyle = "[color=\"crimson\",label=\"declares\"]";
    private static String methodCallStyle = "[color=\"crimson\",label=\"calls\"]";

    public GraphvizOutput() {
        try {
            this.out = new PrintStream(new FileOutputStream("output.dot"));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.out.println("digraph OP {");
        this.out.println("size=\"7.5,10.9\"");
        this.out.println("ratio=fill");
        this.out.println("\"" + rootScopeName + "\" " + rootScopeStyle + ";");
        this.out.println("\"" + rootScopePath + "<array>\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "<record>\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "<range>\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "<enum>\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "<file>\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "<class>\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "<set>\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "nil\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "integer\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "string\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "double\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "real\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "boolean\" " + preDefTypeStyle + ";");
        this.out.println("\"" + rootScopePath + "tobject\" " + preDefTypeStyle + ";");
    }

    @Override
    public void markAttributeReference(Scope location, Attribute v) {
        this.out.print(this.getFormattedString(location));
        this.out.print("->");
        this.out.print(this.getFormattedString(v));
        this.out.print(" " + variableRefStyle);
        this.out.println(";");
    }

    @Override
    public void markTypeReference(Scope location, Type t) {
        this.out.print(this.getFormattedString(location));
        this.out.print("->");
        this.out.print(this.getFormattedString(t));
        this.out.print(" " + typeRefStyle);
        this.out.println(";");
    }

    @Override
    public void markMethodReference(Scope location, Method f) {
        this.out.print(this.getFormattedString(location, f));
        this.out.println(" " + methodStyle + ";");
        this.out.print(this.getFormattedString(location));
        this.out.print("->");
        this.out.print(this.getFormattedString(location, f));
        this.out.print(" " + methodCallStyle);
        this.out.println(";");
    }

    @Override
    public void markAttributeDeclaration(Scope location, Attribute v) {
        this.out.println(String.valueOf(this.getFormattedString(location, v)) + " " + variableStyle + ";");
        this.out.print(this.getFormattedString(location));
        this.out.print("->");
        this.out.print(this.getFormattedString(location, v));
        this.out.print(" " + variableDeclStyle);
        this.out.println(";");
        Type t = v.getType();
        this.out.print(this.getFormattedString(v));
        this.out.print("->");
        this.out.print(this.getFormattedString(t));
        this.out.print(" " + hasTypeStyle);
        this.out.println(";");
    }

    @Override
    public void markTypeDeclaration(Scope location, Type t) {
        this.out.println(String.valueOf(this.getFormattedString(t)) + " " + typeStyle + ";");
        this.out.print(this.getFormattedString(location));
        this.out.print("->");
        this.out.print(this.getFormattedString(t));
        this.out.print(" " + typeDeclStyle);
        this.out.println(";");
        if (t != null && t.isInstanceOf("ClassType")) {
            ListIterator li = ((ClassType)t).getSuperClasses().listIterator();
            while (li.hasNext()) {
                Type currentType = (Type)li.next();
                this.out.print(this.getFormattedString(location, t));
                this.out.print("->");
                this.out.print("\"");
                if (currentType.getScope() == null || currentType.getScope().isRootScope()) {
                    this.out.print(rootScopePath);
                } else {
                    this.out.print(String.valueOf(currentType.getScope().getFullName().toLowerCase()) + ".");
                }
                this.out.print(currentType.getName().toLowerCase());
                this.out.print("\"");
                this.out.print(" " + hasTypeStyle);
                this.out.println();
            }
        }
    }

    @Override
    public void markMethodDeclaration(Scope location, Method f) {
    }

    @Override
    public void close() {
        this.out.println("}");
    }

    private String getFormattedString(Scope scope, SimpleSymbol sym) {
        String temp = "\"";
        temp = scope.isRootScope() ? String.valueOf(temp) + rootScopePath : String.valueOf(temp) + scope.getFullName().toLowerCase() + ".";
        temp = String.valueOf(temp) + sym.getName().toLowerCase();
        temp = String.valueOf(temp) + "\"";
        return temp.toLowerCase();
    }

    private String getFormattedString(Scope scope) {
        String temp = "\"";
        temp = scope.isRootScope() ? String.valueOf(temp) + rootScopeName : String.valueOf(temp) + scope.getFullName().toLowerCase();
        temp = String.valueOf(temp) + "\"";
        return temp.toLowerCase();
    }

    private String getFormattedString(SimpleSymbol sym) {
        String temp = "\"";
        temp = sym.getScope() == null || sym.getScope().isRootScope() ? String.valueOf(temp) + rootScopePath : String.valueOf(temp) + sym.getScope().getFullName().toLowerCase() + ".";
        temp = String.valueOf(temp) + sym.getName().toLowerCase();
        temp = String.valueOf(temp) + "\"";
        return temp.toLowerCase();
    }

    @Override
    public void markNewCompilationUnit(String name) {
    }

    @Override
    public void markUsesCompilationUnit(Scope location, String name) {
    }

    @Override
    public void printAllScopeEntities(Scope scope) {
    }

    @Override
    public void markTypeCast(Scope location, Type t) {
    }

    @Override
    public void printCommentLine(String comment) {
        this.out.println("//" + comment);
    }
}

