/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.dialog;

import de.fzi.delphi.OPMain;
import de.fzi.delphi.dialog.PascalFileFilter;
import de.fzi.delphi.dialog.ProjectFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.UIManager;

public class ProjectListDialog
extends JDialog {
    private JList jList1;
    private JPanel jPanel1;
    private JButton jButtonRemove;
    private JButton jButtonRun;
    private JButton jButton3;
    private JButton jButton2;
    private JButton jButton1;
    private List fileList = new Vector();
    String projectFilename = null;
    private JDialog mainFrame;

    public ProjectListDialog() throws HeadlessException {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initGUI();
        this.mainFrame = this;
    }

    public static void main(String[] args) {
        ProjectListDialog pd = new ProjectListDialog();
        pd.show();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setTitle("Project List Editor");
            this.setSize(508, 427);
            this.getContentPane().setLayout(thisLayout);
            DefaultComboBoxModel<Object> jList1Model = new DefaultComboBoxModel<Object>(this.fileList.toArray());
            this.jList1 = new JList();
            this.getContentPane().add((Component)this.jList1, "Center");
            this.jList1.setModel(jList1Model);
            this.jPanel1 = new JPanel();
            this.getContentPane().add((Component)this.jPanel1, "South");
            this.jButton1 = new JButton();
            this.jPanel1.add(this.jButton1);
            this.jButton1.setText("Load List ...");
            this.jButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JFileChooser jfc = new JFileChooser(System.getProperty("user.dir"));
                    jfc.setFileFilter(new ProjectFileFilter());
                    jfc.setMultiSelectionEnabled(false);
                    if (jfc.showOpenDialog(ProjectListDialog.this.mainFrame) == 0) {
                        ProjectListDialog.this.projectFilename = jfc.getSelectedFile().getAbsolutePath();
                        if (ProjectListDialog.this.projectFilename.toLowerCase().endsWith(".dpr")) {
                            ListIterator li = OPMain.readDprFile(ProjectListDialog.this.projectFilename).listIterator();
                            ListModel lm = ProjectListDialog.this.jList1.getModel();
                            while (li.hasNext()) {
                                String current = (String)li.next();
                                ProjectListDialog.this.fileList.add(current);
                                if (!(lm instanceof DefaultComboBoxModel)) continue;
                                ((DefaultComboBoxModel)lm).addElement(current);
                            }
                        } else if (ProjectListDialog.this.projectFilename.toLowerCase().endsWith(".lst")) {
                            ListIterator li = OPMain.readFileList(ProjectListDialog.this.projectFilename).listIterator();
                            ListModel lm = ProjectListDialog.this.jList1.getModel();
                            while (li.hasNext()) {
                                String current = (String)li.next();
                                ProjectListDialog.this.fileList.add(current);
                                if (!(lm instanceof DefaultComboBoxModel)) continue;
                                ((DefaultComboBoxModel)lm).addElement(current);
                            }
                        }
                        ProjectListDialog.this.jList1.repaint();
                    }
                }
            });
            this.jButton2 = new JButton();
            this.jPanel1.add(this.jButton2);
            this.jButton2.setText("Save List ...");
            this.jButton2.setEnabled(false);
            this.jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JFileChooser jfc = new JFileChooser(System.getProperty("user.dir"));
                    jfc.setFileFilter(new ProjectFileFilter());
                    jfc.setMultiSelectionEnabled(false);
                    jfc.showSaveDialog(ProjectListDialog.this.mainFrame);
                }
            });
            this.jButton3 = new JButton();
            this.jPanel1.add(this.jButton3);
            this.jButton3.setText("Add File(s) ...");
            this.jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    JFileChooser jfc = new JFileChooser(System.getProperty("user.dir"));
                    jfc.setFileFilter(new PascalFileFilter());
                    jfc.setMultiSelectionEnabled(true);
                    if (jfc.showOpenDialog(ProjectListDialog.this.mainFrame) == 0) {
                        File[] fl = jfc.getSelectedFiles();
                        ListModel lm = ProjectListDialog.this.jList1.getModel();
                        int i = 0;
                        while (i < fl.length) {
                            ProjectListDialog.this.fileList.add(fl[i]);
                            if (lm instanceof DefaultComboBoxModel) {
                                ((DefaultComboBoxModel)lm).addElement(fl[i].getName());
                            }
                            ++i;
                        }
                        ProjectListDialog.this.jList1.repaint();
                    }
                }
            });
            this.jButtonRemove = new JButton();
            this.jPanel1.add(this.jButtonRemove);
            this.jButtonRemove.setText("Remove");
            this.jButtonRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    System.out.println("jButtonRemove.actionPerformed, event=" + evt);
                    ListModel lm = ProjectListDialog.this.jList1.getModel();
                    if (lm instanceof DefaultComboBoxModel) {
                        Object current = ((DefaultComboBoxModel)lm).getElementAt(ProjectListDialog.this.jList1.getSelectedIndex());
                        ((DefaultComboBoxModel)lm).removeElement(current);
                        ProjectListDialog.this.fileList.remove(current);
                    }
                }
            });
            this.jButtonRun = new JButton();
            this.jPanel1.add(this.jButtonRun);
            this.jButtonRun.setToolTipText("Run analysis");
            this.jButtonRun.setText("Run");
            this.jButtonRun.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ProjectListDialog.this.mainFrame.dispose();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List getFileList() {
        return this.fileList;
    }

    public String getProjectFilename() {
        return this.projectFilename;
    }
}

