/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import de.fzi.delphi.CommonASTWithLineNumber;
import de.fzi.delphi.OPDebug;
import de.fzi.delphi.OPProjectManager;
import de.fzi.delphi.parser.AsmLexer;
import de.fzi.delphi.parser.OPDeclarationsParser;
import de.fzi.delphi.parser.OPInterface;
import de.fzi.delphi.parser.OPLexer;
import de.fzi.delphi.parser.OPParser;
import de.fzi.delphi.parser.OPReferencesParser;
import de.fzi.delphi.parser.OPTransformer;
import de.fzi.delphi.parser.debug.ExpandableASTFrame;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.tree.TreePath;

public class ProjectListEntry {
    private String filename = null;
    private String unitname = null;
    private long totalLines = 0L;
    private long commentLines = 0L;
    private long asmLines = 0L;
    private boolean isPrimaryProjectFile;
    private boolean analyzed = false;
    private boolean aborted = false;
    private boolean excluded = false;
    private CommonASTWithLineNumber AST = null;

    public ProjectListEntry(String filename, String unitname) {
        this.filename = filename;
        this.setExcluded(false);
        this.setUnitname(unitname);
        this.setPrimaryProjectFile(false);
    }

    public ProjectListEntry(String filename, String unitname, boolean isPrimaryProjectFile) {
        this.filename = filename;
        this.setExcluded(false);
        this.setUnitname(unitname);
        this.setPrimaryProjectFile(isPrimaryProjectFile);
    }

    public ProjectListEntry(String filename) {
        this.filename = filename;
        this.setExcluded(false);
        this.setPrimaryProjectFile(false);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getUnitname() {
        return this.unitname.toLowerCase();
    }

    public void setUnitname(String unitName) {
        this.unitname = unitName;
    }

    public boolean isPrimaryProjectFile() {
        return this.isPrimaryProjectFile;
    }

    public void setPrimaryProjectFile(boolean isPrimary) {
        this.isPrimaryProjectFile = isPrimary;
    }

    private void readInterfaceDeclarations() {
        String astNodeClass = "de.fzi.delphi.CommonASTWithLineNumber";
        if (this.filename == null) {
            System.err.println("Unit '" + this.getUnitname() + "' not found");
            this.aborted = true;
            return;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File '" + this.filename + "' not found.");
            this.aborted = true;
            return;
        }
        catch (SecurityException securityException) {
            System.err.println("Can't read file '" + this.filename + "'.");
            this.aborted = true;
            return;
        }
        OPDebug.debugPrintln(1);
        OPDebug.debugPrintln(1, "=============================================================================");
        if (this.isPrimaryProjectFile()) {
            OPDebug.debugPrintln(1, "*** Reading interface from " + this.getFilename() + " ***");
        } else {
            OPDebug.debugPrintln(1, "=== Reading interface from " + this.getFilename() + " ===");
        }
        OPDebug.debugPrintln(1, "=============================================================================");
        OPLexer mainLexer = new OPLexer(inputStream);
        this.asmLines = mainLexer.getAsmLines();
        this.commentLines = mainLexer.getCommentLines();
        this.totalLines = mainLexer.getCurrentLine();
        OPParser parser = new OPParser(mainLexer);
        if (this.getFilename() != null) {
            parser.setCurrentFilename(this.getFilename());
        }
        parser.setLexer(mainLexer);
        parser.setASTNodeClass(astNodeClass);
        try {
            parser.goal();
        }
        catch (RecognitionException e1) {
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error while parsing interface", (Exception)((Object)e1));
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        catch (TokenStreamException e1) {
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error while parsing interface", (Exception)((Object)e1));
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException e4) {
            throw new RuntimeException(e4);
        }
        if ((String)OPProjectManager.getProperties().get("unit-dependencies") != null) {
            OPDebug.debugPrintln(1, "dumping unit-dependencies only ...");
            this.dumpUnitDependencies(parser.getUsesList().listIterator());
            this.setAnalyzed(true);
            return;
        }
        OPTransformer transformer = new OPTransformer();
        transformer.setASTNodeClass(astNodeClass);
        try {
            transformer.goal(parser.getAST());
        }
        catch (RecognitionException e2) {
            OPDebug.debugPrint(2, "Error in transforming analysis of file " + this.getFilename() + ". Aborting.");
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error while transforming interface", (Exception)((Object)e2));
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        catch (Exception e2) {
            OPDebug.debugPrint(2, "Error in transforming analysis of file " + this.getFilename() + ". Aborting.");
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error while transforming interface", e2);
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        OPInterface interfaces = new OPInterface();
        interfaces.setASTNodeClass(astNodeClass);
        try {
            interfaces.goal(transformer.getAST());
        }
        catch (RecognitionException e3) {
            OPDebug.debugPrint(2, "Error in transforming analysis of file " + this.getFilename() + ". Aborting.");
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error while analysing interface", (Exception)((Object)e3));
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        catch (Exception e3) {
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error while analysing interface", e3);
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        this.asmLines = mainLexer.getAsmLines();
        this.commentLines = mainLexer.getCommentLines();
        this.totalLines = mainLexer.getCurrentLine();
    }

    private void showTreeFrame(OPParser parser, CommonAST ast, String title, Point screenLocation) {
        this.showTreeFrame(parser.getTokenNames(), ast, title, screenLocation);
    }

    private void showTreeFrame(String[] tokenNames, CommonAST ast, String title, Point screenLocation) {
        String searchString = "Fields15";
        boolean expandAll = false;
        CommonAST.setVerboseStringConversion((boolean)true, (String[])tokenNames);
        ASTFactory factory = new ASTFactory();
        AST r = factory.create(0, "AST ROOT");
        r.setFirstChild((AST)ast);
        ExpandableASTFrame frame = new ExpandableASTFrame(title, r);
        if (searchString != null) {
            ListIterator placesOfDiscovery = frame.tp.findInTree(searchString).listIterator();
            TreePath firstHit = null;
            while (placesOfDiscovery.hasNext()) {
                TreePath tpath = (TreePath)placesOfDiscovery.next();
                if (firstHit == null) {
                    firstHit = tpath;
                }
                if (tpath == null) continue;
                frame.tp.tree.addSelectionPath(tpath);
                frame.tp.expandAll(tpath, true);
                if (tpath.getParentPath() == null) continue;
                frame.tp.expandAll(tpath.getParentPath(), true);
            }
            if (firstHit != null) {
                frame.tp.tree.scrollPathToVisible(firstHit);
            }
        } else if (expandAll) {
            frame.tp.expandAll(true);
        }
        frame.setSize(400, 996);
        frame.setLocation(screenLocation);
        frame.setVisible(true);
    }

    public int hashCode() {
        return this.unitname.toLowerCase().hashCode();
    }

    public String toString() {
        String status = this.isPrimaryProjectFile() ? "Primary" : "Secondary";
        if (this.isAborted()) {
            status = String.valueOf(status) + ": aborted";
        } else if (this.isAnalyzed()) {
            status = String.valueOf(status) + ": analyzed";
        } else if (this.isExcluded()) {
            status = String.valueOf(status) + ": excluded";
        }
        return String.valueOf(this.filename) + " [" + this.unitname + "] " + status;
    }

    public long getTotalLines() {
        if (!this.aborted) {
            return this.totalLines;
        }
        return 0L;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    private void setAnalyzed(boolean analyzed) {
        this.analyzed = analyzed;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public String getHtmlInfoString() {
        StringBuffer retStr = new StringBuffer();
        retStr.append("<tr>");
        retStr.append("<th>Unit name:</th>");
        retStr.append("<td>" + this.getUnitname() + "</td>");
        retStr.append("</tr>");
        retStr.append("<tr>");
        retStr.append("<th>Projekt-File:</th>");
        retStr.append("<td>" + this.isPrimaryProjectFile() + "</td>");
        retStr.append("</tr>");
        retStr.append("<tr>");
        retStr.append("<th>Filename:</th>");
        retStr.append("<td>" + this.getFilename() + "</td>");
        retStr.append("</tr>");
        retStr.append("<tr>");
        retStr.append("<th>Lines:</th>");
        retStr.append("<td>" + this.getTotalLines() + "</td>");
        retStr.append("</tr>");
        retStr.append("<tr>");
        retStr.append("<th>Status:</th>");
        retStr.append("<td>");
        if (this.isAborted()) {
            retStr.append("aborted");
        } else if (this.isExcluded()) {
            retStr.append("excluded");
        } else if (this.isAnalyzed()) {
            retStr.append("analyzed");
        }
        retStr.append("</td>");
        retStr.append("</tr>");
        return retStr.toString();
    }

    private void dumpUnitDependencies(Iterator unitIterator) {
        PrintStream unitDependencyStream = OPProjectManager.getUnitDependencySRFStream();
        if (unitIterator.hasNext() && unitDependencyStream != null) {
            String currentUnit = (String)unitIterator.next();
            unitDependencyStream.println("Unit\t" + currentUnit);
            while (unitIterator.hasNext()) {
                String current = (String)unitIterator.next();
                unitDependencyStream.println("Unit\t" + current);
                unitDependencyStream.println("uses\t" + currentUnit + "\t" + current);
            }
        }
    }

    private CommonASTWithLineNumber getAST() {
        return this.AST;
    }

    private void setAST(CommonASTWithLineNumber ast) {
        this.AST = ast;
    }

    public void readDeclarations() {
        if (this.isExcluded()) {
            OPDebug.debugPrintln(1);
            OPDebug.debugPrintln(1, "=============================================================================");
            OPDebug.debugPrintln(1, "=== Skipping excluded file " + this.getFilename() + " ===");
            OPDebug.debugPrintln(1, "=============================================================================");
            return;
        }
        if (!this.isAnalyzed()) {
            this.setAnalyzed(true);
            if (!this.isPrimaryProjectFile()) {
                this.readInterfaceDeclarations();
                return;
            }
        }
        OPDebug.debugPrintln(1, "Current file " + this.getFilename() + " ... ");
        String astNodeClass = "de.fzi.delphi.CommonASTWithLineNumber";
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.getFilename());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File '" + this.getFilename() + "' not found.");
            this.aborted = true;
            return;
        }
        catch (SecurityException securityException) {
            System.err.println("Can't read file '" + this.getFilename() + "'.");
            this.aborted = true;
            return;
        }
        OPDebug.debugPrintln(1);
        OPDebug.debugPrintln(1, "=============================================================================");
        if (this.isPrimaryProjectFile()) {
            OPDebug.debugPrintln(1, "*** Parsing input file " + this.getFilename() + " ***");
        } else {
            OPDebug.debugPrintln(1, "=== Parsing input file " + this.getFilename() + " ===");
        }
        OPDebug.debugPrintln(1, "=============================================================================");
        OPLexer mainLexer = new OPLexer(inputStream);
        mainLexer.setTokenObjectClass("de.fzi.delphi.symbols.TokenWithStartPosition");
        AsmLexer asmLexer = new AsmLexer(mainLexer.getInputState());
        asmLexer.setTokenObjectClass("antlr.CommonHiddenStreamToken");
        OPLexer.selector.addInputStream((TokenStream)mainLexer, "main");
        OPLexer.selector.addInputStream((TokenStream)asmLexer, "asmlexer");
        OPLexer.selector.select("main");
        OPParser parser = new OPParser((TokenStream)OPLexer.selector);
        if (this.getFilename() != null) {
            parser.setCurrentFilename(this.getFilename());
        }
        parser.setLexer(mainLexer);
        parser.setASTNodeClass(astNodeClass);
        try {
            parser.goal();
        }
        catch (RecognitionException e1) {
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Parsing error", (Exception)((Object)e1));
            OPDebug.debugPrint(2, "Parsing error in " + this.getFilename() + ". Aborting analysis.");
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        catch (TokenStreamException e1) {
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Parsing error", (Exception)((Object)e1));
            OPDebug.debugPrint(2, "Parsing error in " + this.getFilename() + ". Aborting analysis.");
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        try {
            ((InputStream)inputStream).close();
        }
        catch (IOException e4) {
            throw new RuntimeException(e4);
        }
        if ((String)OPProjectManager.getProperties().get("unit-dependencies") != null) {
            OPDebug.debugPrintln(1, "dumping unit-dependencies only ...");
            this.dumpUnitDependencies(parser.getUsesList().listIterator());
            this.setAnalyzed(true);
            return;
        }
        if (((String)OPProjectManager.getProperties().get("showParseTree")).equalsIgnoreCase("true")) {
            this.showTreeFrame(parser, (CommonAST)parser.getAST(), "OPParser - " + (this.getUnitname() != null ? this.getUnitname() : this.getFilename()), new Point(0, 24));
        }
        OPDebug.debugPrintln(1);
        if (this.isPrimaryProjectFile()) {
            OPDebug.debugPrintln(1, "*** Transforming AST of " + this.getFilename() + " ***");
        } else {
            OPDebug.debugPrintln(1, "=== Transforming AST of " + this.getFilename() + " ===");
        }
        OPTransformer transformer = new OPTransformer();
        transformer.setASTNodeClass(astNodeClass);
        try {
            transformer.goal(parser.getAST());
        }
        catch (RecognitionException e2) {
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Transformation error", (Exception)((Object)e2));
            OPDebug.debugPrint(2, "Transformation error in " + this.getFilename() + ". Aborting analysis.");
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        catch (Exception e2) {
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Transformation error", e2);
            OPDebug.debugPrint(2, "Transformation error in " + this.getFilename() + ". Aborting analysis.");
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        if (((String)OPProjectManager.getProperties().get("showTransformedTree")).equalsIgnoreCase("true")) {
            this.showTreeFrame(parser, (CommonAST)transformer.getAST(), "OPTransformer - " + (this.getUnitname() != null ? this.getUnitname() : this.getFilename()), new Point(300, 24));
        }
        if (this.isPrimaryProjectFile()) {
            OPDebug.debugPrintln(1, "*** Collecting declarations of " + this.getFilename() + " ***");
        } else {
            OPDebug.debugPrintln(1, "=== Collecting declarations of " + this.getFilename() + " ===");
        }
        OPDeclarationsParser declParser = new OPDeclarationsParser();
        declParser.setASTNodeClass(astNodeClass);
        try {
            declParser.goal(transformer.getAST());
        }
        catch (RecognitionException e3) {
            OPDebug.debugPrint(2, "Error in declaration analysis of file " + this.getFilename() + ". Aborting.");
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error in declaration analysis", (Exception)((Object)e3));
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        catch (Exception e3) {
            OPDebug.debugPrint(2, "Error in declaration analysis of file " + this.getFilename() + ". Aborting.");
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error in declaration analysis", e3);
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        if (((String)OPProjectManager.getProperties().get("showSymbolTree")).equalsIgnoreCase("true")) {
            this.showTreeFrame(parser, (CommonAST)declParser.getAST(), "Declarations - " + (this.getUnitname() != null ? this.getUnitname() : this.getFilename()), new Point(600, 24));
        }
        this.setAST((CommonASTWithLineNumber)declParser.getAST());
        this.asmLines = mainLexer.getAsmLines();
        this.commentLines = mainLexer.getCommentLines();
        this.totalLines = mainLexer.getCurrentLine();
    }

    public void readReferences() {
        String astNodeClass = "de.fzi.delphi.CommonASTWithLineNumber";
        if (this.isPrimaryProjectFile()) {
            OPDebug.debugPrintln(1, "*** Collecting cross reference information of " + this.getFilename() + " ***");
        } else {
            OPDebug.debugPrintln(1, "=== Collecting cross reference information of " + this.getFilename() + " ===");
        }
        OPReferencesParser referenceParser = new OPReferencesParser();
        referenceParser.setASTNodeClass(astNodeClass);
        OPProjectManager.getOutput().printCommentLine("References of unit '" + this.getUnitname() + "' in file '" + this.getFilename() + "' (" + (this.isPrimaryProjectFile() ? "primary" : "secondary") + ")");
        try {
            referenceParser.goal((AST)this.getAST());
        }
        catch (RecognitionException e3) {
            OPDebug.debugPrint(2, "Error in reference analysis of file " + this.getFilename() + ". Aborting.");
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error in reference analysis", (Exception)((Object)e3));
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        catch (Exception e3) {
            OPDebug.debugPrint(2, "Error in reference analysis of file " + this.getFilename() + ". Aborting.");
            OPDebug.logPrint(String.valueOf(this.getFilename()) + " - Error in reference analysis", e3);
            this.setAnalyzed(true);
            this.aborted = true;
            return;
        }
        if (((String)OPProjectManager.getProperties().get("showReferenceTree")).equalsIgnoreCase("true")) {
            this.showTreeFrame(referenceParser.getTokenNames(), (CommonAST)referenceParser.getAST(), "References - " + (this.getUnitname() != null ? this.getUnitname() : this.getFilename()), new Point(600, 24));
        }
    }
}

