/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi;

import de.fzi.delphi.GeneralMapper;
import de.fzi.delphi.OPDebug;
import de.fzi.delphi.ProjectListEntry;
import de.fzi.delphi.output.IOPOutput;
import de.fzi.delphi.symbols.Attribute;
import de.fzi.delphi.symbols.Method;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.ScopingEngine;
import de.fzi.delphi.symbols.ScopingException;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.symbols.types.CharacterType;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.delphi.symbols.types.EnumeratedType;
import de.fzi.delphi.symbols.types.IntegerType;
import de.fzi.delphi.symbols.types.NilType;
import de.fzi.delphi.symbols.types.OrdinalType;
import de.fzi.delphi.symbols.types.PointerType;
import de.fzi.delphi.symbols.types.Range;
import de.fzi.delphi.symbols.types.RealType;
import de.fzi.delphi.symbols.types.StringType;
import de.fzi.delphi.symbols.types.UserDefinedType;
import de.fzi.delphi.symbols.types.VariantType;
import de.fzi.delphi.types.Type;
import de.fzi.sissy.utils.Debug;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class OPProjectManager {
    private static Vector fileList = new Vector();
    private static Hashtable projectList = new Hashtable();
    private static Hashtable excludeList = new Hashtable();
    private static Vector notFoundList = new Vector();
    private static IOPOutput output = null;
    private static Scope projectScope = new Scope(null, Scope.ROOT_SCOPE_NAME);
    private static Scope unresolvedScope = new Scope(projectScope, Scope.UNRESOLVED_SCOPE_NAME);
    private static OrdinalType constantType;
    private static GeneralMapper statementMapper;
    private static final boolean INSERT_DEBUG_SYMBOLS = true;
    static Properties properties;
    private static int currentFilelistEntry;
    static List searchPath;
    static BufferedWriter out;
    private static PrintStream unitDependencyStream;

    static {
        statementMapper = new GeneralMapper();
        ScopingEngine se = new ScopingEngine(projectScope);
        try {
            new NilType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        projectScope.addSymbol(NilType.get());
        IntegerType typeInteger = new IntegerType("Integer");
        typeInteger.setRange(new Range("-2147483648", "2147483647"));
        projectScope.addSymbol(typeInteger);
        Type.setIntegerType(typeInteger);
        constantType = typeInteger;
        IntegerType cardinalType = new IntegerType("Cardinal");
        cardinalType.setRange(new Range("0", "4294967295"));
        projectScope.addSymbol(cardinalType);
        IntegerType byteType = new IntegerType("Byte");
        byteType.setRange(new Range("0", "255"));
        projectScope.addSymbol(byteType);
        IntegerType shortintType = new IntegerType("Shortint");
        shortintType.setRange(new Range("-128", "127"));
        projectScope.addSymbol(shortintType);
        IntegerType smallintType = new IntegerType("Smallint");
        smallintType.setRange(new Range("-32768", "32767"));
        projectScope.addSymbol(smallintType);
        IntegerType longintType = new IntegerType("Longint");
        longintType.setRange(new Range("-2147483648", "2147483647"));
        projectScope.addSymbol(longintType);
        IntegerType int64Type = new IntegerType("Int64");
        int64Type.setRange(new Range("-9223372036854775808", "9223372036854775807"));
        projectScope.addSymbol(int64Type);
        Type.setInt64Type(int64Type);
        IntegerType wordType = new IntegerType("Word");
        wordType.setRange(new Range("0", "65535"));
        projectScope.addSymbol(wordType);
        IntegerType longType = new IntegerType("Longword");
        longType.setRange(new Range("0", "4294967295"));
        projectScope.addSymbol(longType);
        IntegerType compType = new IntegerType("Comp");
        compType.setRange(new Range(new BigInteger("-2").pow(63).add(BigInteger.ONE), new BigInteger("2").pow(63).subtract(BigInteger.ONE)));
        projectScope.addSymbol(compType);
        StringType typeString = new StringType("String");
        Type.setStringType(typeString);
        projectScope.addSymbol(typeString);
        StringType typeShortString = new StringType("ShortString");
        projectScope.addSymbol(typeShortString);
        StringType typeAnsiString = new StringType("AnsiString");
        projectScope.addSymbol(typeAnsiString);
        StringType typeWideString = new StringType("WideString");
        projectScope.addSymbol(typeWideString);
        RealType realType = new RealType("Real");
        projectScope.addSymbol(realType);
        Type.setRealType(realType);
        projectScope.addSymbol(new RealType("Real48"));
        RealType typeSingle = new RealType("Single");
        projectScope.addSymbol(typeSingle);
        RealType typeDouble = new RealType("Double");
        projectScope.addSymbol(typeDouble);
        RealType typeExtended = new RealType("Extended");
        projectScope.addSymbol(typeExtended);
        Type.setExtendedType(typeExtended);
        RealType typeCurrency = new RealType("Currency");
        projectScope.addSymbol(typeCurrency);
        CharacterType characterType = new CharacterType("Char");
        projectScope.addSymbol(characterType);
        Type.setCharacterType(characterType);
        projectScope.addSymbol(new CharacterType("AnsiChar"));
        projectScope.addSymbol(new CharacterType("WideChar"));
        EnumeratedType boolType = new EnumeratedType();
        Type.setBooleanType(boolType);
        Attribute tempAttribFalse = new Attribute("false", (Type)boolType);
        projectScope.addSymbol(tempAttribFalse);
        boolType.addEnumerationElement(tempAttribFalse);
        Attribute tempAttribTrue = new Attribute("true", (Type)boolType);
        projectScope.addSymbol(tempAttribTrue);
        boolType.addEnumerationElement(tempAttribTrue);
        projectScope.addSymbol(boolType);
        projectScope.addSymbol(new UserDefinedType("Boolean", (Type)boolType));
        boolType = new EnumeratedType();
        boolType.addEnumerationElement(tempAttribFalse);
        boolType.addEnumerationElement(tempAttribTrue);
        projectScope.addSymbol(boolType);
        projectScope.addSymbol(new UserDefinedType("ByteBool", (Type)boolType));
        boolType = new EnumeratedType();
        boolType.addEnumerationElement(tempAttribFalse);
        boolType.addEnumerationElement(tempAttribTrue);
        projectScope.addSymbol(boolType);
        projectScope.addSymbol(new UserDefinedType("WordBool", (Type)boolType));
        boolType = new EnumeratedType();
        boolType.addEnumerationElement(tempAttribFalse);
        boolType.addEnumerationElement(tempAttribTrue);
        projectScope.addSymbol(boolType);
        projectScope.addSymbol(new UserDefinedType("LongBool", (Type)boolType));
        VariantType variantType = new VariantType("Variant");
        projectScope.addSymbol(variantType);
        VariantType oleVariantType = new VariantType("OleVariant");
        projectScope.addSymbol(oleVariantType);
        ClassType interfaceType = new ClassType("IUnknown");
        interfaceType.setInterface(true);
        projectScope.addSymbol(interfaceType);
        se.createNewScope(interfaceType.getName()).setCorrespondingSymbol(interfaceType);
        try {
            se.prevScope();
        }
        catch (ScopingException e1) {
            Debug.error((String)"ScopingException while creating default-types");
            throw new RuntimeException(e1);
        }
        Vector<Attribute> paramList = new Vector<Attribute>();
        paramList.add(new Attribute("integervalue", (Type)Type.getIntegerType()));
        Method chr_method = new Method("chr", Type.getCharacterType(), paramList);
        projectScope.addSymbol(chr_method);
        se.createNewScope(chr_method.getName()).setCorrespondingSymbol(chr_method);
        try {
            se.prevScope();
        }
        catch (ScopingException e1) {
            System.err.println("ScopingException while creating default-types");
            throw new RuntimeException(e1);
        }
        ClassType typeTObject = new ClassType("TObject");
        projectScope.addSymbol(typeTObject);
        se.createNewScope(typeTObject.getName()).setCorrespondingSymbol(typeTObject);
        try {
            se.prevScope();
        }
        catch (ScopingException e1) {
            System.err.println("ScopingException while creating default-types");
            throw new RuntimeException(e1);
        }
        ClassType type = new ClassType("TDate", typeTObject);
        projectScope.addSymbol(type);
        se.createNewScope(type.getName()).setCorrespondingSymbol(type);
        try {
            se.prevScope();
        }
        catch (ScopingException e1) {
            System.err.println("ScopingException while creating default-types");
            throw new RuntimeException(e1);
        }
        type = new ClassType("TForm", typeTObject);
        projectScope.addSymbol(type);
        se.createNewScope(type.getName()).setCorrespondingSymbol(type);
        try {
            se.prevScope();
        }
        catch (ScopingException e1) {
            System.err.println("ScopingException while creating default-types");
            throw new RuntimeException(e1);
        }
        ClassType dispinterfaceType = new ClassType("IDispatch");
        dispinterfaceType.setDispinterface(true);
        projectScope.addSymbol(dispinterfaceType);
        se.createNewScope(dispinterfaceType.getName()).setCorrespondingSymbol(dispinterfaceType);
        try {
            se.prevScope();
        }
        catch (ScopingException e1) {
            Debug.error((String)"ScopingException while creating default-types");
            throw new RuntimeException(e1);
        }
        projectScope.addSymbol(new PointerType("PAnsiString", (Type)typeAnsiString));
        projectScope.addSymbol(new PointerType("PString", (Type)typeAnsiString));
        projectScope.addSymbol(new PointerType("PCurrency", (Type)typeCurrency));
        projectScope.addSymbol(new PointerType("PDouble", (Type)typeDouble));
        projectScope.addSymbol(new PointerType("PExtended", (Type)typeExtended));
        projectScope.addSymbol(new PointerType("PSingle", (Type)typeSingle));
        projectScope.addSymbol(new PointerType("PInteger", (Type)typeInteger));
        projectScope.addSymbol(new PointerType("PInteger", (Type)typeInteger));
        projectScope.addSymbol(new PointerType("PShortString", (Type)typeShortString));
        projectScope.addSymbol(new PointerType("PWideString", (Type)typeWideString));
        projectScope.addSymbol(new PointerType("PWideString", (Type)typeWideString));
        projectScope.addSymbol(new PointerType("PVariant", (Type)variantType));
        projectScope.addSymbol(new PointerType("POleVariant", (Type)oleVariantType));
        projectScope.addSymbol(new PointerType("PIUnknown", (Type)interfaceType));
        Iterator li = projectScope.getSymbols().iterator();
        while (li.hasNext()) {
            ((Symbol)li.next()).setResolved(true);
        }
        properties = new Properties();
        try {
            properties.load(new FileInputStream("config.ini"));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
        currentFilelistEntry = 0;
        searchPath = new Vector();
        out = null;
        unitDependencyStream = null;
    }

    public static void addProjectFile(String filename, String compUnitName) {
        String tempFilename = filename == null ? OPProjectManager.getFilenameForCompilationUnit(compUnitName) : filename;
        assert (tempFilename != null);
        ProjectListEntry ple = compUnitName == null || compUnitName.length() == 0 ? new ProjectListEntry(tempFilename, OPProjectManager.extractUnitName(tempFilename), true) : new ProjectListEntry(tempFilename, compUnitName, true);
        if (!fileList.contains(ple.getFilename())) {
            OPProjectManager.addFileToFileList(ple.getFilename());
        } else {
            System.err.println("File '" + tempFilename + "' is already part of the Project.");
        }
        OPProjectManager.addProjectListEntry(ple);
    }

    public static void addUnit(String compUnitName) {
        assert (compUnitName != null);
        String tempFilename = OPProjectManager.getFilenameForCompilationUnit(compUnitName);
        if (tempFilename == null) {
            OPDebug.debugPrint(2, "File for Unit '" + compUnitName + "' not found");
            Enumeration enumm = excludeList.elements();
            String current = null;
            while (enumm.hasMoreElements()) {
                current = (String)enumm.nextElement();
                if (current.equalsIgnoreCase(String.valueOf(compUnitName) + ".pas") || current.toLowerCase().endsWith(("\\" + compUnitName + ".pas").toLowerCase())) break;
            }
            if (current != null && current.toLowerCase().endsWith((String.valueOf(compUnitName) + ".pas").toLowerCase())) {
                OPDebug.debugPrint(2, ", file is on exclude-list");
            }
            OPDebug.debugPrintln(2, ".");
            notFoundList.add(compUnitName);
            return;
        }
        ProjectListEntry ple = new ProjectListEntry(tempFilename, compUnitName);
        OPProjectManager.addFileToFileList(ple.getFilename());
        if (Boolean.getBoolean(properties.getProperty("dontSpawnSubparsers", "false"))) {
            System.err.println("Warning! Option 'dontSpawnSubparsers' is set!");
            ple.setExcluded(true);
        }
        OPProjectManager.addProjectListEntry(ple);
    }

    private static void addProjectListEntry(ProjectListEntry ple) {
        if (excludeList.get(ple.getFilename()) != null) {
            ple.setExcluded(true);
        }
        if (projectList.get(ple.getUnitname()) == null) {
            projectList.put(ple.getUnitname(), ple);
        }
    }

    private static void addFileToFileList(String filename) {
        if (!fileList.contains(filename)) {
            fileList.addElement(filename);
        }
    }

    public static void addExcludeFile(String filename) {
        assert (filename != null);
        excludeList.put(filename, filename);
    }

    public static void readDeclarationsFromCompilationUnit(String compilationUnitName) {
        ProjectListEntry current = (ProjectListEntry)projectList.get(compilationUnitName.toLowerCase());
        if (current == null) {
            OPProjectManager.addUnit(compilationUnitName);
            current = (ProjectListEntry)projectList.get(compilationUnitName.toLowerCase());
        }
        if (current != null) {
            assert (current != null);
            if (current.isExcluded()) {
                OPDebug.debugPrintln(1, "File '" + current.getFilename() + "' is excluded." + (Boolean.getBoolean(properties.getProperty("dontSpawnSubparsers", "false")) ? " DONT_SPAWN_SUBPARSERS enabled" : ""));
            } else if (!current.isAnalyzed()) {
                current.readDeclarations();
            }
        }
    }

    public static Scope getProjectScope() {
        return projectScope;
    }

    public static boolean hasNext() {
        return currentFilelistEntry < fileList.size();
    }

    public static ProjectListEntry next() {
        String tempUnitname = OPProjectManager.extractUnitName((String)fileList.elementAt(currentFilelistEntry));
        assert (tempUnitname != null);
        ++currentFilelistEntry;
        return (ProjectListEntry)projectList.get(tempUnitname.toLowerCase());
    }

    public static void reset() {
        currentFilelistEntry = 0;
    }

    public static String extractUnitName(String filename) {
        File file = new File(filename);
        String temp = file.getName();
        if (temp.lastIndexOf(".") != -1) {
            return temp.substring(0, temp.lastIndexOf("."));
        }
        return temp;
    }

    public static String getFilenameForCompilationUnit(String compilationUnitName) {
        if (projectList.get(compilationUnitName) != null) {
            String returnString = ((ProjectListEntry)projectList.get(compilationUnitName)).getFilename();
            if (new File(returnString).exists()) {
                return returnString;
            }
            return null;
        }
        ListIterator li = OPProjectManager.getSearchPath().listIterator();
        File testFile = null;
        String returnString = null;
        while (li.hasNext()) {
            String nextListElement = (String)li.next();
            testFile = new File(nextListElement, String.valueOf(compilationUnitName) + ".pas");
            if (testFile.exists() && testFile.canRead()) {
                returnString = testFile.toString();
                break;
            }
            testFile = new File(nextListElement, String.valueOf(compilationUnitName) + ".inc");
            if (!testFile.exists() || !testFile.canRead()) continue;
            returnString = testFile.toString();
            break;
        }
        return returnString;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static ProjectListEntry getProjectListEntry(String unitname) {
        ProjectListEntry pe = null;
        Object o = projectList.get(unitname.toLowerCase());
        if (o != null && o instanceof ProjectListEntry) {
            pe = (ProjectListEntry)o;
        }
        return pe;
    }

    private static List getSearchPath() {
        if (searchPath.isEmpty()) {
            searchPath.add(properties.getProperty("ProjectBasePath", "."));
            String next = "";
            StringTokenizer st = new StringTokenizer(properties.getProperty("include_path", ""), ";", false);
            while (st.hasMoreTokens()) {
                next = st.nextToken();
                if (!next.endsWith(System.getProperty("file.separator"))) {
                    next = String.valueOf(next) + System.getProperty("file.separator");
                }
                OPProjectManager.addPathToSearchPath(next);
            }
        }
        return searchPath;
    }

    private static void addPathToSearchPath(String path) {
        File f = new File(path);
        if (f != null && f.isDirectory()) {
            if (!searchPath.contains(path)) {
                searchPath.add(path);
            }
            String[] list = f.list();
            int i = 0;
            while (i < list.length) {
                OPProjectManager.addPathToSearchPath(String.valueOf(path) + list[i] + File.separator);
                ++i;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            out.write("}" + System.getProperty("line.separator"));
            out.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static IOPOutput getOutput() {
        return output;
    }

    public static void setOutput(IOPOutput output) {
        OPProjectManager.output = output;
    }

    public static PrintStream getUnitDependencySRFStream() {
        if (unitDependencyStream == null) {
            try {
                unitDependencyStream = new PrintStream(new FileOutputStream((String)OPProjectManager.getProperties().get("unit-dependencies")));
            }
            catch (FileNotFoundException e4) {
                throw new RuntimeException(e4);
            }
            unitDependencyStream.println("ENTITY-TYPE Unit name");
            unitDependencyStream.println("RELATION-TYPE uses usingUnit usedUnit");
        }
        return unitDependencyStream;
    }

    public static Hashtable getProjectList() {
        return projectList;
    }

    public static Scope getUnresolvedScope() {
        return unresolvedScope;
    }

    public static OrdinalType getConstantType() {
        return constantType;
    }

    public static void setConstantType(OrdinalType constantType) {
        OPProjectManager.constantType = constantType;
    }

    public static GeneralMapper getStatementMapper() {
        return statementMapper;
    }

    public static void setStatementMapper(GeneralMapper statementMapper) {
        OPProjectManager.statementMapper = statementMapper;
    }
}

