/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi;

import antlr.TokenStreamSelector;
import de.fzi.delphi.Dpr2Lst;
import de.fzi.delphi.OPDebug;
import de.fzi.delphi.OPProjectManager;
import de.fzi.delphi.ProjectListEntry;
import de.fzi.delphi.dialog.ProjectListDialog;
import de.fzi.delphi.output.DebugOutput;
import de.fzi.delphi.output.GraphvizOutput;
import de.fzi.delphi.output.NoOutput;
import de.fzi.delphi.output.SRFOutput;
import de.fzi.delphi.parser.debug.ScopeTree;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.StringTabelle;
import de.fzi.sissy.utils.Debug;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class OPMain {
    private static String currentFilename = null;
    private static String NEWLINE = System.getProperty("line.separator");
    public static TokenStreamSelector selector = new TokenStreamSelector();

    public static void main(String[] argv) throws IOException {
        File f1;
        String excludeListValue;
        String dprFileValue;
        String fileListValue;
        String debugValue;
        Vector<String> files = null;
        Vector excludedFiles = null;
        CmdLineParser clParser = new CmdLineParser();
        CmdLineParser.Option verboseOption = clParser.addIntegerOption('v', "verbose");
        CmdLineParser.Option parsetreeOption = clParser.addBooleanOption('p', "parse-tree");
        CmdLineParser.Option transformedtreeOption = clParser.addBooleanOption('t', "transformed-tree");
        CmdLineParser.Option symboltreeOption = clParser.addBooleanOption('s', "symbol-tree");
        CmdLineParser.Option referenceTreeOption = clParser.addBooleanOption('r', "reference-tree");
        CmdLineParser.Option formatOption = clParser.addStringOption('f', "format");
        CmdLineParser.Option debugOption = clParser.addStringOption('d', "debug");
        CmdLineParser.Option includePathOption = clParser.addStringOption('I', "include-path");
        CmdLineParser.Option fileList = clParser.addStringOption('l', "list");
        CmdLineParser.Option dprFile = clParser.addStringOption('j', "dpr");
        CmdLineParser.Option excludeList = clParser.addStringOption('x', "exclude-list");
        CmdLineParser.Option scopeTree = clParser.addBooleanOption(' ', "scope-tree");
        CmdLineParser.Option helpOption = clParser.addBooleanOption('h', "help");
        CmdLineParser.Option unitDependencies = clParser.addStringOption('u', "unit-dependencies-only");
        CmdLineParser.Option logFile = clParser.addStringOption(' ', "logfile");
        CmdLineParser.Option noReferenceAnalysis = clParser.addBooleanOption(' ', "noref");
        try {
            clParser.parse(argv);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            OPMain.showHelp();
            throw new Error("2");
        }
        if (clParser.getOptionValue(helpOption) != null) {
            OPMain.showHelp();
            return;
        }
        Integer verboseValue = (Integer)clParser.getOptionValue(verboseOption);
        if (verboseValue != null) {
            OPProjectManager.getProperties().setProperty("verboseLevel", verboseValue.toString());
        } else {
            OPProjectManager.getProperties().setProperty("verboseLevel", OPProjectManager.getProperties().getProperty("verboseLevel", "1"));
        }
        if (clParser.getOptionValue(parsetreeOption) != null) {
            OPProjectManager.getProperties().setProperty("showParseTree", "true");
        } else {
            OPProjectManager.getProperties().setProperty("showParseTree", OPProjectManager.getProperties().getProperty("showParseTree", "false"));
        }
        if (clParser.getOptionValue(transformedtreeOption) != null) {
            OPProjectManager.getProperties().setProperty("showTransformedTree", "true");
        } else {
            OPProjectManager.getProperties().setProperty("showTransformedTree", OPProjectManager.getProperties().getProperty("showTransformedTree", "false"));
        }
        if (clParser.getOptionValue(symboltreeOption) != null) {
            OPProjectManager.getProperties().setProperty("showSymbolTree", "true");
        } else {
            OPProjectManager.getProperties().setProperty("showSymbolTree", OPProjectManager.getProperties().getProperty("showSymbolTree", "false"));
        }
        if (clParser.getOptionValue(referenceTreeOption) != null) {
            OPProjectManager.getProperties().setProperty("showReferenceTree", "true");
        } else {
            OPProjectManager.getProperties().setProperty("showReferenceTree", OPProjectManager.getProperties().getProperty("showReferenceTree", "false"));
        }
        String formatValue = (String)clParser.getOptionValue(formatOption);
        if (formatValue != null) {
            if (formatValue.toLowerCase().compareTo("debug") == 0) {
                OPProjectManager.getProperties().setProperty("format", "DebugOutput");
            } else if (formatValue.toLowerCase().compareTo("srf") == 0) {
                OPProjectManager.getProperties().setProperty("format", "SRFOutput");
            } else if (formatValue.toLowerCase().compareTo("sissy") == 0) {
                OPProjectManager.getProperties().setProperty("format", "SissyOutput");
            } else if (formatValue.toLowerCase().compareTo("dot") == 0) {
                OPProjectManager.getProperties().setProperty("format", "GraphvizOutput");
            } else {
                OPProjectManager.getProperties().setProperty("format", "NoOutput");
            }
        } else {
            OPProjectManager.getProperties().setProperty("format", OPProjectManager.getProperties().getProperty("format", "DebugOutput"));
        }
        String inc = (String)clParser.getOptionValue(includePathOption);
        if (inc != null) {
            Debug.info((String)("Include Paths: " + inc));
            OPProjectManager.getProperties().setProperty("include_path", inc);
        }
        if (clParser.getOptionValue(scopeTree) != null) {
            OPProjectManager.getProperties().setProperty("showScopeTree", "true");
        } else {
            OPProjectManager.getProperties().setProperty("showScopeTree", OPProjectManager.getProperties().getProperty("showScopeTree", "false"));
        }
        String logFileValue = (String)clParser.getOptionValue(logFile);
        if (logFileValue != null) {
            OPProjectManager.getProperties().setProperty("logfile", logFileValue);
        }
        if ((debugValue = (String)clParser.getOptionValue(debugOption)) != null && debugValue.toLowerCase().compareTo("tag-idents") == 0) {
            OPProjectManager.getProperties().setProperty("tagIdentsWithLineNumber", "true");
        }
        if (clParser.getOptionValue(noReferenceAnalysis) != null) {
            OPProjectManager.getProperties().setProperty("noReferenceAnalysis", "true");
        } else {
            OPProjectManager.getProperties().setProperty("noReferenceAnalysis", OPProjectManager.getProperties().getProperty("noReferenceAnalysis", "false"));
        }
        String unitDependenciesValue = (String)clParser.getOptionValue(unitDependencies);
        if (unitDependenciesValue != null) {
            OPProjectManager.getProperties().setProperty("unit-dependencies", unitDependenciesValue);
        }
        if ((fileListValue = (String)clParser.getOptionValue(fileList)) != null) {
            OPProjectManager.getProperties().setProperty("listfile", fileListValue);
        }
        if ((dprFileValue = (String)clParser.getOptionValue(dprFile)) != null) {
            OPProjectManager.getProperties().setProperty("dprfile", dprFileValue);
        }
        if ((excludeListValue = (String)clParser.getOptionValue(excludeList)) != null) {
            OPProjectManager.getProperties().setProperty("exclude-list", excludeListValue);
        }
        try {
            OPProjectManager.getProperties().store(new FileOutputStream(".config.properties"), "OPParser configuration file");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.warning((String)"Warning: can't store config file. Exiting.");
        }
        catch (IOException iOException) {
            Debug.warning((String)"Warning: can't store config file. Exiting.");
        }
        String basePath = OPProjectManager.getProperties().getProperty("listfile") != null ? OPProjectManager.getProperties().getProperty("listfile") : (OPProjectManager.getProperties().getProperty("dprfile") != null ? OPProjectManager.getProperties().getProperty("dprfile") : null);
        System.getProperty("file.separator");
        basePath = basePath != null ? ((f1 = new File(basePath)) != null && f1.getParentFile() != null ? f1.getParentFile().getAbsolutePath() : System.getProperty("user.dir")) : System.getProperty("user.dir");
        OPProjectManager.getProperties().setProperty("ProjectBasePath", basePath);
        if (Integer.parseInt(OPProjectManager.getProperties().getProperty("verboseLevel", "1")) > 2) {
            OPProjectManager.getProperties().list(System.out);
        }
        OPDebug.setVerboseLevel(Integer.parseInt(OPProjectManager.getProperties().getProperty("verboseLevel", "1")));
        if (OPProjectManager.getProperties().getProperty("format").equalsIgnoreCase("SRFOutput")) {
            try {
                OPProjectManager.setOutput(new SRFOutput(new FileOutputStream("output.srf")));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else if (OPProjectManager.getProperties().getProperty("format").equalsIgnoreCase("GraphvizOutput")) {
            OPProjectManager.setOutput(new GraphvizOutput());
        } else if (!OPProjectManager.getProperties().getProperty("format").equalsIgnoreCase("SissyOutput")) {
            if (OPProjectManager.getProperties().getProperty("format").equalsIgnoreCase("DebugOutput")) {
                OPProjectManager.setOutput(new DebugOutput());
            } else if (OPProjectManager.getProperties().getProperty("format").equalsIgnoreCase("NoOutput")) {
                OPProjectManager.setOutput(new NoOutput());
            }
        }
        if (OPProjectManager.getProperties().getProperty("logfile") != null) {
            OPDebug.setLogfile(OPProjectManager.getProperties().getProperty("logfile"));
        }
        if (OPProjectManager.getProperties().getProperty("listfile") != null) {
            if (Integer.parseInt(OPProjectManager.getProperties().getProperty("verboseLevel", "1")) >= 2) {
                Debug.info((String)("Reading listfile: " + OPProjectManager.getProperties().getProperty("listfile")));
            }
            files = OPMain.readFileList(OPProjectManager.getProperties().getProperty("listfile"));
            if (Integer.parseInt(OPProjectManager.getProperties().getProperty("verboseLevel", "1")) >= 2) {
                Debug.info((String)files.toString());
            }
        } else if (OPProjectManager.getProperties().getProperty("dprfile") != null) {
            if (Integer.parseInt(OPProjectManager.getProperties().getProperty("verboseLevel", "1")) >= 2) {
                Debug.info((String)("Reading dpr-file: " + OPProjectManager.getProperties().getProperty("dprfile")));
            }
            files = OPMain.readDprFile(OPProjectManager.getProperties().getProperty("dprfile"));
            if (Integer.parseInt(OPProjectManager.getProperties().getProperty("verboseLevel", "1")) >= 2) {
                Debug.info((String)files.toString());
            }
        } else if (fileListValue == null && dprFileValue == null) {
            String[] filesFromCommandline = null;
            filesFromCommandline = clParser.getRemainingArgs();
            files = new Vector<String>();
            int i = 0;
            while (i < filesFromCommandline.length) {
                files.addElement(filesFromCommandline[i]);
                ++i;
            }
        }
        if (files == null || files.size() == 0) {
            OPMain.showProjectListDialog();
        }
        if (files.size() > 0) {
            int i = 0;
            while (i < files.size()) {
                OPProjectManager.addProjectFile((String)files.elementAt(i), "");
                OPDebug.debugPrintln(5, "Adding primary project file: " + (String)files.elementAt(i));
                ++i;
            }
        }
        if (OPProjectManager.getProperties().getProperty("exclude-list") != null) {
            if (Integer.parseInt(OPProjectManager.getProperties().getProperty("verboseLevel", "1")) >= 2) {
                Debug.info((String)("Reading exclude list: " + OPProjectManager.getProperties().getProperty("exclude-list")));
            }
            excludedFiles = OPMain.readFileList(OPProjectManager.getProperties().getProperty("exclude-list"));
            if (Integer.parseInt(OPProjectManager.getProperties().getProperty("verboseLevel", "1")) >= 2) {
                Debug.info((String)excludedFiles.toString());
            }
            int i = 0;
            while (i < excludedFiles.size()) {
                OPProjectManager.addExcludeFile((String)excludedFiles.elementAt(i));
                ++i;
            }
        }
        OPProjectManager.getProperties().setProperty("dontSpawnSubparsers", "false");
        OPMain.run();
        if (OPProjectManager.getProperties().get("showScopeTree") != null && ((String)OPProjectManager.getProperties().get("showScopeTree")).equalsIgnoreCase("true")) {
            ScopeTree globalScopeTree = new ScopeTree(OPProjectManager.getProjectScope());
            globalScopeTree.display();
        }
        Collection c = OPProjectManager.getProjectList().values();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Debug.info((String)i.next().toString());
        }
    }

    public static void run() {
        long timer = 0L;
        int fileCounter = 0;
        int totalFiles = 0;
        long totalLines = 0L;
        int successfulFiles = 0;
        timer = System.currentTimeMillis();
        OPMain.verbosePrintln(1, String.valueOf(OPDebug.getTimeStamp()) + " " + "declaration-analysis phase ....");
        while (OPProjectManager.hasNext()) {
            ProjectListEntry current = OPProjectManager.next();
            ++fileCounter;
            if (current == null || current.isAnalyzed()) continue;
            current.readDeclarations();
        }
        int nUnresolved = OPProjectManager.getProjectScope().countUnresolvedSymbols();
        OPDebug.debugPrint(1, String.valueOf(OPDebug.getTimeStamp()) + " " + "Resolving remaining unresolved symbols (" + nUnresolved + ") ...");
        if (nUnresolved > 0) {
            OPProjectManager.getProjectScope().countUnresolvedSymbols();
        }
        int previousUnresolved = 0;
        int currentUnresolved = 0;
        int count = 1;
        do {
            previousUnresolved = OPProjectManager.getUnresolvedScope().countAllSymbols();
            OPDebug.debugPrintln(1, "#" + count++ + ": " + previousUnresolved + " unresolved symbols remaining.");
            OPProjectManager.getUnresolvedScope().processUnresolvedScope();
        } while (previousUnresolved - (currentUnresolved = OPProjectManager.getUnresolvedScope().countAllSymbols()) != 0);
        OPDebug.debugPrint(1, " done.");
        nUnresolved = OPProjectManager.getProjectScope().countUnresolvedSymbols();
        OPDebug.debugPrintln(1, " (" + OPProjectManager.getProjectScope().countAllSymbols() + " total; " + nUnresolved + " symbols unresolved)");
        Scope.setDeclarationAnalysisFinished();
        if (!OPProjectManager.getProperties().getProperty("noReferenceAnalysis", "false").equalsIgnoreCase("true")) {
            OPProjectManager.reset();
            fileCounter = 0;
            int primaryCount = 0;
            Enumeration keyEnum = OPProjectManager.getProjectList().keys();
            while (keyEnum.hasMoreElements()) {
                if (!((ProjectListEntry)OPProjectManager.getProjectList().get(keyEnum.nextElement())).isPrimaryProjectFile()) continue;
                ++primaryCount;
            }
            OPMain.verbosePrintln(2, String.valueOf(OPDebug.getTimeStamp()) + " " + "reference-analysis phase ....");
            while (OPProjectManager.hasNext()) {
                ProjectListEntry current = OPProjectManager.next();
                if (current == null || !current.isPrimaryProjectFile() || current.isExcluded() || current.isAborted()) continue;
                Debug.info((String)("Current file " + ++fileCounter + " of " + primaryCount + " ..."));
                current.readReferences();
            }
        }
        OPMain.verbosePrintln(2, String.valueOf(OPDebug.getTimeStamp()) + " " + "dumping declarations ....");
        if (nUnresolved > 0) {
            OPProjectManager.getProjectScope().countUnresolvedSymbols();
        }
        if (OPProjectManager.getOutput() instanceof SRFOutput) {
            ((SRFOutput)OPProjectManager.getOutput()).printAllScopeEntities(OPProjectManager.getProjectScope());
        }
        OPMain.verbosePrintln(2, String.valueOf(OPDebug.getTimeStamp()) + " " + "finishing ....");
        totalFiles = 0;
        totalLines = 0L;
        successfulFiles = 0;
        OPProjectManager.reset();
        while (OPProjectManager.hasNext()) {
            ProjectListEntry current = OPProjectManager.next();
            ++totalFiles;
            if (current.isAborted()) continue;
            totalLines += current.getTotalLines();
            ++successfulFiles;
        }
        double duration = (double)(System.currentTimeMillis() - timer) / 1000.0;
        DecimalFormat df = new DecimalFormat("#0.00");
        OPDebug.debugPrintln(1, "");
        OPDebug.debugPrintln(1, "Time: " + df.format(duration) + " s");
        OPDebug.debugPrintln(1, String.valueOf(successfulFiles) + " of " + totalFiles + " files successfully analyzed.");
        if (totalLines > 0L) {
            OPDebug.debugPrintln(1, "Total: " + totalLines + " lines");
            OPDebug.debugPrintln(1, "Speed: " + df.format((double)totalLines / duration) + " lps");
        }
    }

    public static Vector readDprFile(String filename) {
        Vector<String> v = new Vector<String>();
        ListIterator li = Dpr2Lst.readDpr(filename).listIterator();
        String current = null;
        String prefix = new File(filename).getParentFile() != null ? new File(filename).getParentFile().getAbsolutePath() : "";
        while (li.hasNext()) {
            File file;
            current = (String)li.next();
            if (!current.toLowerCase().endsWith(".pas")) {
                current = String.valueOf(current) + ".pas";
            }
            if (!(file = new File(current)).isAbsolute()) {
                String temp1 = file.getName();
                String temp2 = new File(prefix, temp1).getAbsolutePath();
                if (!new File(temp2).exists()) continue;
                Debug.info((String)temp2);
                v.add(temp2);
                continue;
            }
            if (!new File(current).exists()) continue;
            Debug.info((String)current);
            v.add(current);
        }
        return v;
    }

    /*
     * Unable to fully structure code
     */
    public static Vector readFileList(String filename) {
        list = new Vector<String>();
        in = null;
        prefix = new File(filename).getParentFile() != null ? new File(filename).getParentFile().getAbsolutePath() : "";
        try {
            in = new BufferedReader(new FileReader(filename));
            if (true) ** GOTO lbl19
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        {
            do {
                if ((temp = temp.trim()).startsWith("//") || temp.startsWith("#") || temp.length() <= 0) continue;
                file = new File(temp);
                if (!file.isAbsolute()) {
                    temp2 = new File(prefix, temp).getAbsolutePath();
                    list.add(temp2);
                    continue;
                }
                list.add(temp);
lbl19:
                // 4 sources

            } while ((temp = in.readLine()) != null);
        }
        return list;
    }

    private static void showHelp() {
        Debug.info((String)"Usage:");
        Debug.info((String)"OPParser");
        Debug.info((String)" [--help]");
        Debug.info((String)" [--verbose <verbose level]");
        Debug.info((String)" [--parse-tree]");
        Debug.info((String)" [--transformed-tree]");
        Debug.info((String)" [--symbol-tree]");
        Debug.info((String)" [--reference-tree]");
        Debug.info((String)" [--list file-list]");
        Debug.info((String)" [--dpr dpr-file]");
        Debug.info((String)" [--exclude-list file-list]");
        Debug.info((String)" [--format <debug|srf|dot>]");
        Debug.info((String)" [--debug <debug-option>]");
        Debug.info((String)" [--include_path path1;path2]");
        Debug.info((String)" [--scope-tree]");
        Debug.info((String)" [--unit-dependencies-only [<filename>]]");
        Debug.info((String)" [--logfile filename]");
        Debug.info((String)" [<input file>]");
    }

    private static Vector showProjectListDialog() {
        Vector<String> files = new Vector<String>();
        ProjectListDialog pd = new ProjectListDialog();
        pd.setModal(true);
        pd.show();
        ListIterator filelistIterator = pd.getFileList().listIterator();
        while (filelistIterator.hasNext()) {
            Object current = filelistIterator.next();
            if (current instanceof File) {
                files.addElement(((File)current).getAbsolutePath());
                continue;
            }
            if (!(current instanceof String)) continue;
            files.addElement((String)current);
        }
        if (pd.getProjectFilename().toLowerCase().endsWith(".dpr")) {
            OPMain.verbosePrintln(2, "Reading dpr-file: " + pd.getProjectFilename());
            OPProjectManager.getProperties().setProperty("dprfile", pd.getProjectFilename());
        } else if (pd.getProjectFilename().toLowerCase().endsWith(".lst")) {
            OPMain.verbosePrintln(2, "Reading listfile: " + pd.getProjectFilename());
            OPProjectManager.getProperties().setProperty("listfile", pd.getProjectFilename());
        }
        pd.dispose();
        return files;
    }

    private static void verbosePrintln(int verboseLevel, String message) {
        if (Integer.parseInt(OPProjectManager.getProperties().getProperty("verboseLevel", "1")) >= verboseLevel) {
            Debug.info((String)message);
        }
    }

    private static void dumpScopeToFile(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            ZipOutputStream zos = new ZipOutputStream(fos);
            zos.putNextEntry(new ZipEntry("ProjectScope"));
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(StringTabelle.getTable());
            oos.writeObject(OPProjectManager.getProjectScope());
            oos.close();
            zos.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

