/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi;

import antlr.Parser;
import antlr.collections.impl.BitSet;
import de.fzi.sissy.utils.Debug;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;

public class OPDebug {
    private static int verboseLevel = 0;
    private static String NEWLINE = System.getProperty("line.separator");
    private static String logfileName = "OPParser.log";
    private static int entryCounter = 0;
    private static PrintStream logStream = null;
    private static boolean printTimeStamp = false;

    public static void setLogfile(String filename) {
        if (filename == null) {
            OPDebug.setLogStream(null);
        } else {
            OPDebug.setLogStream(OPDebug.getAndOpenLogfileStream(filename));
        }
    }

    public static void setLogStream(PrintStream logStream) {
        if (logStream == null) {
            logStream = System.err;
        } else {
            OPDebug.logStream = logStream;
        }
    }

    public static void debugPrint(int level, String s) {
        if (level <= verboseLevel) {
            if (printTimeStamp) {
                System.err.print(OPDebug.getTimeStamp());
            }
            System.err.print(s);
            System.err.flush();
        }
    }

    public static void debugPrintln(int level, String s) {
        OPDebug.debugPrint(level, String.valueOf(s) + NEWLINE);
    }

    public static void debugPrintln(int level) {
        OPDebug.debugPrint(level, NEWLINE);
    }

    private static PrintStream getAndOpenLogfileStream(String logfileName) {
        PrintStream ps = null;
        try {
            ps = new PrintStream(new FileOutputStream(logfileName));
        }
        catch (FileNotFoundException e) {
            Debug.error((String)"Can't open logfile");
            throw new RuntimeException(e);
        }
        if (ps != null && !ps.equals(System.err)) {
            Date d = new Date();
            ps.println(d);
        }
        return ps;
    }

    public static void logPrint(String s) {
        if (logStream == null) {
            OPDebug.setLogStream(System.err);
        }
        logStream.flush();
    }

    public static void logPrint(String prefix, Exception excep) {
        if (logStream == null) {
            OPDebug.setLogStream(System.err);
        }
        logStream.print(String.valueOf(NEWLINE) + ++entryCounter + ". " + prefix + ":" + NEWLINE);
        excep.printStackTrace(logStream);
        logStream.flush();
    }

    public static void logPrintln(String s) {
        OPDebug.logPrint(String.valueOf(s) + NEWLINE);
    }

    public static void logPrintln() {
        OPDebug.logPrint(NEWLINE);
    }

    public static int getVerboseLevel() {
        return verboseLevel;
    }

    public static void setVerboseLevel(int i) {
        verboseLevel = i;
    }

    public static void printAll(Hashtable ht) {
        Enumeration enumm = ht.elements();
        while (enumm.hasMoreElements()) {
            OPDebug.debugPrintln(verboseLevel, enumm.nextElement().toString());
        }
    }

    public static void printAll(List list) {
        ListIterator li = list.listIterator();
        while (li.hasNext()) {
            OPDebug.debugPrintln(verboseLevel, li.next().toString());
        }
    }

    public static String getNameForToken(Parser p, int token) {
        return String.valueOf(p.getTokenName(token)) + "(" + token + ")";
    }

    public static String getNamesForTokens(Parser p, BitSet bitset) {
        int[] tokens = bitset.toArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            sb.append(String.valueOf(i > 0 ? ", " : "") + OPDebug.getNameForToken(p, tokens[i]));
            ++i;
        }
        return sb.toString();
    }

    public static String getNameForToken(Class tokenType, int token) {
        Field[] fields = tokenType.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType() == Integer.TYPE) {
                try {
                    if (fields[i].getInt(fields[i]) == token) {
                        return fields[i].getName();
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        return "";
    }

    public static String getTimeStamp() {
        SimpleDateFormat instance = new SimpleDateFormat("HH:mm:ss");
        return instance.format(new Date());
    }
}

