/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.Parser;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import de.fzi.delphi.parser.DPRParser;
import de.fzi.delphi.parser.DPRTree2SRF;
import de.fzi.delphi.parser.OPLexer;
import de.fzi.delphi.parser.debug.ExpandableASTFrame;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.ListIterator;
import javax.swing.tree.TreePath;

public class Dpr2Srf {
    public static void main(String[] argv) {
        if (argv.length > 0) {
            Dpr2Srf.readDpr(argv[0]);
        } else {
            Dpr2Srf.readDpr();
        }
    }

    public static List readDpr() {
        return Dpr2Srf.readDpr(null);
    }

    public static List readDpr(String filename) {
        InputStream infile = null;
        PrintStream outfile = null;
        if (filename != null) {
            try {
                infile = new FileInputStream(filename);
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            infile = System.in;
        }
        if (filename != null) {
            try {
                outfile = new PrintStream(new FileOutputStream(String.valueOf(filename) + ".srf"));
            }
            catch (FileNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        } else {
            outfile = System.out;
        }
        OPLexer lexer = new OPLexer(infile);
        DPRParser parser = new DPRParser(lexer);
        List l = null;
        try {
            l = parser.goal();
        }
        catch (RecognitionException e1) {
            throw new RuntimeException(e1);
        }
        catch (TokenStreamException e1) {
            throw new RuntimeException(e1);
        }
        DPRTree2SRF dpr2srf = new DPRTree2SRF();
        try {
            dpr2srf.goal(parser.getAST(), outfile);
        }
        catch (RecognitionException e) {
            throw new RuntimeException(e);
        }
        return l;
    }

    private static void showTreeFrame(Parser parser, CommonAST t, String title, Point screenLocation) {
        String searchString = null;
        boolean expandAll = false;
        CommonAST.setVerboseStringConversion((boolean)true, (String[])parser.getTokenNames());
        ASTFactory factory = new ASTFactory();
        AST r = factory.create(0, "AST ROOT");
        r.setFirstChild((AST)t);
        ExpandableASTFrame frame = new ExpandableASTFrame(title, r);
        if (searchString != null) {
            ListIterator placesOfDiscovery = frame.tp.findInTree(searchString).listIterator();
            TreePath firstHit = null;
            while (placesOfDiscovery.hasNext()) {
                TreePath tpath = (TreePath)placesOfDiscovery.next();
                if (firstHit == null) {
                    firstHit = tpath;
                }
                if (tpath == null) continue;
                frame.tp.tree.addSelectionPath(tpath);
                frame.tp.expandAll(tpath, true);
                if (tpath.getParentPath() == null) continue;
                frame.tp.expandAll(tpath.getParentPath(), true);
            }
            if (firstHit != null) {
                frame.tp.tree.scrollPathToVisible(firstHit);
            }
        } else if (expandAll) {
            frame.tp.expandAll(true);
        }
        frame.setSize(400, 996);
        frame.setLocation(screenLocation);
        frame.setVisible(true);
    }
}

