/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import de.fzi.delphi.PositionElement;
import de.fzi.delphi.parser.debug.ExpandableASTFrame;
import de.fzi.sissy.metamod.Statement;
import java.awt.Point;
import java.util.ListIterator;
import javax.swing.tree.TreePath;

public class CommonASTWithLineNumber
extends CommonAST {
    private int line = -1;
    private PositionElement position_element = null;
    private Statement statement;

    public CommonASTWithLineNumber() {
    }

    public CommonASTWithLineNumber(AST t) {
        this.initialize(t);
    }

    public CommonASTWithLineNumber(Token arg0) {
        this.initialize(arg0);
    }

    public void initialize(Token tok) {
        super.initialize(tok);
        this.line = tok.getLine();
    }

    public void initialize(AST t) {
        super.initialize(t);
        if (t instanceof CommonASTWithLineNumber) {
            this.setLine(((CommonASTWithLineNumber)t).getLine());
            this.setPositionElement(((CommonASTWithLineNumber)t).getPositionElement());
        }
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int i) {
        this.line = i;
    }

    public String toStringTree() {
        return "\t" + super.toStringTree() + "\n";
    }

    public void addASTList(CommonASTWithLineNumber astList) {
        if (astList.getType() != 183) {
            return;
        }
        ASTFactory astFactory = new ASTFactory();
        AST current = null;
        int i = 0;
        while (i < astList.getNumberOfChildren()) {
            current = i == 0 ? astList.getFirstChild() : current.getNextSibling();
            this.addChild(astFactory.dupTree(current));
            ++i;
        }
    }

    public String toString() {
        String returnString = super.toString();
        if (this.getType() == 219 && this.line > 0) {
            returnString = String.valueOf(returnString) + " (l." + this.getLine() + ")";
        }
        return returnString;
    }

    public void showTreeFrame(String[] tokenNames, Point screenLocation, String searchString) {
        int line;
        boolean expandAll = false;
        CommonAST.setVerboseStringConversion((boolean)true, (String[])tokenNames);
        ASTFactory factory = new ASTFactory();
        AST r = factory.dupTree((AST)this);
        ExpandableASTFrame frame = new ExpandableASTFrame(this.toString(), r);
        if (searchString != null) {
            ListIterator placesOfDiscovery = frame.tp.findInTree(searchString).listIterator();
            TreePath firstHit = null;
            while (placesOfDiscovery.hasNext()) {
                TreePath tpath = (TreePath)placesOfDiscovery.next();
                if (firstHit == null) {
                    firstHit = tpath;
                }
                if (tpath == null) continue;
                frame.tp.tree.addSelectionPath(tpath);
                frame.tp.expandAll(tpath, true);
                if (tpath.getParentPath() == null) continue;
                frame.tp.expandAll(tpath.getParentPath(), true);
            }
            if (firstHit != null) {
                frame.tp.tree.scrollPathToVisible(firstHit);
            }
        } else if (expandAll) {
            frame.tp.expandAll(true);
        }
        if ((line = this.findFirstLineNumer()) > 0) {
            frame.setTitle(String.valueOf(frame.getTitle()) + ", line " + line);
        }
        frame.setSize(400, 996);
        frame.setLocation(screenLocation);
        frame.setVisible(true);
    }

    protected int findFirstLineNumer() {
        int line = this.getLine();
        if (line >= 0) {
            return line;
        }
        CommonASTWithLineNumber current = (CommonASTWithLineNumber)this.getFirstChild();
        while (current != null && (line = current.findFirstLineNumer()) < 0) {
            if ((current = (CommonASTWithLineNumber)current.getNextSibling()) == null || (line = current.getLine()) >= 0) break;
        }
        return line;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public PositionElement getPositionElement() {
        return this.position_element;
    }

    public void setPositionElement(PositionElement position_element) {
        this.position_element = position_element;
    }
}

