/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi;

import java.io.Serializable;

public class CodeblockInfo
implements Serializable {
    int totalLines;
    int commentLines;
    int branches;
    int statements;
    int type;
    public static int ASM = 1;
    public static int DELPHI = 0;

    public CodeblockInfo() {
        this.totalLines = 0;
        this.type = DELPHI;
        this.commentLines = 0;
        this.branches = 0;
        this.statements = 0;
    }

    public CodeblockInfo(int totalLines, int commentLines, int branches, int statements) {
        this.totalLines = totalLines;
        this.commentLines = commentLines;
        this.branches = branches;
        this.statements = statements;
        this.type = DELPHI;
    }

    public int getBranches() {
        return this.branches;
    }

    public int getCommentLines() {
        return this.commentLines;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public int getType() {
        return this.type;
    }

    public void setASM() {
        this.setType(ASM);
    }

    public void setDELPHI(int i) {
        this.setType(DELPHI);
    }

    public void setBranches(int i) {
        this.branches = i;
    }

    public void addBranch() {
        ++this.branches;
    }

    public void setCommentLines(int i) {
        this.commentLines = i;
    }

    public void setTotalLines(int i) {
        this.totalLines = i;
    }

    public void setType(int i) {
        switch (i) {
            case 0: {
                this.type = DELPHI;
                break;
            }
            case 1: {
                this.type = ASM;
                break;
            }
        }
    }

    public CodeblockInfo add(CodeblockInfo ci) {
        if (this.type == ci.getType()) {
            this.setBranches(this.branches + ci.getBranches());
            this.setTotalLines(this.totalLines + ci.getTotalLines());
            this.setCommentLines(this.commentLines + ci.getCommentLines());
            this.setStatements(this.statements + ci.getStatements());
        }
        return this;
    }

    public int getStatements() {
        return this.statements;
    }

    public void setStatements(int i) {
        this.statements = i;
    }
}

