/*
 * Decompiled with CFR 0.152.
 */
package de.cas.test.deadcode.graph.io;

import de.cas.deadcode.graph.Graph;
import de.cas.deadcode.graph.io.Graph2GMLWriter;
import de.cas.deadcode.graph.io.GraphWriter;
import de.cas.test.deadcode.graph.Node;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;

public class Graph2GMLWriterTest
extends TestCase {
    private static final String gmlFile = "C:\\temp\\Graph2GMLWriterTest.gml";

    public Graph createGraph() {
        Graph graph = new Graph();
        Node pkg = (Node)graph.addNode(new Node("Package"));
        Node classA = (Node)graph.addNode(new Node("ClassA"));
        Node classB = (Node)graph.addNode(new Node("ClassB"));
        graph.addEdge(pkg, classA);
        graph.addEdge(pkg, classB);
        return graph;
    }

    public final void testWrite() {
        Graph graph = this.createGraph();
        Graph2GMLWriter gw = new Graph2GMLWriter(graph);
        ((GraphWriter)gw).write(System.out);
    }

    public final void testWriteToFile() {
        Graph graph = this.createGraph();
        try {
            PrintStream out = new PrintStream(new FileOutputStream(gmlFile));
            Graph2GMLWriter gw = new Graph2GMLWriter(graph);
            ((GraphWriter)gw).write(out);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Graph2GMLWriterTest.fail();
        }
    }

    public final void testgetColorString() {
        System.out.println("Color strings:");
        System.out.println("Red is " + Graph2GMLWriter.getColorString(Color.RED));
        System.out.println("Green is " + Graph2GMLWriter.getColorString(Color.GREEN));
        System.out.println("Blue is " + Graph2GMLWriter.getColorString(Color.BLUE));
        System.out.println("Black is " + Graph2GMLWriter.getColorString(Color.BLACK));
        System.out.println("Gray is " + Graph2GMLWriter.getColorString(Color.GRAY));
        System.out.println("Light gray is " + Graph2GMLWriter.getColorString(Color.LIGHT_GRAY));
        System.out.println("White is " + Graph2GMLWriter.getColorString(Color.WHITE));
    }
}

