/*
 * Decompiled with CFR 0.152.
 */
package de.cas.test.deadcode.graph;

import de.cas.deadcode.graph.Edge;
import de.cas.deadcode.graph.Graph;
import de.cas.test.deadcode.graph.Node;
import java.util.Iterator;
import junit.framework.TestCase;

public class GraphTest
extends TestCase {
    public Graph createGraph(boolean directed) {
        Graph graph = new Graph();
        Node a = new Node("A");
        Node b = new Node("B");
        graph.addNode(a);
        graph.addNode(b);
        return graph;
    }

    public final void testAddNodeNode() {
        Graph graph = this.createGraph(true);
        GraphTest.assertEquals((int)2, (int)graph.size());
        Node anothera = new Node("A");
        graph.addNode(anothera);
        GraphTest.assertEquals((int)2, (int)graph.size());
    }

    public final void testAddEdgeNodeNode() {
        System.out.println("Directed Graph:");
        Graph graph = this.createGraph(true);
        graph.addEdge(new Node("A"), new Node("B"), 1.0);
        graph.addEdge(new Node("B"), new Node("A"), 2.0);
        GraphTest.assertEquals((int)1, (int)graph.getIncomingEdges(new Node("A")).size());
        GraphTest.assertEquals((int)1, (int)graph.getOutgoingEdges(new Node("A")).size());
        GraphTest.assertEquals((int)2, (int)graph.getAdjacentEdges(new Node("A")).size());
        graph.addEdge(new Node("A"), new Node("C"), 3.0);
        graph.addEdge(new Node("A"), new Node("D"), 4.0);
        System.out.println("Outgoing edges of A:");
        Iterator<Edge> it = graph.getOutgoingEdges(new Node("A")).iterator();
        while (it.hasNext()) {
            System.out.println(it.next().toString());
        }
        System.out.println("Incoming edges of A:");
        it = graph.getIncomingEdges(new Node("A")).iterator();
        while (it.hasNext()) {
            System.out.println(it.next().toString());
        }
        GraphTest.assertEquals((int)4, (int)graph.getAdjacentEdges(new Node("A")).size());
        System.out.println("Edges of the graph:");
        it = graph.getEdges().iterator();
        while (it.hasNext()) {
            System.out.println(it.next().toString());
        }
        System.out.println("Undirected Graph:");
        graph = new Graph(false);
        graph.addEdge(new Node("A"), new Node("B"), 1.0);
        graph.addEdge(new Node("B"), new Node("A"), 2.0);
        GraphTest.assertEquals((int)1, (int)graph.getIncomingEdges(new Node("A")).size());
        GraphTest.assertEquals((int)1, (int)graph.getOutgoingEdges(new Node("A")).size());
        GraphTest.assertEquals((int)1, (int)graph.getAdjacentEdges(new Node("A")).size());
        graph.addEdge(new Node("A"), new Node("C"), 3.0);
        graph.addEdge(new Node("A"), new Node("D"), 4.0);
        System.out.println("Outgoing edges of A:");
        it = graph.getOutgoingEdges(new Node("A")).iterator();
        while (it.hasNext()) {
            System.out.println(it.next().toString());
        }
        System.out.println("Incoming edges of A:");
        it = graph.getIncomingEdges(new Node("A")).iterator();
        while (it.hasNext()) {
            System.out.println(it.next().toString());
        }
        GraphTest.assertEquals((int)3, (int)graph.getAdjacentEdges(new Node("A")).size());
        System.out.println("Edges of the graph:");
        it = graph.getSortedEdges().iterator();
        while (it.hasNext()) {
            System.out.println(it.next().toString());
        }
    }
}

