/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode.graph.io;

import de.cas.deadcode.graph.Edge;
import de.cas.deadcode.graph.Graph;
import de.cas.deadcode.graph.io.GraphWriter;
import java.io.PrintStream;

public class Graph2SRFWriter
extends GraphWriter {
    private final String Entity_KW = "node";
    private final String Relation_KW = "edge";
    private static final String Delimiter = "\t";

    public Graph2SRFWriter(Graph gr) {
        super(gr);
    }

    @Override
    public void write(PrintStream ps) {
        this.writeHeader(ps);
        this.writeNodes(ps);
        this.writeEdges(ps);
    }

    private void writeHeader(PrintStream ps) {
        ps.print("ENTITY_TYPE");
        ps.print(Delimiter);
        ps.println("node");
        ps.print("RELATION_TYPE");
        ps.print(Delimiter);
        ps.println("edge");
    }

    private void writeNodes(PrintStream ps) {
        for (Object node : this.graph.getNodes()) {
            if (!this.filter.containsNode(node)) continue;
            ps.print("node");
            ps.print(Delimiter);
            ps.print(this.formatter.getLabel(node));
            ps.println();
        }
    }

    private void writeEdges(PrintStream ps) {
        for (Edge edge : this.graph.getEdges()) {
            if (!this.filter.containsEdge(edge)) continue;
            ps.print("edge");
            ps.print(Delimiter);
            ps.print(this.formatter.getLabel(edge.getSourceNode()));
            ps.print(Delimiter);
            ps.print(this.formatter.getLabel(edge.getTargetNode()));
            ps.println();
        }
    }
}

