/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode.graph.io;

import de.cas.deadcode.graph.Edge;
import de.cas.deadcode.graph.Graph;
import de.cas.deadcode.graph.Marker;
import de.cas.deadcode.graph.NodeNumbering;
import de.cas.deadcode.graph.io.GraphWriter;
import de.cas.deadcode.graph.io.NodeFormatter;
import java.awt.Color;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Graph2GMLWriter
extends GraphWriter {
    private final String indent = "  ";
    private final String header = "# This file was written by ACT.";
    private final Color defaultColor = Color.LIGHT_GRAY;
    private static final String defaultShape = "rectangle";
    private List<Marker> markers = new ArrayList<Marker>();
    private Map<Marker, Color> markerColors = new HashMap<Marker, Color>();
    private Map<Marker, String> markerShapes = new HashMap<Marker, String>();
    private NodeNumbering numbering;
    private int level = 0;

    public Graph2GMLWriter(Graph gr) {
        super(gr);
    }

    public Graph2GMLWriter(Graph gr, NodeFormatter formatter) {
        super(gr, formatter);
    }

    public void addMarker(Marker marker, String shape, Color color) {
        this.markers.add(marker);
        this.markerShapes.put(marker, shape);
        this.markerColors.put(marker, color);
    }

    @Override
    public void write(PrintStream ps) {
        this.numbering = new NodeNumbering(this.graph);
        this.writeGMLHeader(ps);
        this.writeGMLGraph(ps, "", this.graph.isDirected());
    }

    private void writeGMLHeader(PrintStream ps) {
        ps.println("# This file was written by ACT.");
        ps.println();
    }

    private void writeGMLGraph(PrintStream ps, String label, boolean directed) {
        ps.println("graph [");
        ps.println();
        ++this.level;
        if (label != null && !label.equals("")) {
            ps.println(String.valueOf(this.getCurrentIndent()) + "label \"" + label + "\"");
            ps.println();
        }
        if (directed) {
            ps.println(String.valueOf(this.getCurrentIndent()) + "directed 1");
        } else {
            ps.println(String.valueOf(this.getCurrentIndent()) + "directed 0");
        }
        ps.println();
        if (this.numbering.isValid()) {
            this.writeNodes(ps);
            this.writeEdges(ps);
        }
        ps.println("]");
    }

    private void writeNodes(PrintStream ps) {
        for (Object node : this.graph.getNodes()) {
            if (!this.filter.containsNode(node)) continue;
            this.writeGMLNode(ps, this.numbering.getNumber(node), this.formatter.getLabel(node), this.getShape(node), Graph2GMLWriter.getColorString(this.getColor(node)));
        }
    }

    private String getShape(Object node) {
        String result = defaultShape;
        for (Marker m : this.markers) {
            String shape = this.markerShapes.get(m);
            if (!m.isMarked(node) || shape == null || shape.equals("")) continue;
            result = shape;
        }
        return result;
    }

    private Color getColor(Object node) {
        Color result = this.defaultColor;
        for (Marker m : this.markers) {
            Color color = this.markerColors.get(m);
            if (!m.isMarked(node) || color == null) continue;
            result = color;
        }
        return result;
    }

    private void writeGMLNode(PrintStream ps, int id, String label) {
        ps.println(String.valueOf(this.getCurrentIndent()) + "node [");
        ++this.level;
        ps.print(String.valueOf(this.getCurrentIndent()) + "id ");
        ps.println(id);
        ps.println(String.valueOf(this.getCurrentIndent()) + "label \"" + label + "\"");
        --this.level;
        ps.println(String.valueOf(this.getCurrentIndent()) + "]");
        ps.println();
    }

    private void writeGMLNode(PrintStream ps, int id, String label, String shape, String color) {
        ps.println(String.valueOf(this.getCurrentIndent()) + "node [");
        ++this.level;
        ps.print(String.valueOf(this.getCurrentIndent()) + "id ");
        ps.println(id);
        ps.println(String.valueOf(this.getCurrentIndent()) + "label \"" + label + "\"");
        this.writeGMLGraphics(ps, shape, color);
        --this.level;
        ps.println(String.valueOf(this.getCurrentIndent()) + "]");
        ps.println();
    }

    private void writeGMLGraphics(PrintStream ps, String shape, String color) {
        ps.println(String.valueOf(this.getCurrentIndent()) + "graphics [");
        ++this.level;
        ps.println(String.valueOf(this.getCurrentIndent()) + "type \"" + shape + "\"");
        ps.println(String.valueOf(this.getCurrentIndent()) + "fill \"" + color + "\"");
        --this.level;
        ps.println(String.valueOf(this.getCurrentIndent()) + "]");
    }

    private void writeEdges(PrintStream ps) {
        for (Edge edge : this.graph.getEdges()) {
            if (!this.filter.containsEdge(edge)) continue;
            this.writeGMLEdge(ps, this.numbering.getNumber(edge.getSourceNode()), this.numbering.getNumber(edge.getTargetNode()));
        }
    }

    private void writeGMLEdge(PrintStream ps, int srcId, int dstId) {
        ps.println(String.valueOf(this.getCurrentIndent()) + "edge [");
        ++this.level;
        ps.print(String.valueOf(this.getCurrentIndent()) + "source ");
        ps.println(srcId);
        ps.print(String.valueOf(this.getCurrentIndent()) + "target ");
        ps.println(dstId);
        --this.level;
        ps.println(String.valueOf(this.getCurrentIndent()) + "]");
        ps.println();
    }

    private String getCurrentIndent() {
        String result = "";
        int i = 0;
        while (i <= this.level) {
            result = result.concat("  ");
            ++i;
        }
        return result;
    }

    public static String getColorString(Color color) {
        return "#" + Graph2GMLWriter.getHexString(color.getRed(), 2) + Graph2GMLWriter.getHexString(color.getGreen(), 2) + Graph2GMLWriter.getHexString(color.getBlue(), 2);
    }

    private static String getHexString(int i, int width) {
        String result = Integer.toHexString(i);
        while (result.length() < width) {
            result = "0" + result;
        }
        return result;
    }
}

