/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode.graph.io;

import de.cas.deadcode.graph.Edge;
import de.cas.deadcode.graph.Graph;
import de.cas.deadcode.graph.io.GraphWriter;
import java.io.PrintStream;

public class Graph2DotWriter
extends GraphWriter {
    private float edgeThreshold = 0.0f;

    public Graph2DotWriter(Graph gr) {
        super(gr);
    }

    public Graph2DotWriter(Graph gr, float edgeThreshold) {
        super(gr);
        this.edgeThreshold = edgeThreshold;
    }

    @Override
    public void write(PrintStream ps) {
        this.writeHeader(ps);
        this.writeEdges(ps);
        this.writeFooter(ps);
    }

    protected void writeHeader(PrintStream ps) {
        ps.println("graph G {");
    }

    protected void writeFooter(PrintStream ps) {
        ps.println("}");
    }

    protected void writeEdges(PrintStream ps) {
        for (Edge edge : this.graph.getEdges()) {
            if (!this.filter.containsEdge(edge) || !(edge.getValue() > (double)this.edgeThreshold)) continue;
            ps.print("\"" + this.formatter.getLabel(edge.getSourceNode()) + "\"");
            ps.print(" -- ");
            ps.print("\"" + this.formatter.getLabel(edge.getTargetNode()) + "\"");
            ps.print(" [label=\"" + edge.getValue() + "\" ]");
            ps.println();
        }
    }
}

