/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode.graph;

import de.cas.deadcode.graph.Graph;
import de.cas.deadcode.graph.Marker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ListMarker
extends Marker {
    private HashSet<Object> nodes = new HashSet();
    private HashMap<Object, String> comments = new HashMap();

    public ListMarker(Graph graph) {
        super(graph);
    }

    @Override
    public boolean isMarked(Object node) {
        return this.nodes.contains(node) && this.graph.hasNode(node);
    }

    public String getComment(Object node) {
        return this.comments.get(node);
    }

    public void addNode(Object node) {
        if (this.graph.hasNode(node)) {
            this.nodes.add(node);
        }
    }

    public void addNode(Object node, String comment) {
        if (this.graph.hasNode(node)) {
            this.nodes.add(node);
            this.comments.put(node, comment);
        }
    }

    public void addNodes(Collection<Object> nodes) {
        for (Object node : nodes) {
            this.addNode(node);
        }
    }

    @Override
    public List<Object> getNodes() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object node : this.nodes) {
            result.add(node);
        }
        return result;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }
}

