/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode.graph;

import de.cas.deadcode.graph.Graph;

public abstract class GraphDependant {
    private Graph graph;
    protected boolean isValid;

    GraphDependant(Graph graph) {
        this.graph = graph;
        graph.registerDependentObject(this);
        this.isValid = false;
    }

    public void invalidate() {
        this.isValid = false;
        this.destroy();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public Graph getGraph() {
        return this.graph;
    }

    protected void destroy() {
        this.isValid = false;
        this.graph.deregisterDependentObject(this);
    }
}

