/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode.graph;

import de.cas.deadcode.graph.DFSGraphIterator;
import de.cas.deadcode.graph.Edge;
import de.cas.deadcode.graph.EdgeComparatorDescending;
import de.cas.deadcode.graph.GraphDependant;
import de.cas.deadcode.graph.UndirectedEdge;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Graph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<Object> nodes;
    private Set<Edge> edges;
    private Map<Object, HashSet<Edge>> incomingEdges;
    private Map<Object, HashSet<Edge>> outgoingEdges;
    private boolean directed;
    private Set<Object> dependentObjects;

    public Graph() {
        this.init(true);
    }

    public Graph(boolean directed) {
        this.init(directed);
    }

    protected void init(boolean directed) {
        this.edges = new HashSet<Edge>();
        this.nodes = new HashSet<Object>();
        this.incomingEdges = new HashMap<Object, HashSet<Edge>>();
        this.outgoingEdges = new HashMap<Object, HashSet<Edge>>();
        this.directed = directed;
        this.dependentObjects = new HashSet<Object>();
    }

    public boolean isDirected() {
        return this.directed;
    }

    public Object addNode(Object node) {
        if (this.hasNode(node)) {
            return node;
        }
        this.nodes.add(node);
        this.incomingEdges.put(node, new HashSet());
        this.outgoingEdges.put(node, new HashSet());
        this.invalidateDependentObjects();
        return node;
    }

    public boolean hasNode(Object node) {
        return this.nodes.contains(node);
    }

    public Set<Object> getNodes() {
        Iterator<Object> it = this.nodes.iterator();
        HashSet<Object> result = new HashSet<Object>();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public Edge addEdge(Object src, Object tgt) {
        return this.addEdge(src, tgt, 1.0);
    }

    public Edge addEdge(Object src1, Object tgt1, double value) {
        Object src = this.addNode(src1);
        Object tgt = this.addNode(tgt1);
        Set srcIns = this.incomingEdges.get(src);
        Set srcOuts = this.outgoingEdges.get(src);
        Set dstIns = this.incomingEdges.get(tgt);
        Set dstOuts = this.outgoingEdges.get(tgt);
        Edge oldone = this.getEdge(src, tgt);
        if (oldone != null) {
            srcOuts.remove(oldone);
            dstIns.remove(oldone);
            this.edges.remove(oldone);
            if (!this.directed) {
                srcIns.remove(oldone);
                dstOuts.remove(oldone);
            }
        }
        Edge edge = this.newEdge(src, tgt, value);
        srcOuts.add(edge);
        dstIns.add(edge);
        this.edges.add(edge);
        if (!this.directed) {
            srcIns.add(edge);
            dstOuts.add(edge);
        }
        this.invalidateDependentObjects();
        return edge;
    }

    private Edge newEdge(Object src, Object tgt) {
        return this.newEdge(src, tgt, 1.0);
    }

    private Edge newEdge(Object src, Object tgt, double value) {
        if (this.directed) {
            return new Edge(src, tgt, value);
        }
        return new UndirectedEdge(src, tgt, value);
    }

    boolean hasEdge(Object src, Object tgt) {
        return this.getEdge(src, tgt) != null;
    }

    Edge getEdge(Object src, Object tgt) {
        Edge edge = this.newEdge(src, tgt);
        Set outs = this.outgoingEdges.get(src);
        Iterator it = outs.iterator();
        Edge found = null;
        while (it.hasNext()) {
            found = (Edge)it.next();
            if (!edge.equals(found)) continue;
            return found;
        }
        return null;
    }

    public Set<Edge> getEdges() {
        HashSet<Edge> result = new HashSet<Edge>();
        Iterator<Edge> it = this.edges.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public List<Edge> getSortedEdges() {
        ArrayList<Edge> result = new ArrayList<Edge>();
        Iterator<Edge> it = this.edges.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        Collections.sort(result, new EdgeComparatorDescending());
        return result;
    }

    public int size() {
        return this.nodes.size();
    }

    public Set<Edge> getOutgoingEdges(Object node) {
        if (!this.hasNode(node)) {
            return null;
        }
        HashSet<Edge> result = new HashSet<Edge>();
        Iterator it = ((Set)this.outgoingEdges.get(node)).iterator();
        while (it.hasNext()) {
            result.add((Edge)it.next());
        }
        return result;
    }

    public Set<Edge> getIncomingEdges(Object node) {
        if (!this.hasNode(node)) {
            return null;
        }
        HashSet<Edge> result = new HashSet<Edge>();
        Iterator it = ((Set)this.incomingEdges.get(node)).iterator();
        while (it.hasNext()) {
            result.add((Edge)it.next());
        }
        return result;
    }

    public Set<Edge> getAdjacentEdges(Object node) {
        Set<Edge> result = this.getIncomingEdges(node);
        result.addAll(this.getOutgoingEdges(node));
        return result;
    }

    public Object[] getEdgeArray(Object node) {
        return this.getAdjacentEdges(node).toArray();
    }

    public float getAverageEdgeValue(Object node) {
        ArrayList al = (ArrayList)((Object)this.getAdjacentEdges(node));
        float sum = 0.0f;
        int i = 0;
        while (i < al.size()) {
            Edge e = (Edge)al.get(i);
            sum = (float)((double)sum + e.getValue());
            ++i;
        }
        if (al.size() > 0) {
            return sum / (float)al.size();
        }
        return sum;
    }

    public double getMaxEdgeValue() {
        double max = 0.0;
        for (Edge e : this.edges) {
            if (!(max < e.getValue())) continue;
            max = e.getValue();
        }
        return max;
    }

    public Object getNearestNeighbor(Object node) {
        Set<Edge> outEdges = this.getOutgoingEdges(node);
        Edge largest = null;
        for (Edge e : outEdges) {
            if (largest == null) {
                largest = e;
            }
            if (!(e.getValue() > largest.getValue())) continue;
            largest = e;
        }
        if (largest != null) {
            if (largest.getSourceNode().equals(node)) {
                return largest.getTargetNode();
            }
            if (largest.getTargetNode().equals(node)) {
                return largest.getSourceNode();
            }
        }
        return null;
    }

    public Set<Object> getIsolatedNodes() {
        Iterator<Object> it = this.nodes.iterator();
        HashSet<Object> result = new HashSet<Object>();
        while (it.hasNext()) {
            if (!this.getAdjacentEdges(it).isEmpty()) continue;
            result.add(it);
        }
        return result;
    }

    public void invalidateDependentObjects() {
        for (GraphDependant graphDependant : this.dependentObjects) {
            graphDependant.invalidate();
        }
    }

    public void registerDependentObject(GraphDependant dependentObject) {
        this.dependentObjects.add(dependentObject);
    }

    public void deregisterDependentObject(GraphDependant dependentObject) {
        this.dependentObjects.remove(dependentObject);
    }

    public Iterator<Object> dfsGraphIterator(Object node) {
        return new DFSGraphIterator<Object>(this, node);
    }

    protected static List<Edge> removeDuplicates(ArrayList<Edge> directedEdges) {
        ArrayList<Edge> g = new ArrayList<Edge>(directedEdges.size());
        Iterator<Edge> iter = directedEdges.iterator();
        boolean found = false;
        while (iter.hasNext()) {
            found = false;
            Edge nEdge = iter.next();
            int j = 0;
            while (j < g.size()) {
                if (g.get(j).equals(nEdge)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (found) continue;
            g.add(nEdge);
        }
        return g;
    }
}

