/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode.graph;

import de.cas.deadcode.graph.Edge;
import de.cas.deadcode.graph.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DFSGraphIterator<T>
implements Iterator<T> {
    private Graph graph;
    private Set<T> visitedNodes;
    private List<T> stack;

    public DFSGraphIterator(Graph graph, T start) {
        this.graph = graph;
        this.visitedNodes = new HashSet<T>();
        this.stack = new ArrayList<T>();
        if (graph.hasNode(start)) {
            this.stack.add(0, start);
            this.visitedNodes.add(start);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public T next() {
        if (this.stack.isEmpty()) {
            return null;
        }
        T current = this.stack.get(0);
        this.stack.remove(0);
        for (Edge edge : this.graph.getOutgoingEdges(current)) {
            Object neighbour = edge.getTargetNode();
            if (this.visitedNodes.contains(neighbour)) continue;
            this.stack.add(0, neighbour);
            this.visitedNodes.add(neighbour);
        }
        return current;
    }

    @Override
    public void remove() {
    }
}

