/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode;

import de.cas.deadcode.AbstractionFilter;
import de.cas.deadcode.CallGraph;
import de.cas.deadcode.ClassGraph;
import de.cas.deadcode.ClassNodeFormatter;
import de.cas.deadcode.graph.io.Filter;
import de.cas.deadcode.graph.io.Graph2GMLWriter;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.persistence.JDBCWrapper;
import de.fzi.sissy.persistence.ModelImporter;
import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.persistence.config.PostgresqlDatabaseConfiguration;
import jargs.gnu.CmdLineParser;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class GraphDumper {
    private String database;
    private boolean inheritance;
    private boolean calls;
    private String filterString;
    private String outfile;
    private Root modelRoot;
    private Filter filter;

    public static void main(String[] args) {
        GraphDumper gd = new GraphDumper(args);
        gd.run();
    }

    public void printUsage() {
        System.out.println("Usage: dumpgraph [--cfg jdbc_config_file] [--db database]\n                [{-i,--inheritance} ]\n                [{-c,--calls} ]\n                [{-o,--outfile}]\n                [--filter list_of_abstractions]");
    }

    public final void parseCmdLineOptions(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option dbOpt = parser.addStringOption('b', "db");
        CmdLineParser.Option inheritanceOpt = parser.addBooleanOption('i', "inheritance");
        CmdLineParser.Option callsOpt = parser.addBooleanOption('c', "calls");
        CmdLineParser.Option outfileOpt = parser.addStringOption('o', "outfile");
        CmdLineParser.Option filterOpt = parser.addStringOption("filter");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            this.printUsage();
            throw new Error("2");
        }
        this.database = (String)parser.getOptionValue(dbOpt);
        this.inheritance = (Boolean)parser.getOptionValue(inheritanceOpt, (Object)Boolean.FALSE);
        this.calls = (Boolean)parser.getOptionValue(callsOpt, (Object)Boolean.FALSE);
        this.outfile = (String)parser.getOptionValue(outfileOpt);
        this.filterString = (String)parser.getOptionValue(filterOpt);
    }

    public GraphDumper(String[] args) {
        this.parseCmdLineOptions(args);
    }

    public void run() {
        System.err.println("Reading model from database...");
        this.setupFromDB();
        this.filter = this.filterString != null ? new AbstractionFilter(this.filterString, this.modelRoot) : new Filter();
        ClassGraph classGraph = new ClassGraph(this.modelRoot);
        Graph2GMLWriter writer = new Graph2GMLWriter(classGraph, new ClassNodeFormatter());
        writer.setFilter(this.filter);
        if (this.inheritance) {
            classGraph.addInheritance();
        }
        if (this.calls) {
            CallGraph callGraph = new CallGraph(this.modelRoot);
            classGraph.addCalls(callGraph);
        }
        try {
            PrintStream out = System.out;
            if (this.outfile != null && !this.outfile.equals("")) {
                out = new PrintStream(new FileOutputStream(this.outfile));
            }
            writer.write(out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
            System.err.println("Error writing graph to file " + this.outfile);
            return;
        }
    }

    public void setupFromDB() {
        PostgresqlDatabaseConfiguration dbConf = new PostgresqlDatabaseConfiguration();
        dbConf.setDatabaseName(this.database);
        JDBCWrapper jdbcWrapper = JDBCWrapper.createJDBCWrapper((DatabaseConfiguration)dbConf);
        ModelImporter mi = new ModelImporter(jdbcWrapper);
        this.modelRoot = mi.getRoot();
    }
}

