/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode;

import de.cas.deadcode.AbstractionFilter;
import de.cas.deadcode.CallGraph;
import de.cas.deadcode.FunctionNodeFormatter;
import de.cas.deadcode.Utils;
import de.cas.deadcode.graph.ListMarker;
import de.cas.deadcode.graph.io.Filter;
import de.cas.deadcode.graph.io.Graph2GMLWriter;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.NamedModelElement;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.metamod.Signature;
import de.fzi.sissy.persistence.JDBCWrapper;
import de.fzi.sissy.persistence.ModelImporter;
import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.persistence.config.PostgresqlDatabaseConfiguration;
import jargs.gnu.CmdLineParser;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Set;

public class DeadCodeAnalyzer {
    private Root modelRoot;
    private CallGraph callGraph;
    private String entrySpec;
    private String callgraphFileName;
    private String deadFunctionsFileName;
    private String reachableFunctionsFileName;
    private String uncalledFunctionsFileName;
    private boolean initializers;
    private boolean introspectables;
    private boolean classMeths;
    private boolean interfaces;
    private String apifiles;
    private String filterString;
    private String database;
    private Filter filter;

    public static void main(String[] args) {
        DeadCodeAnalyzer dca = new DeadCodeAnalyzer(args);
        dca.run();
    }

    public void printUsage() {
        System.out.println("Usage: deadcode [--cfg jdbc_config_file] [--db database]\n                [{-e,--entryspec} regexp]\n                [{-c,--callgraph} gml_file]\n                [{-u,--uncalled} csv_file]\n                [{-d,--dead} csv_file]\n                [{-r,--reachable} csv_file]\n                [--filter list_of_abstractions]\n                [--initializers] [--introspectables] [--classmeths]\n                [--interfaces]\n                [--apifiles regexp]");
    }

    public final void parseCmdLineOptions(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option dbOpt = parser.addStringOption('b', "db");
        CmdLineParser.Option entryspecOpt = parser.addStringOption('e', "entryspec");
        CmdLineParser.Option callgraphOpt = parser.addStringOption('c', "callgraph");
        CmdLineParser.Option reachableFunctionsFileOpt = parser.addStringOption('r', "reachable");
        CmdLineParser.Option deadFunctionsFileOpt = parser.addStringOption('r', "dead");
        CmdLineParser.Option uncalledFunctionsFileOpt = parser.addStringOption('u', "uncalled");
        CmdLineParser.Option filterOpt = parser.addStringOption("filter");
        CmdLineParser.Option initializersOpt = parser.addBooleanOption("initializers");
        CmdLineParser.Option introspectablesOpt = parser.addBooleanOption("introspectables");
        CmdLineParser.Option classMethsOpt = parser.addBooleanOption("classmeths");
        CmdLineParser.Option interfacesOpt = parser.addBooleanOption("interfaces");
        CmdLineParser.Option apifilesOpt = parser.addStringOption("apifiles");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            this.printUsage();
            throw new Error("2");
        }
        this.database = (String)parser.getOptionValue(dbOpt);
        this.callgraphFileName = (String)parser.getOptionValue(callgraphOpt);
        this.uncalledFunctionsFileName = (String)parser.getOptionValue(uncalledFunctionsFileOpt);
        this.reachableFunctionsFileName = (String)parser.getOptionValue(reachableFunctionsFileOpt);
        this.deadFunctionsFileName = (String)parser.getOptionValue(deadFunctionsFileOpt);
        this.entrySpec = (String)parser.getOptionValue(entryspecOpt, (Object)"main");
        this.initializers = (Boolean)parser.getOptionValue(initializersOpt, (Object)Boolean.FALSE);
        this.introspectables = (Boolean)parser.getOptionValue(introspectablesOpt, (Object)Boolean.FALSE);
        this.classMeths = (Boolean)parser.getOptionValue(classMethsOpt, (Object)Boolean.FALSE);
        this.interfaces = (Boolean)parser.getOptionValue(interfacesOpt, (Object)Boolean.FALSE);
        this.apifiles = (String)parser.getOptionValue(apifilesOpt);
        this.filterString = (String)parser.getOptionValue(filterOpt);
        if (this.callgraphFileName == null && this.uncalledFunctionsFileName == null && this.reachableFunctionsFileName == null && this.deadFunctionsFileName == null) {
            this.printUsage();
            throw new Error("2");
        }
    }

    public DeadCodeAnalyzer(String[] args) {
        this.parseCmdLineOptions(args);
    }

    public void run() {
        PrintStream out;
        System.err.println("Reading model from database...");
        this.setupFromDB();
        this.filter = this.filterString != null ? new AbstractionFilter(this.filterString, this.modelRoot) : new Filter();
        System.err.println("Constructing callgraph... Phase 1...");
        this.callGraph = new CallGraph(this.modelRoot);
        this.entrySpec = "(" + this.entrySpec + ")";
        if (this.initializers) {
            this.callGraph.addCallsToInitializers();
            this.entrySpec = String.valueOf(this.entrySpec) + "|(\\[init\\])";
            this.callGraph.addCallsToFinalizers();
            this.callGraph.addCallsToDestructors();
            this.entrySpec = String.valueOf(this.entrySpec) + "|(\\[finalize\\])";
        }
        if (this.introspectables) {
            this.callGraph.addCallsToIntrospectables();
            this.entrySpec = String.valueOf(this.entrySpec) + "|(\\[introspect\\])";
        }
        if (this.classMeths) {
            this.callGraph.addCallsToClassMeths();
            this.entrySpec = String.valueOf(this.entrySpec) + "|(\\[classmeth\\])";
        }
        if (this.interfaces) {
            this.callGraph.addCallsToInterfaceMethods();
        }
        if (this.apifiles != null) {
            this.callGraph.addCallsToAPIFileMethods(this.apifiles);
        }
        if (this.interfaces || this.apifiles != null) {
            this.entrySpec = String.valueOf(this.entrySpec) + "|(\\[interface\\])";
        }
        System.err.println("Constructing callgraph... Phase 2: Polymorphic calls...");
        this.callGraph.addPolymorphicCalls();
        System.err.println("Calculating reachable functions...");
        this.callGraph.setEntrySpec(this.entrySpec);
        this.callGraph.computeReachableFunctions();
        Set<Function> reachableFunctions = this.callGraph.getReachableFunctions();
        if (this.callgraphFileName != null) {
            try {
                System.err.println("Dumping callgraph...");
                out = new PrintStream(new FileOutputStream(this.callgraphFileName));
                Graph2GMLWriter writer = new Graph2GMLWriter(this.callGraph, new FunctionNodeFormatter());
                ListMarker reachableMarker = new ListMarker(this.callGraph);
                reachableMarker.addNodes(reachableFunctions);
                writer.addMarker(reachableMarker, null, Color.GREEN);
                writer.setFilter(this.filter);
                writer.write(out);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                System.err.println("Error writing callgraph to file " + this.callgraphFileName);
                throw new Error("1");
            }
        }
        if (this.reachableFunctionsFileName != null) {
            try {
                System.err.println("Dumping reachable functions as CSV file...");
                out = new PrintStream(new FileOutputStream(this.reachableFunctionsFileName));
                this.exportAsCSV(reachableFunctions, out);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                System.err.println("Error writing CSV file " + this.reachableFunctionsFileName);
                throw new Error("1");
            }
        }
        if (this.deadFunctionsFileName != null) {
            try {
                System.err.println("Dumping dead functions as CSV file...");
                out = new PrintStream(new FileOutputStream(this.deadFunctionsFileName));
                this.exportAsCSV(this.callGraph.getDeadFunctions(), out);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                System.err.println("Error writing CSV file " + this.deadFunctionsFileName);
                throw new Error("1");
            }
        }
        if (this.uncalledFunctionsFileName != null) {
            try {
                System.err.println("Dumping uncalled functions as CSV file...");
                out = new PrintStream(new FileOutputStream(this.uncalledFunctionsFileName));
                this.exportAsCSV(this.callGraph.getUncalledFunctions(), out);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                System.err.println("Error writing CSV file " + this.uncalledFunctionsFileName);
                throw new Error("1");
            }
        }
    }

    public void setupFromDB() {
        PostgresqlDatabaseConfiguration dbConf = new PostgresqlDatabaseConfiguration();
        dbConf.setDatabaseName(this.database);
        JDBCWrapper jdbcWrapper = JDBCWrapper.createJDBCWrapper((DatabaseConfiguration)dbConf);
        ModelImporter mi = new ModelImporter(jdbcWrapper);
        this.modelRoot = mi.getRoot();
    }

    public void exportAsSQLCommands(Collection<Function> functions, String table, PrintStream out) {
        String createTableCmd = "create table " + table + " (Id Integer PRIMARY KEY, Name Varchar(256));";
        String insertCmdPrefix = "insert into " + table + " values ";
        out.println(createTableCmd);
        for (NamedModelElement namedModelElement : functions) {
            out.print(String.valueOf(insertCmdPrefix) + "(");
            out.print(namedModelElement.getUniqueId());
            out.print(", ");
            out.print("'" + Utils.getLongName(namedModelElement) + "'");
            out.println(");");
        }
    }

    public void exportAsCSV(Collection<Function> functions, PrintStream out) {
        out.print("id");
        out.print(";");
        out.print("package");
        out.print(";");
        out.print("class");
        out.print(";");
        out.print("function");
        out.print(";");
        out.print("signature");
        out.println();
        for (NamedModelElement namedModelElement : functions) {
            Signature sig;
            if (Utils.isSISSyInternalElement(namedModelElement) || !this.filter.containsNode(namedModelElement)) continue;
            out.print(namedModelElement.getUniqueId());
            out.print(";");
            out.print(Utils.getSurroundingPackageName(namedModelElement));
            out.print(";");
            out.print(Utils.getSurroundingClassName(namedModelElement));
            out.print(";");
            out.print(namedModelElement.getSimpleName());
            if (namedModelElement instanceof Function && (sig = ((Function)namedModelElement).signature()) != null) {
                out.print(";");
                out.print(sig.toString());
            }
            out.println();
        }
    }

    public void printDeadFunctions() {
        for (NamedModelElement namedModelElement : this.callGraph.getDeadFunctions()) {
            System.out.println(Utils.getLongName(namedModelElement));
        }
    }
}

