/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode;

import de.cas.deadcode.CallGraph;
import de.cas.deadcode.graph.Edge;
import de.cas.deadcode.graph.Graph;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Root;

public class ClassGraph
extends Graph {
    private static final long serialVersionUID = 1L;
    private Root root;

    public ClassGraph(Root modelRoot) {
        this.root = modelRoot;
        this.initialize();
    }

    private void initialize() {
        for (Class cls : this.root.getClasses()) {
            this.addNode(cls);
        }
    }

    public void addInheritance() {
        for (Class clazz : this.getNodes()) {
            for (Class subclass : clazz.getDirectDescendants()) {
                this.addEdge(subclass, clazz);
            }
        }
    }

    public void addCalls(CallGraph callGraph) {
        for (Edge edge : callGraph.getEdges()) {
            Class srcClass = null;
            Object src = edge.getSourceNode();
            if (src instanceof Member) {
                Member m = (Member)src;
                srcClass = m.getSurroundingClass();
            }
            Class tgtClass = null;
            Object tgt = edge.getTargetNode();
            if (tgt instanceof Member) {
                Member m = (Member)tgt;
                tgtClass = m.getSurroundingClass();
            }
            if (srcClass == null || tgtClass == null || srcClass == tgtClass) continue;
            this.addEdge(srcClass, tgtClass);
        }
    }
}

