/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode;

import de.cas.deadcode.graph.Edge;
import de.cas.deadcode.graph.Graph;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Constructor;
import de.fzi.sissy.metamod.Destructor;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.GlobalFunction;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.NamedModelElement;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.Property;
import de.fzi.sissy.metamod.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CallGraph
extends Graph {
    private static final long serialVersionUID = 1L;
    private GlobalFunction initNode;
    private GlobalFunction finalizeNode;
    private GlobalFunction introspectNode;
    private GlobalFunction classMethNode;
    private GlobalFunction interfaceNode;
    private String entrySpec;
    private Set<Function> reachableFunctions;

    public CallGraph(Root modelRoot) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Function func : modelRoot.getGlobalFunctions()) {
            functions.add(func);
        }
        for (Class cls : modelRoot.getClasses()) {
            ModelElementList members = new ModelElementList();
            members.addAll((Collection)cls.getMethods());
            members.addAll((Collection)cls.getConstructors());
            members.addAll((Collection)cls.getDestructors());
            for (Member meth : members) {
                functions.add((Function)meth);
            }
        }
        for (Function func : functions) {
            Function tgt;
            this.addNode(func);
            for (FunctionAccess acc : func.getFunctionAccesses()) {
                tgt = acc.getAccessedFunction();
                if (tgt == null) continue;
                this.addEdge(func, tgt);
            }
            for (FunctionAccess acc : func.getVariableAccesses()) {
                Method setter;
                tgt = acc.getAccessedVariable();
                if (tgt == null || !(tgt instanceof Property)) continue;
                Property prop = (Property)tgt;
                Method getter = prop.getGetter();
                if (getter != null) {
                    this.addEdge(func, getter);
                }
                if ((setter = prop.getSetter()) == null) continue;
                this.addEdge(func, setter);
            }
        }
        this.initNode = new GlobalFunction("[init]");
        this.finalizeNode = new GlobalFunction("[finalize]");
        this.introspectNode = new GlobalFunction("[introspect]");
        this.classMethNode = new GlobalFunction("[classmeth]");
        this.interfaceNode = new GlobalFunction("[interface]");
    }

    public void addPolymorphicCalls() {
        for (Function function : this.getNodes()) {
            if (!(function instanceof Member)) continue;
            Member m = (Member)function;
            this.propagateCallsToDescendants(m);
        }
    }

    public ModelElementList getAllDescendants(Member m) {
        if (m.getSurroundingClass() == null) {
            System.err.println("getAllDescendants(): Surrounding class == null for : " + m.getSimpleName());
            return null;
        }
        Class scope = m.getSurroundingClass();
        ModelElementList subclasses = scope.getAllDescendants();
        if (subclasses == null) {
            return null;
        }
        ModelElementList result = new ModelElementList();
        for (Class cls : subclasses) {
            ModelElementList members = cls.getMethods();
            members.addAll((Collection)cls.getConstructors());
            members.addAll((Collection)cls.getDestructors());
            block1: for (Member cand : members) {
                if (!cand.isOverride()) continue;
                Member parent = cand.getOverridenMember();
                while (parent != null) {
                    if (parent.equals(m)) {
                        result.add((Object)cand);
                        continue block1;
                    }
                    parent = parent.getOverridenMember();
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public void addCallsToIntrospectables() {
        for (Object node : this.getNodes()) {
            Member m;
            if (!(node instanceof Member) || !(m = (Member)node).isIntrospectable()) continue;
            this.addEdge(this.introspectNode, m);
        }
    }

    public void addCallsToClassMeths() {
        for (Object node : this.getNodes()) {
            Member m;
            if (!(node instanceof Member) || !(m = (Member)node).isStatic()) continue;
            this.addEdge(this.classMethNode, m);
        }
    }

    public void addCallsToInitializers() {
        for (Object node : this.getNodes()) {
            Constructor c;
            GlobalFunction f;
            if (node instanceof GlobalFunction && (f = (GlobalFunction)node).isUnitInitializer()) {
                this.addEdge(this.initNode, f);
            }
            if (!(node instanceof Constructor) || !(c = (Constructor)node).isInitializer()) continue;
            this.addEdge(this.initNode, c);
        }
    }

    public void addCallsToFinalizers() {
        for (Object node : this.getNodes()) {
            GlobalFunction f;
            if (!(node instanceof GlobalFunction) || !(f = (GlobalFunction)node).isUnitFinalizer()) continue;
            this.addEdge(this.finalizeNode, f);
        }
    }

    public void addCallsToDestructors() {
        for (Object node : this.getNodes()) {
            if (!(node instanceof Destructor)) continue;
            Destructor d = (Destructor)node;
            this.addEdge(this.finalizeNode, d);
        }
    }

    public void addCallsToInterfaceMethods() {
        for (Object node : this.getNodes()) {
            Member m;
            Class cls;
            if (!(node instanceof Member) || (cls = (m = (Member)node).getSurroundingClass()) == null || !cls.isInterface()) continue;
            this.addEdge(this.interfaceNode, m);
        }
    }

    public void addCallsToAPIFileMethods(String apifiles_regexp) {
        Pattern pat = Pattern.compile(apifiles_regexp);
        for (Object node : this.getNodes()) {
            String filename;
            Matcher matcher;
            Function f;
            Position pos;
            if (!(node instanceof Function) || (pos = (f = (Function)node).getPosition()) == null || !(matcher = pat.matcher(filename = f.getPosition().getSourceFile().getPathName())).find()) continue;
            this.addEdge(this.interfaceNode, f);
        }
    }

    public void propagateCallsToDescendants(Member m) {
        ModelElementList descendants = this.getAllDescendants(m);
        if (descendants == null) {
            return;
        }
        for (Object desc : descendants) {
            if (!(desc instanceof Function)) continue;
            this.copyIncomingEdges(m, desc);
        }
    }

    public void copyIncomingEdges(Object n1, Object n2) {
        if (!this.hasNode(n1) || !this.hasNode(n2)) {
            return;
        }
        for (Edge edge : this.getIncomingEdges(n1)) {
            this.addEdge(edge.getSourceNode(), n2, edge.getValue());
        }
    }

    public void setEntrySpec(String entrySpec) {
        this.entrySpec = entrySpec;
    }

    public void computeReachableFunctions() {
        Pattern pat = Pattern.compile(this.entrySpec);
        this.reachableFunctions = new HashSet<Function>();
        for (Function function : this.getNodes()) {
            Matcher matcher = pat.matcher(function.getSimpleName());
            if (!matcher.find()) continue;
            Iterator<Object> nodeIt = this.dfsGraphIterator(function);
            while (nodeIt.hasNext()) {
                Function r = (Function)nodeIt.next();
                this.reachableFunctions.add(r);
            }
        }
    }

    public Set<Function> getReachableFunctions() {
        return this.reachableFunctions;
    }

    public Set<Function> getDeadFunctions() {
        HashSet<Function> result = new HashSet<Function>();
        for (NamedModelElement namedModelElement : this.getNodes()) {
            if (this.reachableFunctions.contains(namedModelElement)) continue;
            result.add((Function)namedModelElement);
        }
        return result;
    }

    public Set<Function> getUncalledFunctions() {
        Pattern pat = Pattern.compile(this.entrySpec);
        HashSet<Function> result = new HashSet<Function>();
        for (Function function : this.getNodes()) {
            Matcher matcher = pat.matcher(function.getSimpleName());
            if (matcher.find() || this.getIncomingEdges(function) != null && !this.getIncomingEdges(function).isEmpty()) continue;
            result.add(function);
        }
        return result;
    }
}

