/*
 * Decompiled with CFR 0.152.
 */
package de.cas.deadcode;

import de.cas.deadcode.graph.io.Filter;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.NamedModelElement;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.metamod.StructuralAbstraction;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class AbstractionFilter
extends Filter {
    private Set<NamedModelElement> abstractions;
    private Root modelRoot;

    public AbstractionFilter(String abstractionList, Root modelRoot) {
        this.modelRoot = modelRoot;
        this.abstractions = this.setup(abstractionList);
    }

    private Set<NamedModelElement> setup(String abstractionList) {
        HashSet<NamedModelElement> result = new HashSet<NamedModelElement>();
        if (abstractionList == null) {
            return result;
        }
        StringTokenizer st = new StringTokenizer(abstractionList, ",;: \"'");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            for (NamedModelElement abstraction : this.modelRoot.getStructuralAbstractions()) {
                if (abstraction.getSimpleName().toLowerCase().indexOf(name.toLowerCase()) < 0) continue;
                result.add(abstraction);
            }
            for (Package pack : this.modelRoot.getPackages()) {
                if (pack.getQualifiedName().toLowerCase().indexOf(name.toLowerCase()) < 0) continue;
                result.add((NamedModelElement)pack);
            }
        }
        return result;
    }

    @Override
    public boolean containsNode(Object node) {
        if (node instanceof ModelElement) {
            ModelElement elem = (ModelElement)node;
            ModelElement parent = elem.getParent();
            while (parent != null && !(parent instanceof Root)) {
                if (this.abstractions.contains(parent)) {
                    return true;
                }
                for (NamedModelElement obj : this.abstractions) {
                    StructuralAbstraction abstraction;
                    if (!(obj instanceof StructuralAbstraction) || !(abstraction = (StructuralAbstraction)obj).getModelElements().contains((Object)parent)) continue;
                    return true;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }
}

