/*
 * Decompiled with CFR 0.152.
 */
package org.somox.resources.defaultmodels;

import eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.deployment.targetenvironment.ExecutionResource;
import eu.qimpress.samm.deployment.targetenvironment.Node;
import eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;
import eu.qimpress.samm.qosannotation.QosAnnotations;
import eu.qimpress.samm.qosannotation.QosannotationPackage;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class DefaultModelLoader {
    private static Logger logger = Logger.getLogger(DefaultModelLoader.class);
    private static final String PATH_SAMM_HARDWARE_DEFAULT = "pathmap://SOMOX_MODELS/somox-default.samm_hardware";
    private static final String PATH_SAMM_TARGETENVIRONMENT_DEFAULT = "pathmap://SOMOX_MODELS/somox-default.samm_targetenvironment";
    private static final String PATH_SAMM_QOS_ANNOTATIONS_DEFAULT = "pathmap://SOMOX_MODELS/somox-default.samm_qosannotation";
    private HardwareDescriptorRepository hardwareRepositoryModel;
    private TargetEnvironment targetEnvironmentModel;
    private QosAnnotations qosAnnotationModel;

    public DefaultModelLoader() {
        this.loadDefaultModels();
    }

    public Container getDefaultContainer() {
        return (Container)((Node)this.targetEnvironmentModel.getNodes().get(0)).getContainers().get(0);
    }

    public ExecutionResource getDefaultExecutionResource() {
        return (ExecutionResource)((Container)((Node)this.targetEnvironmentModel.getNodes().get(0)).getContainers().get(0)).getExecutionResources().get(0);
    }

    private void loadDefaultModels() {
        URI fileURI = null;
        Resource resource = null;
        try {
            fileURI = URI.createURI((String)PATH_SAMM_HARDWARE_DEFAULT);
            resource = this.loadFile(fileURI);
            this.hardwareRepositoryModel = (HardwareDescriptorRepository)this.retrieveRootFromResource(resource, HardwarePackage.eINSTANCE.getHardwareDescriptorRepository());
            fileURI = URI.createURI((String)PATH_SAMM_TARGETENVIRONMENT_DEFAULT);
            resource = this.loadFile(fileURI);
            this.targetEnvironmentModel = (TargetEnvironment)this.retrieveRootFromResource(resource, TargetenvironmentPackage.eINSTANCE.getTargetEnvironment());
            fileURI = URI.createURI((String)PATH_SAMM_QOS_ANNOTATIONS_DEFAULT);
            resource = this.loadFile(fileURI);
            this.qosAnnotationModel = (QosAnnotations)this.retrieveRootFromResource(resource, QosannotationPackage.eINSTANCE.getQosAnnotations());
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load SoMoX default model " + fileURI), (Throwable)e);
        }
    }

    public Resource loadFile(URI fileURI) throws IOException {
        XMIResourceImpl resource = new XMIResourceImpl(fileURI);
        resource.load(new HashMap());
        return resource;
    }

    private EObject retrieveRootFromResource(Resource res, EClass typeToLoad) {
        return (EObject)res.getContents().get(0);
    }
}

