/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.factories;

import de.fzi.gast.core.Root;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import java.util.List;
import org.apache.log4j.Logger;
import org.somox.analyzer.simplemodelanalyzer.detection.ComponentDetectionByClustering;
import org.somox.analyzer.simplemodelanalyzer.detection.DeleteInitialComponentCandidatesStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.DummyPostComponentDetectionStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.GastToPrimitiveComponentInitializationStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.IDetectionStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.IInitializationStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.IPostComponentDetectionStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.NoGastClassToPrimitiveComponentInitializationStrategy;
import org.somox.analyzer.simplemodelanalyzer.factories.ISoMoXStrategiesFactory;
import org.somox.configuration.SoMoXConfiguration;

public class BasicSoMoXStrategiesFactory
implements ISoMoXStrategiesFactory {
    private static Logger logger = Logger.getLogger(BasicSoMoXStrategiesFactory.class);
    private Root gastModel = null;
    private SoMoXConfiguration somoxConfiguration = null;

    public BasicSoMoXStrategiesFactory(Root gastModel, SoMoXConfiguration somoxConfiguration) {
        this.gastModel = gastModel;
        this.somoxConfiguration = somoxConfiguration;
    }

    @Override
    public IDetectionStrategy getDetectionStrategy(List<ComponentImplementingClassesLink> components) {
        logger.info((Object)"Use Clustering Detection Strategy");
        return new ComponentDetectionByClustering(this.gastModel, components, this.somoxConfiguration);
    }

    @Override
    public IInitializationStrategy getInitializationStrategy() {
        boolean gastToPrimitiveComponentStrategy = true;
        if (gastToPrimitiveComponentStrategy) {
            logger.info((Object)"GAST to primitive component initialisation strategy.");
            return new GastToPrimitiveComponentInitializationStrategy();
        }
        logger.info((Object)"GAST classes component initialisation strategy.");
        logger.error((Object)"Currently does NOT WORK!.");
        return new NoGastClassToPrimitiveComponentInitializationStrategy();
    }

    @Override
    public IPostComponentDetectionStrategy getPostComponentDetectionStrategy() {
        boolean PostDetectionStrategyDummy = false;
        if (PostDetectionStrategyDummy) {
            return new DummyPostComponentDetectionStrategy();
        }
        return new DeleteInitialComponentCandidatesStrategy();
    }
}

