/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.detection;

import de.uka.ipd.sdq.workflow.ExecutionTimeLoggingProgressMonitor;
import eu.qimpress.qimpressgast.GASTBehaviour;
import eu.qimpress.samm.behaviour.OperationBehaviour;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.FileLevelSourceCodeLink;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.somox.analyzer.simplemodelanalyzer.SimpleAnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.detection.IPostComponentDetectionStrategy;
import org.somox.configuration.SoMoXConfiguration;

public class DeleteInitialComponentCandidatesStrategy
implements IPostComponentDetectionStrategy {
    private static Logger logger = Logger.getLogger(DeleteInitialComponentCandidatesStrategy.class);

    @Override
    public void postComponentDetection(SoMoXConfiguration somoxConfiguration, SimpleAnalysisResult analysisResult, IProgressMonitor progressMonitor) {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(progressMonitor, analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().size());
        subProgressMonitor.beginTask("Post component detection", -1);
        logger.trace((Object)"Post component detection");
        HashSet<ComponentType> componentsToDelete = new HashSet<ComponentType>();
        HashSet<ComponentImplementingClassesLink> componentLinksToDelete = new HashSet<ComponentImplementingClassesLink>();
        boolean lastCollectedForDeletion = false;
        for (ComponentImplementingClassesLink componentLinkToCheck : analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
            if (componentLinkToCheck.isInitialComponent()) {
                for (ComponentImplementingClassesLink innerComponentLink : analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
                    if (innerComponentLink == componentLinkToCheck || !innerComponentLink.getImplementingClasses().containsAll((Collection)componentLinkToCheck.getImplementingClasses())) continue;
                    logger.trace((Object)("Deleting initial component: " + componentLinkToCheck.getComponent().getName()));
                    componentLinksToDelete.add(componentLinkToCheck);
                    componentsToDelete.add(componentLinkToCheck.getComponent());
                    lastCollectedForDeletion = true;
                    break;
                }
                if (!lastCollectedForDeletion) {
                    componentLinkToCheck.setIsInitialComponent(false);
                    lastCollectedForDeletion = false;
                }
            }
            subProgressMonitor.worked(1);
        }
        this.cleanUpGastBehaviour(analysisResult, componentLinksToDelete);
        this.cleanUpSourceCodeDecorator(analysisResult, componentLinksToDelete);
        for (ComponentImplementingClassesLink compLink : componentLinksToDelete) {
            EcoreUtil.delete((EObject)compLink, (boolean)true);
        }
        for (ComponentType comp : componentsToDelete) {
            EcoreUtil.delete((EObject)comp, (boolean)true);
        }
        subProgressMonitor.done();
    }

    private void cleanUpSourceCodeDecorator(SimpleAnalysisResult analysisResult, Set<ComponentImplementingClassesLink> componentLinksToDelete) {
        HashSet<FileLevelSourceCodeLink> fileLevelSourceCodeLinksToDelete = new HashSet<FileLevelSourceCodeLink>();
        HashSet<FileLevelSourceCodeLink> methodLevelSourceCodeLinksToDelete = new HashSet<FileLevelSourceCodeLink>();
        for (ComponentImplementingClassesLink compLink : componentLinksToDelete) {
            for (FileLevelSourceCodeLink sourceLink : analysisResult.getSourceCodeDecoratorRepository().getFileLevelSourceCodeLink()) {
                if (!sourceLink.getComponentType().equals(compLink.getComponent())) continue;
                fileLevelSourceCodeLinksToDelete.add(sourceLink);
            }
            for (FileLevelSourceCodeLink sourceLink : analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink()) {
                if (sourceLink.getComponentType() == null || !sourceLink.getComponentType().equals(compLink.getComponent())) continue;
                methodLevelSourceCodeLinksToDelete.add(sourceLink);
            }
        }
        for (FileLevelSourceCodeLink sourceCodeLink : fileLevelSourceCodeLinksToDelete) {
            EcoreUtil.delete((EObject)sourceCodeLink, (boolean)true);
        }
        for (FileLevelSourceCodeLink sourceCodeLink : methodLevelSourceCodeLinksToDelete) {
            EcoreUtil.delete((EObject)sourceCodeLink, (boolean)true);
        }
    }

    private void cleanUpGastBehaviour(SimpleAnalysisResult analysisResult, Set<ComponentImplementingClassesLink> componentLinksToDelete) {
        HashSet<GASTBehaviour> behavioursToDelete = new HashSet<GASTBehaviour>();
        block0: for (GASTBehaviour gastBehaviour : analysisResult.getGastBehaviourRepository().getGastbehaviour()) {
            Operation operation = gastBehaviour.getGastbehaviourstub().getOperation();
            for (ComponentImplementingClassesLink compLink : componentLinksToDelete) {
                for (OperationBehaviour operationBehaviour : compLink.getComponent().getOperationBehaviour()) {
                    if (gastBehaviour.getGastbehaviourstub().eContainer() instanceof PrimitiveComponent) {
                        PrimitiveComponent compOfBehaviour = (PrimitiveComponent)gastBehaviour.getGastbehaviourstub().eContainer();
                        if (!operationBehaviour.getOperation().equals(operation) || !compOfBehaviour.equals(compLink.getComponent())) continue;
                        behavioursToDelete.add(gastBehaviour);
                        continue block0;
                    }
                    logger.warn((Object)"Parent of gast behaviour stub should be a primitive component.");
                }
            }
        }
        for (GASTBehaviour gastBehaviour : behavioursToDelete) {
            logger.trace((Object)("deleting gast behaviour in decorator: " + gastBehaviour.getGastbehaviourstub().getName() + " " + gastBehaviour));
            EcoreUtil.delete((EObject)gastBehaviour, (boolean)false);
        }
    }
}

