/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.InheritanceTypeAccess;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.core.Root;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorsInsideCompositeComponentStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.GASTBehaviourBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.OperationBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.util.InterfacePortBuilderHelper;
import org.somox.analyzer.simplemodelanalyzer.detection.ComponentInterfaceStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.IComponentInterfaceStrategy;
import org.somox.analyzer.simplemodelanalyzer.detection.util.AccessFilter;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.filter.EClassBasedFilter;

public class InterfaceBuilder
extends AbstractBuilder {
    private Map<GASTClass, Interface> alreadyCreatedInterfaces = new HashMap<GASTClass, Interface>();
    private static Logger logger = Logger.getLogger(InterfaceBuilder.class);
    private OperationBuilder operationBuilder = null;
    private GASTBehaviourBuilder behaviourBuilder = null;
    private ComponentAndTypeNaming naming = null;
    private IComponentInterfaceStrategy interfaceStrategy = null;
    public static final boolean PROVIDED_INTERFACE = true;

    public InterfaceBuilder(Root gastModel, SoMoXConfiguration configuration, AnalysisResult result) {
        super(gastModel, configuration, result);
        logger.debug((Object)"Interface builder initialised");
        this.operationBuilder = new OperationBuilder(gastModel, configuration, result);
        this.behaviourBuilder = new GASTBehaviourBuilder(gastModel, configuration, result);
        this.naming = new ComponentAndTypeNaming();
        this.interfaceStrategy = new ComponentInterfaceStrategy(result.getSourceCodeDecoratorRepository());
    }

    public boolean findAndAddRequiredInterfaces(ComponentImplementingClassesLink componentCandidate) {
        boolean addedARequiredInterface = false;
        EClassBasedFilter accessFilter = new EClassBasedFilter(new EClass[]{accessesPackage.eINSTANCE.getInheritanceTypeAccess(), accessesPackage.eINSTANCE.getSelfAccess()});
        LinkedList<GASTClass> filteredAccessedClasses = new LinkedList<GASTClass>();
        LinkedList<GASTClass> componentClasses = new LinkedList<GASTClass>();
        for (GASTClass clazz : componentCandidate.getImplementingClasses()) {
            filteredAccessedClasses.addAll(AccessFilter.filterAccessList((List<Access>)clazz.getAllAccesses(), (EClassBasedFilter<Access>)accessFilter));
            componentClasses.add(clazz);
        }
        filteredAccessedClasses.removeAll(componentClasses);
        for (GASTClass accessedClass : this.somoxConfiguration.getBlacklistFilter().filter(filteredAccessedClasses)) {
            Interface reqInterface;
            if (!this.interfaceStrategy.isComponentInterface(accessedClass) || this.doesComponentAlreadyRequireInterface(reqInterface = this.createInterface(null, accessedClass), componentCandidate.getComponent())) continue;
            this.createRequiredPort(componentCandidate.getComponent(), reqInterface);
            this.updateInterfacesInSourceCodeDecorator(componentCandidate, reqInterface, accessedClass, false);
            addedARequiredInterface = true;
        }
        if (!componentCandidate.isCompositeComponent()) {
            this.removeInterfaceSelfAccesses(componentCandidate);
        }
        return addedARequiredInterface;
    }

    public void addProvidedInterfaces(ComponentImplementingClassesLink componentCandidate) {
        if (componentCandidate.isCompositeComponent()) {
            throw new IllegalArgumentException("This method can only be called on primitive components");
        }
        for (GASTClass gastClass : componentCandidate.getImplementingClasses()) {
            for (GASTClass superType : this.somoxConfiguration.getBlacklistFilter().filter((Iterable)gastClass.getSuperTypes())) {
                this.createInterfaceForSupertype(componentCandidate, gastClass, superType);
            }
        }
        if (componentCandidate.getComponent().getProvided().isEmpty()) {
            this.assignPublicMethodsAsInterfaceForComponentsWithoutInterface(componentCandidate);
        }
    }

    private void createRequiredPort(ComponentType component, Interface reqInterface) {
        InterfacePort reqInterfacePort = StaticstructureFactory.eINSTANCE.createInterfacePort();
        reqInterfacePort.setName(this.naming.createRequiredPortName(reqInterface, component));
        reqInterfacePort.setInterfaceType(reqInterface);
        component.getRequired().add((Object)reqInterfacePort);
    }

    private InterfacePort createProvidedPort(Interface theInterface, ComponentType component) {
        InterfacePort provInterfacePort = StaticstructureFactory.eINSTANCE.createInterfacePort();
        provInterfacePort.setName(this.naming.createProvidedPortName(theInterface, component));
        provInterfacePort.setInterfaceType(theInterface);
        component.getProvided().add((Object)provInterfacePort);
        return provInterfacePort;
    }

    private boolean doesComponentAlreadyRequireInterface(Interface theInterface, ComponentType component) {
        for (InterfacePort port : component.getRequired()) {
            if (port.getInterfaceType() == null || !port.getInterfaceType().getId().equals(theInterface.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean componentProvidesInterface(Interface theInterface, ComponentType component) {
        for (InterfacePort port : component.getProvided()) {
            if (port.getInterfaceType() == null || !port.getInterfaceType().getId().equals(theInterface.getId())) continue;
            return true;
        }
        return false;
    }

    private void createInterfaceForSupertype(ComponentImplementingClassesLink componentCandidate, GASTClass gastClass, GASTClass superType) {
        for (GASTClass ownSuperType : this.somoxConfiguration.getBlacklistFilter().filter((Iterable)superType.getSuperTypes())) {
            this.createInterfaceForSupertype(componentCandidate, gastClass, ownSuperType);
        }
        if (this.interfaceStrategy.isComponentInterface(superType)) {
            logger.debug((Object)("Found interface " + superType.getQualifiedName() + " for component " + componentCandidate.getComponent().getName()));
            Interface providedInterface = this.createInterface(gastClass, superType);
            if (!this.componentProvidesInterface(providedInterface, componentCandidate.getComponent())) {
                this.createProvidedPortAndBehaviour(componentCandidate, providedInterface, superType);
            }
        }
    }

    private void createProvidedPortAndBehaviour(ComponentImplementingClassesLink componentCandidate, Interface providedInterface, GASTClass gastClass) {
        InterfacePort providedPort = this.createProvidedPort(providedInterface, componentCandidate.getComponent());
        this.updateInterfacesInSourceCodeDecorator(componentCandidate, providedInterface, gastClass, true);
        if (!componentCandidate.isCompositeComponent()) {
            this.behaviourBuilder.addGASTBehaviourToPrimitiveComponent((PrimitiveComponent)componentCandidate.getComponent(), providedPort);
        }
    }

    private void assignPublicMethodsAsInterfaceForComponentsWithoutInterface(ComponentImplementingClassesLink componentCandidate) {
        logger.debug((Object)"Assigning public methods as interfaces");
        EList gastClasses = componentCandidate.getImplementingClasses();
        if (!gastClasses.isEmpty()) {
            for (GASTClass gastClass : gastClasses) {
                Interface compInterface = this.createInterfaceBasedOnPublicMethods(gastClass);
                if (compInterface != null) {
                    this.createProvidedPortAndBehaviour(componentCandidate, compInterface, gastClass);
                    continue;
                }
                logger.warn((Object)"Failed to create interface by using public methods for class without real interfaces");
            }
        } else {
            logger.warn((Object)("No gast classes found for component: " + componentCandidate.getComponent().getName() + " id: " + componentCandidate.getComponent().getId()));
        }
    }

    private Interface createInterfaceBasedOnPublicMethods(GASTClass gastClass) {
        if (this.interfaceStrategy.isComponentInterface(gastClass)) {
            logger.info((Object)(String.valueOf(gastClass.getQualifiedName()) + " used as interface but is a pseudo-interface."));
        }
        if (this.alreadyCreatedInterfaces.containsKey(gastClass)) {
            return this.alreadyCreatedInterfaces.get(gastClass);
        }
        Interface compInterface = StaticstructureFactory.eINSTANCE.createInterface();
        compInterface.setName(this.naming.createInterfaceNameForClass(gastClass));
        compInterface.setDocumentation(gastClass.getSimpleName());
        this.operationBuilder.createOperations(gastClass, gastClass, compInterface);
        this.alreadyCreatedInterfaces.put(gastClass, compInterface);
        this.analysisResult.getInternalArchitectureModel().getInterface().add((Object)compInterface);
        return compInterface;
    }

    private Interface createInterface(GASTClass implementingClass, GASTClass interfaceClass) {
        Interface result = this.getExistingInterface(interfaceClass);
        if (result == null) {
            result = StaticstructureFactory.eINSTANCE.createInterface();
            for (InheritanceTypeAccess inheritanceTypeAccess : interfaceClass.getInheritanceTypeAccesses()) {
                GASTClass superType = (GASTClass)inheritanceTypeAccess.getTargetType();
                if (!this.somoxConfiguration.getBlacklistFilter().passes(superType) || !this.interfaceStrategy.isComponentInterface(superType)) continue;
                Interface parentInterface = this.createInterface(implementingClass, superType);
                result.getInheritance().add((Object)parentInterface);
            }
            result.setName(this.naming.createInterfaceName(interfaceClass));
            result.setDocumentation(interfaceClass.getQualifiedName());
            this.operationBuilder.createOperations(implementingClass, interfaceClass, result);
            this.alreadyCreatedInterfaces.put(interfaceClass, result);
            this.analysisResult.getInternalArchitectureModel().getInterface().add((Object)result);
        }
        return result;
    }

    private Interface getExistingInterface(GASTClass gastClass) {
        Interface returnInterface = null;
        if (this.alreadyCreatedInterfaces.containsKey(gastClass)) {
            returnInterface = this.alreadyCreatedInterfaces.get(gastClass);
        }
        return returnInterface;
    }

    private void updateInterfacesInSourceCodeDecorator(ComponentImplementingClassesLink component, Interface interf, GASTClass gastClass, boolean isProvidedInterface) {
        InterfaceSourceCodeLink interfaceLink = SourceCodeDecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
        if (gastClass != null) {
            interfaceLink.setGastClass(gastClass);
        }
        interfaceLink.setInterface(interf);
        this.analysisResult.getSourceCodeDecoratorRepository().getInterfaceSourceCodeLink().add((Object)interfaceLink);
        if (isProvidedInterface) {
            component.getProvidedInterfaces().add((Object)interfaceLink);
        } else {
            component.getRequiredInterfaces().add((Object)interfaceLink);
        }
    }

    public void updateRequiredInterfacesOfExistingPrimitiveComponents() {
        boolean addedANewInterface = false;
        for (ComponentImplementingClassesLink compLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
            if (compLink.isCompositeComponent()) continue;
            addedANewInterface = this.findAndAddRequiredInterfaces(compLink);
            addedANewInterface = true;
        }
        AssemblyConnectorsInsideCompositeComponentStrategy assemblyConnectorStrategy = new AssemblyConnectorsInsideCompositeComponentStrategy();
        if (addedANewInterface) {
            for (ComponentImplementingClassesLink compLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
                if (!compLink.isCompositeComponent()) continue;
                CompositeStructure composite = (CompositeStructure)compLink.getComponent();
                assemblyConnectorStrategy.buildAssemblyConnectors(composite, (List<ComponentImplementingClassesLink>)compLink.getSubComponents());
            }
        }
    }

    public void reverseEngineerRemainingInterfacesAsFreeFloatingInterfaces(AnalysisResult analysisResult, Root gastModel) {
        analysisResult.getSourceCodeDecoratorRepository();
        for (GASTClass currentClass : gastModel.getAllNormalClasses()) {
            if (!this.interfaceStrategy.isComponentInterface(currentClass) || this.alreadyCreatedInterfaces.containsKey(currentClass)) continue;
            Interface newInterface = this.createInterface(currentClass, currentClass);
            analysisResult.getInternalArchitectureModel().getInterface().add((Object)newInterface);
            InterfaceSourceCodeLink ifLink = SourceCodeDecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
            ifLink.setGastClass(currentClass);
            analysisResult.getSourceCodeDecoratorRepository().getInterfaceSourceCodeLink().add((Object)ifLink);
        }
    }

    public void removeInterfaceSelfAccesses(ComponentImplementingClassesLink primitiveComponent) {
        List<InterfaceSourceCodeInterfacePortTuple> requiredIfToRemove = this.identifyComponentInterfaceSelfAccess(primitiveComponent);
        for (InterfaceSourceCodeInterfacePortTuple currentIfTupleToRemove : requiredIfToRemove) {
            logger.trace((Object)("removing self-access component interface " + currentIfTupleToRemove.interfaceSourceCodeLink.getInterface().getName() + " of component " + primitiveComponent.getComponent().getName()));
            primitiveComponent.getComponent().getRequired().remove((Object)currentIfTupleToRemove.interfacePort);
            EcoreUtil.delete((EObject)currentIfTupleToRemove.interfacePort);
            primitiveComponent.getRequiredInterfaces().remove((Object)currentIfTupleToRemove.interfaceSourceCodeLink);
            EcoreUtil.delete((EObject)currentIfTupleToRemove.interfaceSourceCodeLink);
        }
    }

    private List<InterfaceSourceCodeInterfacePortTuple> identifyComponentInterfaceSelfAccess(ComponentImplementingClassesLink primitiveComponent) {
        ArrayList<InterfaceSourceCodeInterfacePortTuple> requiredIfToRemove = new ArrayList<InterfaceSourceCodeInterfacePortTuple>();
        for (InterfaceSourceCodeLink providedInterfaceLink : primitiveComponent.getProvidedInterfaces()) {
            for (InterfaceSourceCodeLink requiredInterfaceLink : primitiveComponent.getRequiredInterfaces()) {
                if (!providedInterfaceLink.getInterface().equals(requiredInterfaceLink.getInterface())) continue;
                InterfaceSourceCodeInterfacePortTuple ifToRemoveTuple = new InterfaceSourceCodeInterfacePortTuple();
                ifToRemoveTuple.interfacePort = InterfacePortBuilderHelper.getInterfacePort(primitiveComponent, requiredInterfaceLink, false);
                ifToRemoveTuple.interfaceSourceCodeLink = requiredInterfaceLink;
                requiredIfToRemove.add(ifToRemoveTuple);
            }
        }
        return requiredIfToRemove;
    }

    private class InterfaceSourceCodeInterfacePortTuple {
        public InterfaceSourceCodeLink interfaceSourceCodeLink;
        public InterfacePort interfacePort;

        private InterfaceSourceCodeInterfacePortTuple() {
        }
    }
}

