/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.FileLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.Graph;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorDeFactoStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorsInsideCompositeComponentStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.IAssemblyConnectorStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.IInterfacePortBuilderStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.InterfaceBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.NonDuplicatingInterfacePortBuilder;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.ClusteringRelation;

public class ComponentBuilder
extends AbstractBuilder {
    private ComponentAndTypeNaming componentNamingStrategy = null;
    private InterfaceBuilder interfaceBuilder = null;
    private IAssemblyConnectorStrategy assemblyConnectorDeFactoBuilder = null;
    private IAssemblyConnectorStrategy assemblyConnectorInnerBuilder = null;
    private IInterfacePortBuilderStrategy providedInterfaceBuilder = null;
    private IInterfacePortBuilderStrategy requiredInterfaceBuilder = null;
    private static Logger logger = Logger.getLogger(ComponentBuilder.class);

    public ComponentBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
        logger.debug((Object)"Initialising SAMM model builder");
        this.componentNamingStrategy = new ComponentAndTypeNaming();
        this.interfaceBuilder = new InterfaceBuilder(gastModel, somoxConfiguration, analysisResult);
        AssemblyConnectorBuilder connectorBuilder = new AssemblyConnectorBuilder(gastModel, somoxConfiguration, analysisResult);
        this.assemblyConnectorDeFactoBuilder = new AssemblyConnectorDeFactoStrategy(connectorBuilder);
        this.assemblyConnectorInnerBuilder = new AssemblyConnectorsInsideCompositeComponentStrategy();
        this.providedInterfaceBuilder = new NonDuplicatingInterfacePortBuilder(gastModel, somoxConfiguration, analysisResult, true, this.componentNamingStrategy);
        this.requiredInterfaceBuilder = new NonDuplicatingInterfacePortBuilder(gastModel, somoxConfiguration, analysisResult, false, this.componentNamingStrategy);
        if (somoxConfiguration.isReverseEngineerInterfacesNotAssignedToComponent()) {
            this.interfaceBuilder.reverseEngineerRemainingInterfacesAsFreeFloatingInterfaces(analysisResult, gastModel);
        }
    }

    public ComponentImplementingClassesLink createCompositeComponent(Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        ComponentImplementingClassesLink result = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        CompositeComponent newComponentType = StaticstructureFactory.eINSTANCE.createCompositeComponent();
        String componentName = this.componentNamingStrategy.createCompositeComponentName(compositeComponentSubgraph.vertexSet());
        logger.info((Object)("Creating composite component with name: " + componentName));
        newComponentType.setName(componentName);
        newComponentType.setDocumentation(this.componentNamingStrategy.createCompositeComponentName(compositeComponentSubgraph.vertexSet(), false));
        this.createSubComponentInstances(compositeComponentSubgraph.vertexSet(), (CompositeStructure)newComponentType);
        result.setComponent((ComponentType)newComponentType);
        result.getSubComponents().addAll((Collection)compositeComponentSubgraph.vertexSet());
        this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().add((Object)result);
        this.analysisResult.getInternalArchitectureModel().getComponenttype().add((Object)newComponentType);
        this.assemblyConnectorDeFactoBuilder.buildAssemblyConnectors(result, compositeComponentSubgraph);
        this.assemblyConnectorInnerBuilder.buildAssemblyConnectors(result, compositeComponentSubgraph);
        this.providedInterfaceBuilder.buildInterfacePort(result);
        this.requiredInterfaceBuilder.buildInterfacePort(result);
        return result;
    }

    public List<SubcomponentInstance> createSubComponentInstances(Set<ComponentImplementingClassesLink> subComponents, CompositeStructure newComponentType) {
        ArrayList<SubcomponentInstance> subComponentInstance = new ArrayList<SubcomponentInstance>(subComponents.size());
        for (ComponentImplementingClassesLink innerComponent : subComponents) {
            SubcomponentInstance subcomponentInstance = StaticstructureFactory.eINSTANCE.createSubcomponentInstance();
            subcomponentInstance.setRealizedBy(innerComponent.getComponent());
            subcomponentInstance.setName(this.componentNamingStrategy.createComponentInstanceName(innerComponent.getComponent()));
            newComponentType.getSubcomponents().add((Object)subcomponentInstance);
            innerComponent.setIsInitialComponent(false);
        }
        return subComponentInstance;
    }

    public ComponentImplementingClassesLink createMergedComponent(Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        ComponentImplementingClassesLink compositeComponentLink = this.findExistingComposite(compositeComponentSubgraph.vertexSet());
        if (compositeComponentLink != null) {
            logger.trace((Object)"creating merged component CC + children");
            return this.addAsChildPrimitiveComponentToExistingComposite(compositeComponentSubgraph, compositeComponentLink);
        }
        logger.trace((Object)"creating merged single component");
        return this.createSinglePrimitiveComponent(compositeComponentSubgraph);
    }

    public ComponentImplementingClassesLink createPrimitiveComponentFromGASTClass(GASTClass gastClass) {
        ArrayList<GASTClass> singleClassList = new ArrayList<GASTClass>();
        singleClassList.add(gastClass);
        return this.createSinglePrimitiveComponentFromGASTClasses(singleClassList);
    }

    public ComponentImplementingClassesLink createSinglePrimitiveComponentFromGASTClasses(List<GASTClass> gastClasses) {
        ComponentImplementingClassesLink newPrimitiveComponent = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        return this.createSinglePrimitiveComponentFromGASTClasses(gastClasses, newPrimitiveComponent);
    }

    public ComponentImplementingClassesLink createSinglePrimitiveComponentFromGASTClasses(List<GASTClass> gastClasses, ComponentImplementingClassesLink primitiveComponent) {
        String componentName = this.componentNamingStrategy.createSimpleComponentName(gastClasses, true);
        logger.info((Object)("Creating primitive component " + componentName));
        this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().add((Object)primitiveComponent);
        PrimitiveComponent newComponentType = StaticstructureFactory.eINSTANCE.createPrimitiveComponent();
        newComponentType.setName(componentName);
        newComponentType.setDocumentation(this.componentNamingStrategy.createSimpleComponentName(gastClasses, false));
        this.analysisResult.getInternalArchitectureModel().getComponenttype().add((Object)newComponentType);
        primitiveComponent.setComponent((ComponentType)newComponentType);
        for (GASTClass currentGASTclass : gastClasses) {
            primitiveComponent.getImplementingClasses().addAll(this.getInnerClasses(currentGASTclass, (ComponentType)newComponentType));
        }
        this.interfaceBuilder.findAndAddRequiredInterfaces(primitiveComponent);
        this.interfaceBuilder.addProvidedInterfaces(primitiveComponent);
        this.interfaceBuilder.removeInterfaceSelfAccesses(primitiveComponent);
        return primitiveComponent;
    }

    public ComponentImplementingClassesLink createComponentLinkFromGASTClass(GASTClass gastClass) {
        ComponentImplementingClassesLink newPrimitiveComponent = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().add((Object)newPrimitiveComponent);
        newPrimitiveComponent.getImplementingClasses().addAll(this.getInnerClasses(gastClass));
        return newPrimitiveComponent;
    }

    private ComponentImplementingClassesLink createSinglePrimitiveComponent(Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        logger.trace((Object)"creating single primitive component (merge)");
        BasicEList classesOfPrimitiveComponent = new BasicEList();
        for (ComponentImplementingClassesLink currentComponent : compositeComponentSubgraph.vertexSet()) {
            assert (currentComponent.isInitialComponent());
            classesOfPrimitiveComponent.addAll((Collection)currentComponent.getImplementingClasses());
        }
        ComponentImplementingClassesLink result = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        result = this.createSinglePrimitiveComponentFromGASTClasses((List<GASTClass>)classesOfPrimitiveComponent);
        return result;
    }

    private ComponentImplementingClassesLink addAsChildPrimitiveComponentToExistingComposite(Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph, ComponentImplementingClassesLink compositeComponentLink) {
        for (ComponentImplementingClassesLink innerComponent : compositeComponentSubgraph.vertexSet()) {
            if (!innerComponent.isInitialComponent()) continue;
            ComponentImplementingClassesLink newInnerPrimitiveComponent = this.createSinglePrimitiveComponentFromGASTClasses((List<GASTClass>)innerComponent.getImplementingClasses());
            SubcomponentInstance subcomponentInstance = StaticstructureFactory.eINSTANCE.createSubcomponentInstance();
            subcomponentInstance.setRealizedBy(newInnerPrimitiveComponent.getComponent());
            subcomponentInstance.setName(this.componentNamingStrategy.createComponentInstanceName(newInnerPrimitiveComponent.getComponent()));
            ((CompositeComponent)compositeComponentLink.getComponent()).getSubcomponents().add((Object)subcomponentInstance);
            compositeComponentLink.getSubComponents().add((Object)newInnerPrimitiveComponent);
        }
        this.providedInterfaceBuilder.buildInterfacePort(compositeComponentLink);
        this.requiredInterfaceBuilder.buildInterfacePort(compositeComponentLink);
        this.assemblyConnectorDeFactoBuilder.buildAssemblyConnectors(compositeComponentLink, compositeComponentSubgraph);
        this.assemblyConnectorInnerBuilder.buildAssemblyConnectors(compositeComponentLink, compositeComponentSubgraph);
        return compositeComponentLink;
    }

    private ComponentImplementingClassesLink findExistingComposite(Set<ComponentImplementingClassesLink> componentLinks) {
        assert (this.assertOnlyASingleComposite(componentLinks));
        for (ComponentImplementingClassesLink innerComponent : componentLinks) {
            if (!innerComponent.isCompositeComponent()) continue;
            return innerComponent;
        }
        return null;
    }

    private boolean assertOnlyASingleComposite(Set<ComponentImplementingClassesLink> componentLinks) {
        int compositeCount = 0;
        for (ComponentImplementingClassesLink innerComponent : componentLinks) {
            if (!(innerComponent instanceof CompositeComponent)) continue;
            ++compositeCount;
        }
        return compositeCount <= 1;
    }

    private Set<GASTClass> getInnerClasses(GASTClass element, ComponentType newComponentType) {
        HashSet<GASTClass> currentList = new HashSet<GASTClass>();
        currentList.add(element);
        this.storeFileLocationInSourceCodeDecorator(element, newComponentType);
        EList innerClasses = element.getInnerClasses();
        if (innerClasses != null) {
            currentList.addAll((Collection<GASTClass>)innerClasses);
        }
        for (GASTClass innerClass : innerClasses) {
            currentList.addAll(this.getInnerClasses(innerClass, newComponentType));
        }
        return currentList;
    }

    private Set<GASTClass> getInnerClasses(GASTClass element) {
        HashSet<GASTClass> currentList = new HashSet<GASTClass>();
        currentList.add(element);
        EList innerClasses = element.getInnerClasses();
        if (innerClasses != null) {
            currentList.addAll((Collection<GASTClass>)innerClasses);
        }
        for (GASTClass innerClass : innerClasses) {
            currentList.addAll(this.getInnerClasses(innerClass));
        }
        return currentList;
    }

    private void storeFileLocationInSourceCodeDecorator(GASTClass gastClass, ComponentType newComponent) {
        FileLevelSourceCodeLink link = SourceCodeDecoratorFactory.eINSTANCE.createFileLevelSourceCodeLink();
        link.setComponentType(newComponent);
        if (gastClass.getPosition() != null && gastClass.getPosition().getSourceFile() != null) {
            link.setFile(gastClass.getPosition().getSourceFile());
        }
        this.analysisResult.getSourceCodeDecoratorRepository().getFileLevelSourceCodeLink().add((Object)link);
    }

    public void updateRequiredInterfacesOfExistingPrimitiveComponents() {
        this.interfaceBuilder.updateRequiredInterfacesOfExistingPrimitiveComponents();
    }

    public InterfaceBuilder getInterfaceBuilder() {
        return this.interfaceBuilder;
    }

    public ComponentAndTypeNaming getComponentAndTypeNamingStrategy() {
        return this.componentNamingStrategy;
    }

    public IAssemblyConnectorStrategy getInsideCompositeComponentAssemblyConnectorStrategy() {
        return this.assemblyConnectorInnerBuilder;
    }
}

