/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer;

import de.fzi.gast.core.Root;
import de.fzi.gast.helpers.GASTReader;
import de.uka.ipd.sdq.workflow.ExecutionTimeLoggingProgressMonitor;
import eu.qimpress.qimpressgast.GASTBehaviourRepository;
import eu.qimpress.qimpressgast.qimpressgastFactory;
import eu.qimpress.samm.qosannotation.QosAnnotations;
import eu.qimpress.samm.qosannotation.QosannotationFactory;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorFactory;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.ModelAnalyzer;
import org.somox.analyzer.ModelAnalyzerException;
import org.somox.analyzer.simplemodelanalyzer.SimpleAnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.SammSystemBuilder;
import org.somox.analyzer.simplemodelanalyzer.detection.util.ComponentPrinter;
import org.somox.analyzer.simplemodelanalyzer.factories.BasicSoMoXStrategiesFactory;
import org.somox.analyzer.simplemodelanalyzer.factories.ISoMoXStrategiesFactory;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.extractor.ExtractionResult;

public class SimpleModelAnalyzer
implements ModelAnalyzer {
    private static Logger logger = Logger.getLogger(SimpleModelAnalyzer.class);
    private ModelAnalyzer.Status status = ModelAnalyzer.Status.READY;

    public void init() {
    }

    public AnalysisResult analyze(SoMoXConfiguration somoxConfiguration, Repository internalArchitectureModel, HashMap<String, ExtractionResult> extractionResultMap, IProgressMonitor progressMonitor) throws ModelAnalyzerException {
        URI fileURI;
        this.status = ModelAnalyzer.Status.RUNNING;
        logger.info((Object)("SISSy Analyzer started with\n SOMOX Configuration: " + somoxConfiguration + "\n internalArchitectureModel " + internalArchitectureModel + "\n extractionResultMap " + extractionResultMap));
        SimpleAnalysisResult analysisResult = null;
        String platformPath = somoxConfiguration.getFileLocations().getAnalyserInputFile();
        if (platformPath != null && (fileURI = URI.createPlatformResourceURI((String)platformPath, (boolean)true)).fileExtension().toLowerCase().equals("gast")) {
            GASTReader modelReader;
            try {
                modelReader = new GASTReader();
                modelReader.loadFile(fileURI);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to load GAST Model", (Throwable)e);
                throw new ModelAnalyzerException("Failed to load GAST model", (Exception)e);
            }
            Root root = modelReader.getRoot();
            analysisResult = this.analyzeGASTModel(root, internalArchitectureModel, somoxConfiguration, progressMonitor);
        }
        this.status = ModelAnalyzer.Status.FINISHED;
        return analysisResult;
    }

    private SimpleAnalysisResult analyzeGASTModel(Root gastModel, Repository internalArchitectureModel, SoMoXConfiguration somoxConfiguration, IProgressMonitor progressMonitor) throws ModelAnalyzerException {
        SimpleAnalysisResult analysisResult = this.initializeAnalysisResult(internalArchitectureModel);
        analysisResult.setResultStatus(AnalysisResult.ResultStatus.FAILED);
        ComponentBuilder sammComponentBuilder = new ComponentBuilder(gastModel, somoxConfiguration, analysisResult);
        BasicSoMoXStrategiesFactory strategiesFactory = new BasicSoMoXStrategiesFactory(gastModel, somoxConfiguration);
        List<ComponentImplementingClassesLink> initialComponents = this.detectInitialComponentCandidates(gastModel, somoxConfiguration, sammComponentBuilder, strategiesFactory, progressMonitor);
        this.clusterComponents(initialComponents, somoxConfiguration, sammComponentBuilder, strategiesFactory, progressMonitor);
        this.postComponentDetection(somoxConfiguration, analysisResult, strategiesFactory, progressMonitor);
        SammSystemBuilder sammSystemBuilder = new SammSystemBuilder(gastModel, somoxConfiguration, analysisResult, sammComponentBuilder);
        sammSystemBuilder.buildServiceArchitectureModel();
        analysisResult.setResultStatus(AnalysisResult.ResultStatus.SUCCESS);
        return analysisResult;
    }

    private void postComponentDetection(SoMoXConfiguration somoxConfiguration, SimpleAnalysisResult analysisResult, ISoMoXStrategiesFactory strategiesFactory, IProgressMonitor progressMonitor) {
        strategiesFactory.getPostComponentDetectionStrategy().postComponentDetection(somoxConfiguration, analysisResult, progressMonitor);
    }

    private void clusterComponents(List<ComponentImplementingClassesLink> initialComponentCandidates, SoMoXConfiguration somoxConfiguration, ComponentBuilder sammBuilder, ISoMoXStrategiesFactory strategiesFactory, IProgressMonitor progressMonitor) throws ModelAnalyzerException {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(progressMonitor, 0);
        subProgressMonitor.beginTask("Cluster components", -1);
        List<ComponentImplementingClassesLink> componentsFound = strategiesFactory.getDetectionStrategy(initialComponentCandidates).startDetection(sammBuilder, somoxConfiguration, progressMonitor, initialComponentCandidates);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Printing detected components");
            ComponentPrinter.printComponents(componentsFound, logger);
        }
        subProgressMonitor.done();
    }

    private List<ComponentImplementingClassesLink> detectInitialComponentCandidates(Root gastModel, SoMoXConfiguration somoxConfiguration, ComponentBuilder sammBuilder, ISoMoXStrategiesFactory strategiesFactory, IProgressMonitor progressMonitor) {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(progressMonitor, 0);
        subProgressMonitor.beginTask("Detecting primitive components", -1);
        List<ComponentImplementingClassesLink> components = strategiesFactory.getInitializationStrategy().createInitialComponentCandidates(gastModel, somoxConfiguration, sammBuilder);
        logger.debug((Object)("Finished detection of primitive components. Found " + components.size() + " candidates"));
        subProgressMonitor.done();
        return components;
    }

    private SimpleAnalysisResult initializeAnalysisResult(Repository internalArchitectureModel) {
        SimpleAnalysisResult analysisResult = new SimpleAnalysisResult(this);
        SourceCodeDecoratorRepository sourceCodeDecoratorRepository = SourceCodeDecoratorFactory.eINSTANCE.createSourceCodeDecoratorRepository();
        GASTBehaviourRepository gastBehaviourRepository = qimpressgastFactory.eINSTANCE.createGASTBehaviourRepository();
        ServiceArchitectureModel serviceArchitectureModel = StaticstructureFactory.eINSTANCE.createServiceArchitectureModel();
        QosAnnotations qosAnnotationModel = QosannotationFactory.eINSTANCE.createQosAnnotations();
        analysisResult.setInternalArchitectureModel(internalArchitectureModel);
        analysisResult.setGastBehaviourRepository(gastBehaviourRepository);
        analysisResult.setSourceCodeDecoratorRepository(sourceCodeDecoratorRepository);
        analysisResult.setServiceArchitectureModel(serviceArchitectureModel);
        analysisResult.setQosAnnotationModel(qosAnnotationModel);
        return analysisResult;
    }

    public ModelAnalyzer.Status getStatus() {
        return this.status;
    }
}

