/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.transformations.common.jobs;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.transformations.common.jobs.LoadSAMMIntoBlackboardJob;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class LoadSAMMAlternativeJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger logger = Logger.getLogger(LoadSAMMIntoBlackboardJob.class);
    private MDSDBlackboard blackboard;
    private IQAlternative alternative;
    public static final String[] SAMM_EXTENSIONS = new String[]{"samm_repository", "samm_servicearchitecturemodel", "samm_qosannotation", "samm_seff", "samm_hardware", "samm_targetenvironment", "samm_usagemodel"};

    public LoadSAMMAlternativeJob(IQAlternative alternative) {
        this.alternative = alternative;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition sammPartition = (ResourceSetPartition)this.blackboard.getPartition("eu.qimpress.samm.partition");
        String alternativeID = "";
        if (this.alternative.getInfo() != null) {
            alternativeID = this.alternative.getInfo().getId();
        }
        logger.info((Object)("Loading SAM Model Files for alternative " + alternativeID));
        IQModel[] elements = this.alternative.getModels();
        IQModel[] inputElements = new IQModel[SAMM_EXTENSIONS.length];
        int j = 0;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQModel element = objectArray[n2];
            if (LoadSAMMAlternativeJob.isNecessaryModelForTransformation(element)) {
                inputElements[j] = element;
                ++j;
            }
            ++n2;
        }
        objectArray = SAMM_EXTENSIONS;
        n = SAMM_EXTENSIONS.length;
        n2 = 0;
        while (n2 < n) {
            IQModel extension = objectArray[n2];
            URI location = LoadSAMMAlternativeJob.getResourceURI(inputElements, (String)extension);
            logger.debug((Object)("Loading SAM model file " + location));
            sammPartition.loadModel(location);
            ++n2;
        }
        sammPartition.resolveAllProxies();
    }

    public static boolean isNecessaryModelForTransformation(IQModel element) {
        String[] stringArray = SAMM_EXTENSIONS;
        int n = SAMM_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(element.getType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getName() {
        return "Loading model files of SAM Alternative";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public static URI getResourceURI(IQModel[] elements, String fileextension) throws JobFailedException {
        IQModel[] iQModelArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQModel elem = iQModelArray[n2];
            URI location = LoadSAMMAlternativeJob.getURIForQIElement((IQElement)elem);
            if (location != null && location.fileExtension().equals(fileextension)) {
                return location;
            }
            ++n2;
        }
        logger.error((Object)("Unable to find file with extension " + fileextension + ". " + "Check SAM alternative for completeness."));
        throw new JobFailedException("Unable to find file with extension " + fileextension + ". " + "Check SAM alternative for completeness.");
    }

    public static URI getURIForQIElement(IQElement elem) {
        URI location = null;
        if (elem != null) {
            String pathName = elem.getCorrespondingResource().getFullPath().toString();
            location = URI.createPlatformResourceURI((String)pathName, (boolean)false);
        } else {
            logger.warn((Object)"Could not load a model. The location was empty or incorrect.");
        }
        return location;
    }
}

