/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.samm.visualisation.test;

import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.samm.visualisation.RepositoryVizNode;
import eu.qimpress.samm.visualisation.RepositoryVizSammSwitch;
import org.eclipse.emf.ecore.EObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JUnitTest {
    private StaticstructureFactory myFac;
    private PrimitiveComponent pc1;
    private PrimitiveComponent pc2;
    private PrimitiveComponent pc3;
    private CompositeComponent cc1;
    private CompositeComponent cc2;
    private SubcomponentInstance sub1CC1;
    private SubcomponentInstance sub2CC1;
    private SubcomponentInstance sub1CC2;
    private SubcomponentInstance sub2CC2;
    private Repository myRep;
    private RepositoryVizNode root;
    private RepositoryVizNode nodeCC1;
    private RepositoryVizSammSwitch testSwitch;

    @Before
    public void init() {
        this.myFac = StaticstructureFactory.eINSTANCE;
        this.myRep = this.myFac.createRepository();
        this.pc1 = this.myFac.createPrimitiveComponent();
        this.pc1.setName("PrimitiveComponent1");
        this.pc2 = this.myFac.createPrimitiveComponent();
        this.pc2.setName("PrimitiveComponent2");
        this.pc3 = this.myFac.createPrimitiveComponent();
        this.pc3.setName("PrimitiveComponent3");
        this.cc1 = this.myFac.createCompositeComponent();
        this.cc1.setName("CompositeComponent1");
        this.sub1CC1 = this.myFac.createSubcomponentInstance();
        this.sub1CC1.setRealizedBy((ComponentType)this.pc1);
        this.cc1.getSubcomponents().add((Object)this.sub1CC1);
        this.sub2CC1 = this.myFac.createSubcomponentInstance();
        this.sub2CC1.setRealizedBy((ComponentType)this.pc2);
        this.cc1.getSubcomponents().add((Object)this.sub2CC1);
        this.cc2 = this.myFac.createCompositeComponent();
        this.cc2.setName("CompositeComponent2");
        this.sub1CC2 = this.myFac.createSubcomponentInstance();
        this.sub1CC2.setRealizedBy((ComponentType)this.pc3);
        this.cc2.getSubcomponents().add((Object)this.sub1CC2);
        this.sub2CC2 = this.myFac.createSubcomponentInstance();
        this.sub2CC2.setRealizedBy((ComponentType)this.cc1);
        this.cc2.getSubcomponents().add((Object)this.sub2CC2);
        this.myRep.getComponenttype().add((Object)this.cc2);
        this.nodeCC1 = new RepositoryVizNode("CompositeComponent1");
        this.nodeCC1.addChild(new RepositoryVizNode("PrimitiveComponent1"));
        this.nodeCC1.addChild(new RepositoryVizNode("PrimitiveComponent2"));
        this.root = new RepositoryVizNode("CompositeComponent2");
        this.root.addChild(new RepositoryVizNode("PrimitiveComponent3"));
        this.root.addChild(this.nodeCC1);
        this.testSwitch = new RepositoryVizSammSwitch(null, null);
    }

    @Test
    public void RootCalculation() {
        this.testSwitch.getDepth(this.cc2);
        Assert.assertEquals((double)2.0, (double)this.testSwitch.getDepth(this.cc2), (double)0.0);
    }

    @Test
    public void CompositeNodeGeneration() {
        RepositoryVizNode result = (RepositoryVizNode)this.testSwitch.doSwitch((EObject)this.myRep);
        System.out.println(result.getName());
        System.out.println(this.root.getName());
        Assert.assertTrue((boolean)result.equals(this.root));
    }
}

