/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.ui.launch;

import de.fzi.sissy.gastimporter.GASTImporterConfiguration;
import de.fzi.sissy.main.configurations.SISSyConfiguration;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import org.somox.ui.runconfig.ModelAnalyzerConfiguration;

public class ReverseEngineeringConfiguration
extends AbstractWorkflowBasedRunConfiguration {
    private SISSyConfiguration sissyConfiguration = null;
    private GASTImporterConfiguration sissy2gastConfiguration = null;
    private ModelAnalyzerConfiguration somoxConfiguration = null;
    private String workingDirectoryPath = null;
    private String gast2tbpEnabled = null;

    public ReverseEngineeringConfiguration(SISSyConfiguration sissyConfiguration, GASTImporterConfiguration sissy2gastConfiguration, ModelAnalyzerConfiguration somoxConfiguration, String gast2tbpConfig) {
        this.sissyConfiguration = sissyConfiguration;
        this.sissy2gastConfiguration = sissy2gastConfiguration;
        this.somoxConfiguration = somoxConfiguration;
        this.gast2tbpEnabled = gast2tbpConfig;
    }

    public SISSyConfiguration getSissyConfiguration() {
        return this.sissyConfiguration;
    }

    public GASTImporterConfiguration getSissy2GASTConfiguration() {
        return this.sissy2gastConfiguration;
    }

    public ModelAnalyzerConfiguration getSomoxConfiguration() {
        return this.somoxConfiguration;
    }

    public boolean getGast2TbpConfig() {
        return this.gast2tbpEnabled.equals("true");
    }

    public String getErrorMessage() {
        String errorMessage = "";
        if (this.getSissyConfiguration() != null && this.getSissyConfiguration().getErrorMessage() != null) {
            errorMessage = String.valueOf(errorMessage) + this.getSissyConfiguration().getErrorMessage();
        }
        if (this.getSissy2GASTConfiguration() != null && this.getSissy2GASTConfiguration().getErrorMessage() != null) {
            errorMessage = String.valueOf(errorMessage) + this.getSissy2GASTConfiguration().getErrorMessage();
        }
        if (this.getSomoxConfiguration() != null && this.getSomoxConfiguration().getErrorMessage() != null) {
            errorMessage = String.valueOf(errorMessage) + this.getSomoxConfiguration().getErrorMessage();
        }
        return errorMessage.length() == 0 ? null : errorMessage;
    }

    public void setDefaults() {
        this.sissyConfiguration.setDefaults();
        this.sissy2gastConfiguration.setDefaults();
        this.somoxConfiguration.setDefaults();
        this.gast2tbpEnabled = "true";
    }

    public void setWorkingDirectory(String dir) {
        this.workingDirectoryPath = dir;
    }

    public String getWorkingDirectory() {
        return this.workingDirectoryPath;
    }
}

