/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.gast2seff.visitors;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.BaseAccess;
import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.core.Position;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.ExceptionHandler;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.util.statementsSwitch;
import eu.qimpress.reverseengineering.gast2seff.jobs.GAST2SEFFJob;
import eu.qimpress.reverseengineering.gast2seff.visitors.FunctionCallClassificationVisitor;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.seff.BranchAction;
import eu.qimpress.seff.ExternalCallAction;
import eu.qimpress.seff.InternalAction;
import eu.qimpress.seff.LoopAction;
import eu.qimpress.seff.ProbabilisticBranchTransition;
import eu.qimpress.seff.ResourceDemandingBehaviour;
import eu.qimpress.seff.seffFactory;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.MethodLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.util.BitSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class GastStatementVisitor
extends statementsSwitch<Object> {
    private static final Logger logger = Logger.getLogger(GastStatementVisitor.class);
    private ResourceDemandingBehaviour seff;
    private SourceCodeDecoratorRepository sourceCodeDecoratorRepository;
    private PrimitiveComponent primitiveComponent;
    private Map<Statement, BitSet> functionClassificationAnnotation;
    private BitSet lastType = null;

    public GastStatementVisitor(Map<Statement, BitSet> functionClassificationAnnotations, ResourceDemandingBehaviour resourceDemandingBehaviour, SourceCodeDecoratorRepository gastBehaviourRepository, PrimitiveComponent primitiveComponent) {
        this.seff = resourceDemandingBehaviour;
        this.functionClassificationAnnotation = functionClassificationAnnotations;
        this.sourceCodeDecoratorRepository = gastBehaviourRepository;
        this.primitiveComponent = primitiveComponent;
    }

    public Object caseBlockStatement(BlockStatement object) {
        for (Statement s : object.getStatements()) {
            BitSet thisType = this.functionClassificationAnnotation.get(s);
            if (!this.shouldSkip(this.lastType, thisType) && !this.isVisitedStatement(thisType)) {
                this.setVisited(thisType);
                this.doSwitch((EObject)s);
            }
            this.lastType = thisType;
        }
        return null;
    }

    public Object caseBranchStatement(BranchStatement object) {
        if (this.containsExternalCall((Statement)object)) {
            BranchAction branch = seffFactory.eINSTANCE.createBranchAction();
            this.seff.getSteps().add((Object)branch);
            branch.setName(this.positionToString(object.getPosition()));
            branch.setDocumentation(this.blockToString(object.getBlockstatement()));
            for (Branch b : object.getBranches()) {
                ProbabilisticBranchTransition bt = seffFactory.eINSTANCE.createProbabilisticBranchTransition();
                bt.setResourceDemandingBehaviour(seffFactory.eINSTANCE.createResourceDemandingBehaviour());
                bt.getResourceDemandingBehaviour().getSteps().add((Object)seffFactory.eINSTANCE.createStartAction());
                bt.setName("parent " + this.positionToString(object.getPosition()) + "/" + this.positionToString(b.getPosition()));
                branch.getAbstractBranchTransition().add((Object)bt);
                GastStatementVisitor visitor = new GastStatementVisitor(this.functionClassificationAnnotation, bt.getResourceDemandingBehaviour(), this.sourceCodeDecoratorRepository, this.primitiveComponent);
                Statement s = b.getStatement();
                visitor.doSwitch((EObject)s);
                bt.getResourceDemandingBehaviour().getSteps().add((Object)seffFactory.eINSTANCE.createStopAction());
                GAST2SEFFJob.connectActions(bt.getResourceDemandingBehaviour());
            }
        } else {
            this.createInternalAction((Statement)object);
        }
        return null;
    }

    public Object caseLoopStatement(LoopStatement object) {
        if (this.containsExternalCall((Statement)object)) {
            LoopAction loop = seffFactory.eINSTANCE.createLoopAction();
            loop.setBodyBehaviour(seffFactory.eINSTANCE.createResourceDemandingBehaviour());
            this.seff.getSteps().add((Object)loop);
            loop.getBodyBehaviour().getSteps().add((Object)seffFactory.eINSTANCE.createStartAction());
            loop.setName(this.positionToString(object.getPosition()));
            loop.setDocumentation(this.blockToString(object.getBlockstatement()));
            new GastStatementVisitor(this.functionClassificationAnnotation, loop.getBodyBehaviour(), this.sourceCodeDecoratorRepository, this.primitiveComponent).doSwitch((EObject)object.getBody());
            loop.getBodyBehaviour().getSteps().add((Object)seffFactory.eINSTANCE.createStopAction());
            GAST2SEFFJob.connectActions(loop.getBodyBehaviour());
        } else {
            this.createInternalAction((Statement)object);
        }
        return null;
    }

    public Object caseExceptionHandler(ExceptionHandler object) {
        if (this.containsExternalCall((Statement)object)) {
            new GastStatementVisitor(this.functionClassificationAnnotation, this.seff, this.sourceCodeDecoratorRepository, this.primitiveComponent).doSwitch((EObject)object.getGuardedBlock());
            if (object.getFinallyBlock() != null) {
                new GastStatementVisitor(this.functionClassificationAnnotation, this.seff, this.sourceCodeDecoratorRepository, this.primitiveComponent).doSwitch((EObject)object.getFinallyBlock());
            }
        } else {
            this.createInternalAction((Statement)object);
        }
        return null;
    }

    public Object caseSimpleStatement(SimpleStatement object) {
        BitSet statementAnnotation = this.functionClassificationAnnotation.get(object);
        if (this.isExternalCall(statementAnnotation)) {
            this.createExternalCallAction(object);
        } else if (this.isInternalCall(statementAnnotation)) {
            FunctionAccess functionAccess = this.getFunctionAccess(object);
            BlockStatement body = functionAccess.getTargetFunction().getBody();
            if (body != null) {
                BitSet thisType = this.functionClassificationAnnotation.get(object);
                if (!this.isVisitedStatement(thisType)) {
                    this.setVisited(thisType);
                    this.doSwitch((EObject)body);
                }
            } else {
                String msg = "Behaviour not set in GAST for " + functionAccess.getTargetFunction().getSimpleName();
                msg = object.getPosition() != null && object.getPosition().getSourceFile() != null && object.getPosition().getSourceFile().getPathName() != null ? String.valueOf(msg) + ". Tried to call from " + object.getPosition().getSourceFile().getPathName() + "." : String.valueOf(msg) + ". (caller position unknown)";
                logger.warn((Object)msg);
            }
        } else {
            this.createInternalAction((Statement)object);
        }
        return null;
    }

    private boolean shouldSkip(BitSet lastType, BitSet thisType) {
        if (lastType == null) {
            return false;
        }
        if (this.isExternalCall(thisType)) {
            return false;
        }
        return !this.isExternalCall(lastType);
    }

    private void createExternalCallAction(SimpleStatement object) {
        ExternalCallAction call = seffFactory.eINSTANCE.createExternalCallAction();
        FunctionAccess access = this.getFunctionAccess(object);
        call.setName(access.getTargetFunction().getSimpleName());
        InterfacePortOperationTuple ifOperationTuple = this.getCalledInterfacePort(access);
        call.setCalledInterfacePort(ifOperationTuple.interfacePort);
        call.setCalledService(ifOperationTuple.operation);
        call.setDocumentation(this.positionToString(object.getPosition()));
        this.seff.getSteps().add((Object)call);
    }

    private InterfacePortOperationTuple getCalledInterfacePort(FunctionAccess access) {
        InterfacePortOperationTuple interfacePortOperationTuple = new InterfacePortOperationTuple();
        for (InterfacePort ifPort : this.primitiveComponent.getRequired()) {
            for (InterfaceSourceCodeLink ifLink : this.sourceCodeDecoratorRepository.getInterfaceSourceCodeLink()) {
                if (!ifPort.getInterfaceType().equals(ifLink.getInterface()) || !ifLink.getGastClass().equals(access.getAccessedClass())) continue;
                logger.trace((Object)("accessed interface port " + ifPort.getName()));
                interfacePortOperationTuple.interfacePort = ifPort;
                interfacePortOperationTuple.operation = this.queryInterfaceOperation(access);
                return interfacePortOperationTuple;
            }
        }
        logger.warn((Object)("found no if port for " + access.getAccessedClass().getSimpleName()));
        return interfacePortOperationTuple;
    }

    private Operation queryInterfaceOperation(FunctionAccess access) {
        for (MethodLevelSourceCodeLink methodLink : this.sourceCodeDecoratorRepository.getMethodLevelSourceCodeLink()) {
            if (!methodLink.getFunction().equals(access.getTargetFunction())) continue;
            logger.trace((Object)("accessed operation " + methodLink.getOperation().getName()));
            return methodLink.getOperation();
        }
        logger.warn((Object)("no accessed operation found for " + access.getTargetFunction().getSimpleName()));
        return null;
    }

    private boolean isExternalCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
    }

    private boolean isInternalCall(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.INTERNAL));
    }

    private boolean isVisitedStatement(BitSet statementAnnotation) {
        return statementAnnotation.get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.VISITED));
    }

    private void setVisited(BitSet thisType) {
        thisType.set(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.VISITED), true);
    }

    private FunctionAccess getFunctionAccess(SimpleStatement object) {
        for (BaseAccess a : object.getAccesses()) {
            if (!(a instanceof FunctionAccess)) continue;
            return (FunctionAccess)a;
        }
        return null;
    }

    private void createInternalAction(Statement statement) {
        InternalAction ia = seffFactory.eINSTANCE.createInternalAction();
        ia.setName("IA " + this.positionToString(statement.getPosition()));
        ia.setDocumentation(String.valueOf(this.blockToString(statement.getBlockstatement())) + "; Statement SISSyID: " + statement.getSissyId());
        this.seff.getSteps().add((Object)ia);
    }

    private String blockToString(BlockStatement blockstatement) {
        if (blockstatement != null) {
            Access access;
            BaseAccess firstAccess;
            StringBuilder blockString = new StringBuilder("Block: ");
            blockString.append(blockstatement.toString());
            if (blockstatement.getAccesses() != null && blockstatement.getAccesses().size() >= 1 && (firstAccess = (BaseAccess)blockstatement.getAccesses().get(0)) instanceof Access && (access = (Access)firstAccess).getAccessedClass() != null) {
                blockString.append(" " + access.getAccessedClass().getSimpleName() + "...");
            }
            return blockString.toString();
        }
        return "No blockstatement";
    }

    private String positionToString(Position position) {
        StringBuilder positionString = new StringBuilder("position: ");
        if (position != null) {
            if (position.getSourceFile() != null && position.getSourceFile().getClass() != null) {
                positionString.append(position.getSourceFile().getClass());
            }
            positionString.append(" from " + position.getStartLine());
            positionString.append(" to " + position.getEndLine());
        } else {
            positionString.append("no position information available");
        }
        return positionString.toString();
    }

    private boolean containsExternalCall(Statement object) {
        return this.functionClassificationAnnotation.get(object).get(FunctionCallClassificationVisitor.getIndex(FunctionCallClassificationVisitor.FunctionCallType.EXTERNAL));
    }

    private class InterfacePortOperationTuple {
        public InterfacePort interfacePort;
        public Operation operation;

        private InterfacePortOperationTuple() {
        }
    }
}

