/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.gast2seff.visitors;

import de.fzi.gast.accesses.BaseAccess;
import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.BranchStatement;
import de.fzi.gast.statements.ExceptionHandler;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.SimpleStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.util.statementsSwitch;
import eu.qimpress.reverseengineering.gast2seff.visitors.GastStatementVisitor;
import eu.qimpress.reverseengineering.gast2seff.visitors.IFunctionClassificationStrategy;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class FunctionCallClassificationVisitor
extends statementsSwitch<BitSet> {
    private static final Logger logger = Logger.getLogger(GastStatementVisitor.class);
    private HashMap<Statement, BitSet> annotations = new HashMap();
    private IFunctionClassificationStrategy myStrategy = null;

    public FunctionCallClassificationVisitor(IFunctionClassificationStrategy strategy) {
        this.myStrategy = strategy;
    }

    public BitSet caseStatement(Statement object) {
        this.safePut(object, new BitSet());
        return new BitSet();
    }

    public BitSet caseBlockStatement(BlockStatement object) {
        if (this.annotations.containsKey(object)) {
            return this.annotations.get(object);
        }
        BitSet myType = this.computeChildAnnotations(new BitSet(), (List<Statement>)object.getStatements());
        this.annotations.put((Statement)object, myType);
        return myType;
    }

    public BitSet caseBranchStatement(BranchStatement object) {
        if (this.annotations.containsKey(object)) {
            return this.annotations.get(object);
        }
        for (Branch branch : object.getBranches()) {
            this.doSwitch((EObject)branch.getStatement());
        }
        ArrayList<Statement> branchStatements = new ArrayList<Statement>();
        for (Branch branch : object.getBranches()) {
            branchStatements.add(branch.getStatement());
        }
        BitSet myType = this.computeChildAnnotations(new BitSet(), branchStatements);
        this.annotations.put((Statement)object, myType);
        return myType;
    }

    public BitSet caseLoopStatement(LoopStatement object) {
        if (this.annotations.containsKey(object)) {
            return this.annotations.get(object);
        }
        this.doSwitch((EObject)object.getBody());
        BitSet myType = this.annotations.get(object.getBody());
        this.annotations.put((Statement)object, myType);
        return myType;
    }

    public BitSet caseExceptionHandler(ExceptionHandler object) {
        if (this.annotations.containsKey(object)) {
            return this.annotations.get(object);
        }
        ArrayList<Statement> allChildStatements = new ArrayList<Statement>();
        this.doSwitch((EObject)object.getGuardedBlock());
        allChildStatements.addAll((Collection<Statement>)object.getGuardedBlock().getStatements());
        if (object.getFinallyBlock() != null) {
            this.doSwitch((EObject)object.getFinallyBlock());
            allChildStatements.addAll((Collection<Statement>)object.getFinallyBlock().getStatements());
        }
        BitSet myType = this.computeChildAnnotations(new BitSet(), allChildStatements);
        this.annotations.put((Statement)object, myType);
        return myType;
    }

    public BitSet caseSimpleStatement(SimpleStatement object) {
        if (this.annotations.containsKey(object)) {
            return this.annotations.get(object);
        }
        BitSet myType = this.myStrategy.classifySimpleStatement(object);
        this.annotations.put((Statement)object, myType);
        if (myType.get(FunctionCallClassificationVisitor.getIndex(FunctionCallType.INTERNAL))) {
            FunctionAccess functionAccess = this.getFunctionAccess(object);
            BlockStatement targetFunctionBody = functionAccess.getTargetFunction().getBody();
            if (targetFunctionBody != null) {
                logger.trace((Object)("visiting internal call. accessed class: " + functionAccess.getAccessedClass()));
                this.doSwitch((EObject)targetFunctionBody);
            } else {
                logger.warn((Object)("Behaviour not set in GAST for " + functionAccess.getTargetFunction().getSimpleName()));
            }
        }
        return myType;
    }

    private FunctionAccess getFunctionAccess(SimpleStatement object) {
        for (BaseAccess a : object.getAccesses()) {
            if (!(a instanceof FunctionAccess)) continue;
            return (FunctionAccess)a;
        }
        return null;
    }

    private void safePut(Statement object, BitSet type) {
        if (!this.annotations.containsKey(object)) {
            this.annotations.put(object, type);
        }
    }

    private BitSet computeChildAnnotations(BitSet initalValue, List<Statement> childStatements) {
        for (Statement s : childStatements) {
            this.doSwitch((EObject)s);
        }
        BitSet myType = initalValue;
        for (Statement s : childStatements) {
            this.myStrategy.mergeFunctionCallType(myType, this.annotations.get(s));
        }
        return myType;
    }

    public static int getIndex(FunctionCallType type) {
        switch (type) {
            case INTERNAL: {
                return 0;
            }
            case EXTERNAL: {
                return 1;
            }
            case LIBRARY: {
                return 2;
            }
            case VISITED: {
                return 3;
            }
        }
        throw new UnsupportedOperationException();
    }

    public Map<Statement, BitSet> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public static enum FunctionCallType {
        EXTERNAL,
        LIBRARY,
        INTERNAL,
        VISITED;

    }
}

