/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.gast2seff.visitors;

import de.fzi.gast.accesses.FunctionAccess;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.reverseengineering.gast2seff.visitors.AbstractFunctionClassificationStrategy;
import eu.qimpress.reverseengineering.gast2seff.visitors.IFunctionClassificationStrategy;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import org.apache.log4j.Logger;

public class BasicFunctionClassificationStrategy
extends AbstractFunctionClassificationStrategy
implements IFunctionClassificationStrategy {
    private static Logger logger = Logger.getLogger(BasicFunctionClassificationStrategy.class);
    private SourceCodeDecoratorRepository sourceCodeDecoratorRepository;
    private PrimitiveComponent primitiveComponent;

    public BasicFunctionClassificationStrategy(SourceCodeDecoratorRepository sourceCodeDecoratorRepository, PrimitiveComponent primitiveComponent) {
        this.sourceCodeDecoratorRepository = sourceCodeDecoratorRepository;
        this.primitiveComponent = primitiveComponent;
    }

    @Override
    protected boolean isExternalCall(FunctionAccess functionAccess) {
        ComponentImplementingClassesLink compLink = this.queryComponentLink(this.primitiveComponent);
        for (InterfaceSourceCodeLink ifLink : compLink.getRequiredInterfaces()) {
            if (!ifLink.getGastClass().getMethods().contains((Object)functionAccess.getTargetFunction())) continue;
            logger.debug((Object)("Classified call as external call: " + functionAccess.getTargetFunction().getSimpleName() + " for component " + this.primitiveComponent.getName()));
            return true;
        }
        logger.trace((Object)("no external call: " + functionAccess.getTargetFunction().getSimpleName()));
        return false;
    }

    private ComponentImplementingClassesLink queryComponentLink(PrimitiveComponent primitiveComponent) {
        for (ComponentImplementingClassesLink compLink : this.sourceCodeDecoratorRepository.getComponentImplementingClassesLink()) {
            if (!compLink.getComponent().equals(primitiveComponent)) continue;
            return compLink;
        }
        String msg = "Could not find a component implementing classes link in the source code decorator for component " + primitiveComponent.getName();
        logger.error((Object)msg);
        throw new RuntimeException(msg);
    }

    @Override
    protected boolean isLibraryCall(FunctionAccess functionAccess) {
        GASTClass targetClass = functionAccess.getAccessedClass();
        if (targetClass == null) {
            logger.warn((Object)"Failed to classifiy library call because called GASTClass was unavailable.");
            return true;
        }
        logger.debug((Object)("Classified call as library call: " + functionAccess.getTargetFunction().getSimpleName() + " for component " + this.primitiveComponent.getName()));
        return targetClass.getPosition() == null || targetClass.getPosition().getSourceFile() == null;
    }
}

