/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.parsetree.reconstr.IInstanceDescription;
import org.eclipse.xtext.parsetree.reconstr.ITransientValueService;

public class InstanceDescriptF1X
implements IInstanceDescription {
    private final ITransientValueService tv;
    private final EObject described;
    private BitSet multiFeatures;
    private final int[] next;

    public InstanceDescriptF1X(ITransientValueService t, EObject desc) {
        this.described = desc;
        this.tv = t;
        EList features = this.described.eClass().getEAllStructuralFeatures();
        this.next = new int[features.size()];
        int id = 0;
        while (id < features.size()) {
            EStructuralFeature f = (EStructuralFeature)features.get(id);
            if (f.isMany() && this.tv.isMixedList(desc, f)) {
                if (this.multiFeatures == null) {
                    this.multiFeatures = new BitSet();
                }
                this.multiFeatures.set(id);
                this.next[id] = this.firstID(f);
            } else {
                this.next[id] = !this.tv.isTransient(this.described, f, -1) ? this.firstID(f) : -1;
            }
            ++id;
        }
    }

    private InstanceDescriptF1X(ITransientValueService tv, EObject described, int[] next, BitSet multi) {
        this.tv = tv;
        this.described = described;
        this.next = next;
        this.multiFeatures = multi;
    }

    public IInstanceDescription cloneAndConsume(String feature) {
        EStructuralFeature f = this.getFeature(feature);
        int[] con = new int[this.next.length];
        System.arraycopy(this.next, 0, con, 0, this.next.length);
        int fid = this.described.eClass().getFeatureID(f);
        con[fid] = this.nextID(f, con[fid]);
        return new InstanceDescriptF1X(this.tv, this.described, con, this.multiFeatures);
    }

    private int firstID(EStructuralFeature f) {
        return this.nextID(f, f.isMany() ? ((List)this.described.eGet(f)).size() : 1);
    }

    public Object getConsumable(String feature, boolean allowDefault) {
        EStructuralFeature f = this.getFeature(feature);
        if (f != null && this.isConsumable(f, allowDefault)) {
            Object get = this.described.eGet(f);
            if (f.isMany()) {
                List list = (List)get;
                get = list.get(this.next[this.described.eClass().getFeatureID(f)]);
            }
            return get;
        }
        return null;
    }

    public EObject getDelegate() {
        return this.described;
    }

    private EStructuralFeature getFeature(String feature) {
        return this.described.eClass().getEStructuralFeature(feature);
    }

    public Map<EStructuralFeature, Integer> getUnconsumed() {
        HashMap<EStructuralFeature, Integer> m = new HashMap<EStructuralFeature, Integer>();
        EList features = this.described.eClass().getEAllStructuralFeatures();
        int id = 0;
        while (id < features.size()) {
            if (this.next[id] > -1) {
                m.put((EStructuralFeature)features.get(id), this.next[id] + 1);
            }
            ++id;
        }
        return m;
    }

    public boolean isConsumable(EStructuralFeature f, boolean allowDefault) {
        return this.next[this.described.eClass().getFeatureID(f)] > (allowDefault && !f.isMany() ? -2 : -1);
    }

    public boolean isConsumed() {
        int i = 0;
        while (i < this.next.length) {
            if (this.next[i] > -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isConsumedWithLastConsumtion(String feature) {
        EStructuralFeature f = this.getFeature(feature);
        int id = this.described.eClass().getFeatureID(f);
        int i = 0;
        while (i < this.next.length) {
            if ((i == id ? this.nextID(f, this.next[i]) : this.next[i]) > -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isInstanceOf(EClassifier classifier) {
        if (!(classifier instanceof EClass)) {
            return false;
        }
        if (classifier == EcorePackage.Literals.EOBJECT) {
            return true;
        }
        return ((EClass)classifier).isSuperTypeOf(this.getDelegate().eClass());
    }

    private int nextID(EStructuralFeature f, int lastId) {
        int myLastId = lastId;
        if (f.isMany()) {
            if (this.multiFeatures != null && this.multiFeatures.get(this.described.eClass().getFeatureID(f))) {
                --myLastId;
                while (myLastId >= 0 && this.tv.isTransient(this.described, f, myLastId)) {
                    --myLastId;
                }
                return myLastId;
            }
        } else if (lastId == 0) {
            return -2;
        }
        return myLastId - 1;
    }

    public String toString() {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<EStructuralFeature, Integer> f : this.getUnconsumed().entrySet()) {
            l.add(String.valueOf(f.getKey().getName()) + ":" + f.getValue());
        }
        return String.valueOf(this.described.eClass().getName()) + ":" + this.described.hashCode() + (l.size() > 0 ? ":" + l : "");
    }
}

