/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.project.adapters;

import eu.qimpress.ide.backbone.project.adapters.IConcreteSyntaxFile;
import eu.qimpress.ide.backbone.project.listeners.XtextResourceChangeListener;
import eu.qimpress.samm.core.NamedEntity;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class XtextResourceBasedConcreteSyntaxFile
implements IConcreteSyntaxFile {
    private static final Logger logger = Logger.getLogger(XtextResourceBasedConcreteSyntaxFile.class);
    private NamedEntity namedEntity;
    private IFile outputFile;
    private Resource ecoreResource;
    private Resource xtextResource;
    private IResourceChangeListener resourceChangeListener;
    private IPartListener partListener;

    public XtextResourceBasedConcreteSyntaxFile(NamedEntity namedEntity, IFile outputFile) {
        this.namedEntity = namedEntity;
        this.outputFile = outputFile;
        this.ecoreResource = namedEntity.eResource();
    }

    @Override
    public IFile generate() throws Exception {
        try {
            logger.trace((Object)"Generating file with concrete syntax");
            this.doGenerate();
        }
        catch (Exception e) {
            logger.error((Object)("Cannot serialize model element " + this.namedEntity + "to file."), (Throwable)e);
            throw e;
        }
        return this.outputFile;
    }

    protected void doGenerate() throws IOException {
        XtextResourceSet xrs = new XtextResourceSet();
        this.xtextResource = xrs.createResource(URI.createURI((String)this.outputFile.getLocationURI().toString()));
        this.xtextResource.getContents().addAll(EcoreUtil.copyAll((Collection)this.ecoreResource.getContents()));
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put(XtextResource.OPTION_FORMAT, Boolean.TRUE);
        options.put(XtextResource.OPTION_RESOLVE_ALL, Boolean.TRUE);
        this.xtextResource.save(options);
        this.xtextResource.unload();
        this.xtextResource.load(null);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public void dispose() {
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
            logger.trace((Object)" - resource listener unregistered");
        }
        if (this.partListener != null) {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            activePage.removePartListener(this.partListener);
            logger.trace((Object)" - part listener unregistered");
        }
        try {
            this.outputFile.delete(true, null);
        }
        catch (CoreException e) {
            logger.warn((Object)("Cannot delete temporary file with concrete syntax: " + this.outputFile), (Throwable)e);
        }
    }

    @Override
    public Resource getOriginalResource() {
        return this.ecoreResource;
    }

    @Override
    public Resource getConcreteResource() {
        return this.xtextResource;
    }

    @Override
    public IFile getOutputFile() {
        return this.outputFile;
    }

    @Override
    public void openInEditor(String editorId) throws PartInitException {
        FileEditorInput editorInput = new FileEditorInput(this.outputFile){

            public String getName() {
                return String.valueOf(XtextResourceBasedConcreteSyntaxFile.this.namedEntity.eClass().getName()) + " " + XtextResourceBasedConcreteSyntaxFile.this.namedEntity.getName();
            }
        };
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        IEditorPart editor = workbenchPage.openEditor((IEditorInput)editorInput, editorId);
        logger.trace((Object)("Editor opened: " + editorId));
        this.selectEntityInEditor((ITextEditor)editor);
        this.registerListeners();
    }

    protected void selectEntityInEditor(ITextEditor textEditor) {
        CompositeNode parserNode;
        NodeAdapter nodeAdapter = NodeUtil.getNodeAdapter((EObject)this.xtextResource.getEObject(this.namedEntity.getId()));
        if (nodeAdapter != null && (parserNode = nodeAdapter.getParserNode()) != null && parserNode != null) {
            textEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(parserNode.getOffset(), parserNode.getLength()));
        }
    }

    protected void registerListeners() {
        logger.trace((Object)" - registering resource listener");
        this.resourceChangeListener = new XtextResourceChangeListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        logger.trace((Object)" - registering part listener");
        this.partListener = (IPartListener)this.resourceChangeListener;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.addPartListener(this.partListener);
    }
}

