/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.model;

import eu.qimpress.ide.backbone.core.internal.model.ISupportSaveable;
import eu.qimpress.ide.backbone.core.internal.model.QAlternativeImpl;
import eu.qimpress.ide.backbone.core.internal.model.QAlternativeInfoImpl;
import eu.qimpress.ide.backbone.core.internal.model.QCachedDirectoryRepositoryController;
import eu.qimpress.ide.backbone.core.internal.model.QElement;
import eu.qimpress.ide.backbone.core.internal.model.QModelImpl;
import eu.qimpress.ide.backbone.core.internal.model.QRepositoryParam;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQAlternativeInfo;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQInitializer;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.IQWorkspaceController;
import eu.qimpress.ide.backbone.core.model.ISaveable;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.resultmodel.ResultModelFactory;
import eu.qimpress.resultmodel.ResultRepository;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBFactory;
import org.neodatis.odb.Objects;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.criteria.Where;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;

public class QCachedDirectoryRepositoryImpl
extends QElement
implements IQRepository,
ISupportSaveable {
    static final Logger logger = Logger.getLogger(QCachedDirectoryRepositoryImpl.class);
    static final IQAlternative[] EMPTY_ALTERNATIVE_ARRAY = new IQAlternative[0];
    public static final String DEFAULT_REPOSITORY_LOCATION = "alternatives";
    public static final String DEFAULT_REPOSITORY_DB_LOCATION = ".db";
    private QCachedDirectoryRepositoryController controller;
    private IFolder directory;
    private IQProject qProject;
    private Map<String, IQAlternative> alternativeCache = new LinkedHashMap<String, IQAlternative>();
    private IQAlternative defaultAlternative = null;
    private IQAlternative globalAlternative = null;
    IFile dbFile;
    String dbFileName;

    QCachedDirectoryRepositoryImpl(IQProject project, IFolder directory) throws RepositoryException {
        super(project);
        this.qProject = project;
        this.directory = directory;
        this.dbFile = this.directory.getFile(DEFAULT_REPOSITORY_DB_LOCATION);
        this.dbFileName = this.dbFile.getLocation().toOSString();
        this.controller = new QCachedDirectoryRepositoryController(this);
    }

    private ODB getODB() {
        return ODBFactory.open((String)this.dbFileName);
    }

    private void releaseODB(ODB odb) {
        odb.close();
        odb = null;
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation((ISchedulingRule)this.directory){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    QCachedDirectoryRepositoryImpl.this.dbFile.refreshLocal(0, null);
                }
            };
            operation.run(null);
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot refresh database file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCacheAlternatives() throws RepositoryException {
        IFile iFile = this.dbFile;
        synchronized (iFile) {
            ODB odb = this.getODB();
            try {
                Objects obs = odb.getObjects(QAlternativeInfoImpl.class);
                this.updateRetrievedAlternatives((Objects<QAlternativeInfoImpl>)obs);
            }
            finally {
                this.releaseODB(odb);
            }
        }
    }

    private void updateRetrievedAlternatives(Objects<QAlternativeInfoImpl> obs) throws RepositoryException {
        for (QAlternativeInfoImpl ai : obs) {
            QAlternativeImpl alternative = new QAlternativeImpl(this, null, ai);
            if (!alternative.getCorrespondingResource().exists()) {
                logger.warn((Object)("Alternative does not exist. Skipped. AlternativeInfo: " + ai + ", repository: " + this));
                continue;
            }
            if (ai.getId().equals("0")) {
                this.globalAlternative = alternative;
            } else {
                this.alternativeCache.put(alternative.getInfo().getId(), alternative);
            }
            if (!ai.isDefault()) continue;
            this.defaultAlternative = alternative;
        }
        for (IQAlternative alternative : this.alternativeCache.values()) {
            ((QElement)((Object)alternative)).parent = alternative.getInfo().getParent() == null ? this : (IQElement)this.alternativeCache.get(alternative.getInfo().getParent().getId());
        }
    }

    @Override
    public IQAlternative[] listAllAlternatives() throws RepositoryException {
        return this.alternativeCache.values().toArray(new IQAlternative[this.alternativeCache.size()]);
    }

    @Override
    public IQAlternative[] listTopLevelAlternatives() throws RepositoryException {
        ArrayList<IQAlternative> result = new ArrayList<IQAlternative>(4);
        for (IQAlternative alt : this.alternativeCache.values()) {
            if (alt.getInfo().getParent() != null) continue;
            result.add(alt);
        }
        Collections.sort(result, QAlternativeComparator.INSTANCE);
        return result.toArray(new IQAlternative[result.size()]);
    }

    @Override
    public IQAlternative getAlternative(String id) throws RepositoryException {
        if (id.equals("0")) {
            return this.globalAlternative;
        }
        return this.alternativeCache.containsKey(id) ? this.alternativeCache.get(id) : null;
    }

    @Override
    public IQAlternative[] getChildren(IQAlternative parentAlt) throws RepositoryException {
        ArrayList<IQAlternative> result = new ArrayList<IQAlternative>(4);
        for (IQAlternative alt : this.alternativeCache.values()) {
            if (alt.getParent() == null || !alt.getParent().equals(parentAlt)) continue;
            result.add(alt);
        }
        Collections.sort(result, QAlternativeComparator.INSTANCE);
        return result.toArray(new IQAlternative[result.size()]);
    }

    @Override
    public IQAlternative createAlternative(String description) throws RepositoryException {
        return this.createAlternative(null, description, false, null);
    }

    @Override
    public IQAlternative createAlternative(IQAlternative parent, String description) throws RepositoryException {
        return this.createAlternative(parent, description, false);
    }

    @Override
    public IQAlternative createAlternative(IQAlternative parent, String description, boolean noCopy) throws RepositoryException {
        return this.createAlternative(parent, description, noCopy, null);
    }

    @Override
    public IQAlternative createAlternative(String description, String specifiedId) throws RepositoryException {
        return this.createAlternative(null, description, false, specifiedId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQAlternative createAlternative(IQAlternative parent, String description, boolean noCopy, String specifiedId) throws RepositoryException {
        IQAlternativeInfo parentInfo = parent != null ? parent.getInfo() : null;
        QAlternativeInfoImpl alternativeInfo = null;
        alternativeInfo = specifiedId != null ? new QAlternativeInfoImpl(parentInfo, description, specifiedId) : new QAlternativeInfoImpl(parentInfo, description);
        IFile iFile = this.dbFile;
        synchronized (iFile) {
            ODB odb = this.getODB();
            try {
                odb.store((Object)alternativeInfo);
                odb.commit();
            }
            finally {
                this.releaseODB(odb);
            }
        }
        QAlternativeImpl alt = new QAlternativeImpl(this, parent, alternativeInfo);
        IQWorkspaceController altController = (IQWorkspaceController)alt.getAdapter(IQWorkspaceController.class);
        altController.init(false, true);
        if (alternativeInfo.getId().equals("0")) {
            this.globalAlternative = alt;
        } else {
            this.alternativeCache.put(alt.getInfo().getId(), alt);
        }
        return alt;
    }

    @Override
    public void deleteAlternative(IQAlternative alternative) throws RepositoryException {
        this.deleteAlternative(alternative, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAlternative(IQAlternative alternative, boolean deleteContent, boolean force) throws RepositoryException {
        Object chAlt;
        IQAlternative[] children = this.getChildren(alternative);
        if (force) {
            IQAlternative[] iQAlternativeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                chAlt = iQAlternativeArray[n2];
                this.deleteAlternative((IQAlternative)chAlt, deleteContent, force);
                ++n2;
            }
        } else if (children.length != 0) {
            throw new RepositoryException("Cannot be deleted - there are child alternatives");
        }
        chAlt = this.dbFile;
        synchronized (chAlt) {
            ODB odb = this.getODB();
            try {
                String id = alternative.getInfo().getId();
                CriteriaQuery q = new CriteriaQuery(QAlternativeInfoImpl.class, Where.equal((String)"id", (Object)id));
                Objects obs = odb.getObjects((IQuery)q);
                if (obs.size() != 0) {
                    odb.delete(obs.getFirst());
                    odb.commit();
                }
            }
            finally {
                this.releaseODB(odb);
            }
        }
        this.alternativeCache.remove(alternative.getInfo().getId());
        if (deleteContent) {
            try {
                if (alternative.getAlternativeFolder().exists()) {
                    alternative.getAlternativeFolder().delete(true, false, null);
                }
            }
            catch (CoreException ex) {
                throw new RepositoryException("Cannot delete content of the alternative \"" + alternative.getInfo().getId() + "\"", ex);
            }
        }
    }

    @Override
    public void deleteAlternativeEvaluation(AlternativeEvaluation alternativeEvaluation) throws RepositoryException {
        this.getResultRepository().getAnalysisRuns().remove((Object)alternativeEvaluation);
    }

    @Override
    public void close() throws RepositoryException {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public IQElement.ElementType getElementType() {
        return IQElement.ElementType.Q_REPOSITORY;
    }

    @Override
    public IResource getCorrespondingResource() {
        return this.getRepositoryFolder();
    }

    @Override
    public IFolder getRepositoryFolder() {
        return this.directory;
    }

    @Override
    public IQAlternative getDefaultAlternative() throws RepositoryException {
        return this.defaultAlternative;
    }

    private void unsetNondefaultAlternatives(IQAlternative newDefAlt) throws RepositoryException {
        IQAlternative[] alternatives;
        IQRepository repo = newDefAlt.getRepository();
        IQAlternative[] iQAlternativeArray = alternatives = repo.listAllAlternatives();
        int n = alternatives.length;
        int n2 = 0;
        while (n2 < n) {
            IQAlternative alt = iQAlternativeArray[n2];
            if (alt != newDefAlt) {
                alt.getInfo().setDefault(false);
                this.save((ISaveable)((QAlternativeInfoImpl)newDefAlt.getInfo()));
            }
            ++n2;
        }
    }

    @Override
    public void setDefaultAlternative(IQAlternative newDefAlt) throws RepositoryException {
        this.unsetNondefaultAlternatives(newDefAlt);
        if (this.defaultAlternative == newDefAlt) {
            return;
        }
        IQAlternative oldDefAlt = this.defaultAlternative;
        newDefAlt.getInfo().setDefault(true);
        this.defaultAlternative = newDefAlt;
        if (oldDefAlt != null) {
            oldDefAlt.getInfo().setDefault(false);
            this.save((QAlternativeInfoImpl)oldDefAlt.getInfo(), (QAlternativeInfoImpl)newDefAlt.getInfo());
        } else {
            this.save((ISaveable)((QAlternativeInfoImpl)newDefAlt.getInfo()));
        }
    }

    @Override
    public IQAlternative getGlobalAlternative() throws RepositoryException {
        IQAlternative globalAlternative = null;
        try {
            globalAlternative = this.getAlternative("0");
        }
        catch (RepositoryException e) {
            logger.debug((Object)"Exception occured during getting global alternative", (Throwable)e);
        }
        if (globalAlternative == null && this.controller.isReady()) {
            throw new RepositoryException("Global alternative not found, there should always be a single global alternative in a project. To avoid this exception disable and enable Q-I nature for project: " + this.getQProject().getProject().getName());
        }
        return globalAlternative;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ISaveable o) throws RepositoryException {
        IFile iFile = this.dbFile;
        synchronized (iFile) {
            ODB odb = this.getODB();
            try {
                odb.store((Object)o);
                odb.commit();
            }
            finally {
                this.releaseODB(odb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(ISaveable ... os) throws RepositoryException {
        IFile iFile = this.dbFile;
        synchronized (iFile) {
            ODB odb = this.getODB();
            try {
                ISaveable[] iSaveableArray = os;
                int n = os.length;
                int n2 = 0;
                while (n2 < n) {
                    ISaveable o = iSaveableArray[n2];
                    odb.store((Object)o);
                    ++n2;
                }
                odb.commit();
            }
            finally {
                this.releaseODB(odb);
            }
        }
    }

    @Override
    public IQProject getQProject() {
        return (IQProject)this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        boolean result = false;
        IFile iFile = this.dbFile;
        synchronized (iFile) {
            ODB odb = this.getODB();
            try {
                CriteriaQuery query = new CriteriaQuery(QRepositoryParam.class, Where.equal((String)"key", (Object)key));
                result = odb.count(query).compareTo(new BigInteger("0")) > 0;
            }
            finally {
                this.releaseODB(odb);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getParameter(String key) {
        CriteriaQuery query = new CriteriaQuery(QRepositoryParam.class, Where.equal((String)"key", (Object)key));
        Objects objects = null;
        IFile iFile = this.dbFile;
        synchronized (iFile) {
            ODB odb = this.getODB();
            try {
                objects = odb.getObjects((IQuery)query);
            }
            finally {
                this.releaseODB(odb);
            }
        }
        if (objects.size() == 0) {
            return null;
        }
        return ((QRepositoryParam)objects.getFirst()).value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String key, Object value) {
        CriteriaQuery query = new CriteriaQuery(QRepositoryParam.class, Where.equal((String)"key", (Object)key));
        IFile iFile = this.dbFile;
        synchronized (iFile) {
            ODB odb = this.getODB();
            try {
                Objects objects = odb.getObjects((IQuery)query);
                if (objects.size() == 0) {
                    if (value != null) {
                        odb.store((Object)new QRepositoryParam(key, value));
                    }
                } else {
                    QRepositoryParam param = (QRepositoryParam)objects.getFirst();
                    if (value == null) {
                        odb.delete((Object)param);
                    } else {
                        param.value = value;
                        odb.store((Object)param);
                    }
                }
                odb.commit();
            }
            finally {
                this.releaseODB(odb);
            }
        }
    }

    @Override
    public AlternativeEvaluation createAlternativeEvaluation() throws RepositoryException {
        AlternativeEvaluation newAlternativeEvaluation = ResultModelFactory.eINSTANCE.createAlternativeEvaluation();
        this.getResultRepository().getAnalysisRuns().add((Object)newAlternativeEvaluation);
        return newAlternativeEvaluation;
    }

    @Override
    public AlternativeEvaluation createAlternativeEvaluation(String alternativeId) throws RepositoryException {
        AlternativeEvaluation newAltEval = this.createAlternativeEvaluation();
        newAltEval.setAlternativeId(alternativeId);
        return newAltEval;
    }

    @Override
    public List<AlternativeEvaluation> getAllAlternativeEvaluations() throws RepositoryException {
        return this.getResultRepository().getAnalysisRuns();
    }

    @Override
    public List<AlternativeEvaluation> getAlternativeEvaluationsByAlternativeId(String id) throws RepositoryException {
        LinkedList<AlternativeEvaluation> listFound = new LinkedList<AlternativeEvaluation>();
        for (AlternativeEvaluation altEval : this.getAllAlternativeEvaluations()) {
            if (!id.equals(altEval.getAlternativeId())) continue;
            listFound.add(altEval);
        }
        return listFound;
    }

    @Override
    public IQModel getResultModel() throws RepositoryException {
        IFile resultModelFile = this.getResultRepositoryFile();
        if (resultModelFile != null) {
            QModelImpl qModel = new QModelImpl(resultModelFile, this.getGlobalAlternative());
            return qModel;
        }
        return null;
    }

    @Override
    public ResultRepository getResultRepository() throws RepositoryException {
        IQModel resultModel = this.getResultModel();
        ResultRepository resultRepository = resultModel.getTopLevelEObject(ResultRepository.class, ResultModelFactory.eINSTANCE.getResultModelPackage().getResultRepository());
        return resultRepository;
    }

    protected IFile getResultRepositoryFile() {
        try {
            IFolder defAlternativeFolder = this.getGlobalAlternative().getAlternativeFolder();
            return defAlternativeFolder.getFile("global_result_repository.samm_resultmodel");
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot get result repository file!", (Throwable)e);
            return null;
        }
    }

    protected IFile getUsageModelFile() {
        try {
            IFolder defAlternativeFolder = this.qProject.getRepository().getGlobalAlternative().getAlternativeFolder();
            return defAlternativeFolder.getFile("usage_model.samm_usagemodel");
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot get usage model file!", (Throwable)e);
            return null;
        }
    }

    @Override
    public IQModel getGlobalModel(String modelType) throws RepositoryException {
        IQAlternative alternative = this.getGlobalAlternative();
        return alternative.getModel(modelType);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IQWorkspaceController.class)) {
            return this.controller;
        }
        if (adapter.equals(IQInitializer.class)) {
            return this.controller;
        }
        return super.getAdapter(adapter);
    }

    private static final class QAlternativeComparator
    implements Comparator<IQAlternative> {
        private static final QAlternativeComparator INSTANCE = new QAlternativeComparator();

        private QAlternativeComparator() {
        }

        @Override
        public int compare(IQAlternative o1, IQAlternative o2) {
            String s1 = o1.getInfo().getDescription();
            String s2 = o2.getInfo().getDescription();
            return s1.compareTo(s2);
        }
    }
}

