/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.model;

import eu.qimpress.ide.backbone.core.internal.model.AbstractQController;
import eu.qimpress.ide.backbone.core.internal.model.QCachedDirectoryRepositoryImpl;
import eu.qimpress.ide.backbone.core.model.IQInitializer;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.undo.CreateFolderOperation;

public class QCachedDirectoryRepositoryController
extends AbstractQController<QCachedDirectoryRepositoryImpl>
implements IQInitializer {
    private static final Logger logger = Logger.getLogger(QCachedDirectoryRepositoryImpl.class);
    private boolean isReady = false;
    private Job workingJob = null;

    public QCachedDirectoryRepositoryController(QCachedDirectoryRepositoryImpl repo) {
        super(repo);
    }

    @Override
    protected void doInit(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation op = this.getInitWSOperation();
        op.run(monitor);
    }

    @Override
    public WorkspaceModifyOperation getInitWSOperation() {
        return new InitializeRepositoryOperation();
    }

    @Override
    public Job getWorkingJob() {
        return this.workingJob;
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public boolean needsInitialization() {
        if (this.isReady) {
            return false;
        }
        return !this.isInitializationInProgress();
    }

    private class DatabazePreLoadOperation
    extends WorkspaceModifyOperation {
        public DatabazePreLoadOperation() {
            super((ISchedulingRule)((QCachedDirectoryRepositoryImpl)QCachedDirectoryRepositoryController.this.element).getCorrespondingResource());
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            try {
                try {
                    monitor.beginTask("", 1);
                    ((QCachedDirectoryRepositoryImpl)QCachedDirectoryRepositoryController.this.element).doCacheAlternatives();
                }
                catch (RepositoryException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private class InitializeRepositoryOperation
    extends WorkspaceModifyOperation {
        public InitializeRepositoryOperation() {
            super((ISchedulingRule)((QCachedDirectoryRepositoryImpl)QCachedDirectoryRepositoryController.this.element).getCorrespondingResource().getParent());
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            try {
                block7: {
                    monitor.beginTask("", 2);
                    IFolder repositoryFolder = ((QCachedDirectoryRepositoryImpl)QCachedDirectoryRepositoryController.this.element).getRepositoryFolder();
                    repositoryFolder.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!repositoryFolder.exists() && !repositoryFolder.isLinked(512)) {
                        CreateFolderOperation op1 = new CreateFolderOperation(repositoryFolder, null, "Create repository folder");
                        try {
                            IStatus status = op1.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1), null);
                            if (status.matches(4)) {
                                throw new InvocationTargetException(status.getException());
                            }
                        }
                        catch (ExecutionException e) {
                            if (repositoryFolder.exists() || repositoryFolder.isLinked(512)) break block7;
                            logger.error((Object)("Cannot create repository folder: " + repositoryFolder), (Throwable)e);
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                DatabazePreLoadOperation op2 = new DatabazePreLoadOperation();
                op2.execute(monitor);
                QCachedDirectoryRepositoryController.this.isReady = true;
            }
            finally {
                monitor.done();
            }
        }
    }
}

