/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.model;

import eu.qimpress.ide.backbone.core.internal.model.AbstractQController;
import eu.qimpress.ide.backbone.core.internal.model.QAlternativeImpl;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.usagemodel.SystemCall;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class QAlternativeController
extends AbstractQController<QAlternativeImpl> {
    private static final Logger logger = Logger.getLogger(QAlternativeController.class);

    public QAlternativeController(QAlternativeImpl element) {
        super(element);
    }

    @Override
    protected void doInit(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation operation = this.getInitWSOperation();
        operation.run(monitor);
    }

    @Override
    public WorkspaceModifyOperation getInitWSOperation() {
        return new CreateAlternativeOperation();
    }

    private class CreateAlternativeOperation
    extends WorkspaceModifyOperation {
        private IFile serviceArchitectureModel;
        private IFile usageModel;
        private IFile repositoryModel;

        public CreateAlternativeOperation() {
            super((ISchedulingRule)((QAlternativeImpl)QAlternativeController.this.element).getCorrespondingResource().getParent());
            this.serviceArchitectureModel = null;
            this.usageModel = null;
            this.repositoryModel = null;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            IFolder alternativeFolder = ((QAlternativeImpl)QAlternativeController.this.element).getAlternativeFolder();
            if (!alternativeFolder.exists()) {
                alternativeFolder.create(true, true, monitor);
                if (((QAlternativeImpl)QAlternativeController.this.element).getParentAlternative() != null) {
                    IResource[] parentContent = ((QAlternativeImpl)QAlternativeController.this.element).getParentAlternative().getAlternativeFolder().members();
                    alternativeFolder.getWorkspace().copy(parentContent, alternativeFolder.getFullPath(), true, monitor);
                    this.handleEMFReferences(alternativeFolder, monitor);
                }
            }
        }

        private void handleEMFReferences(IFolder alternativeFolder, IProgressMonitor monitor) throws CoreException {
            alternativeFolder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getType() == 1) {
                        if (resource.getName().endsWith("samm_servicearchitecturemodel")) {
                            CreateAlternativeOperation.this.serviceArchitectureModel = (IFile)resource;
                        } else if (resource.getName().endsWith("samm_usagemodel")) {
                            CreateAlternativeOperation.this.usageModel = (IFile)resource;
                        } else if (resource.getName().endsWith("samm_repository")) {
                            CreateAlternativeOperation.this.repositoryModel = (IFile)resource;
                        }
                    }
                    return true;
                }
            }, 1, false);
            if (this.serviceArchitectureModel != null && this.usageModel != null) {
                this.handleUsageModel(this.usageModel, this.serviceArchitectureModel, this.repositoryModel);
            }
        }

        private void handleUsageModel(IFile usageModel, IFile serviceArchitectureModel, IFile repositoryModel) throws CoreException {
            ResourceSetImpl rset = new ResourceSetImpl();
            Resource rUsageModel = rset.getResource(this.getModelURI(usageModel), true);
            Resource rServiceArchModel = rset.getResource(this.getModelURI(serviceArchitectureModel), true);
            Resource rRepositoryModel = rset.getResource(this.getModelURI(repositoryModel), true);
            TreeIterator it = EcoreUtil.getAllProperContents((Resource)rUsageModel, (boolean)true);
            while (it.hasNext()) {
                Operation operation;
                EObject eo = (EObject)it.next();
                if (!(eo instanceof SystemCall)) continue;
                SystemCall systemCall = (SystemCall)eo;
                String ifacePortId = systemCall.getCalledInterfacePort().getId();
                InterfacePort ifacePort = this.getInterfacePortById(ifacePortId, rServiceArchModel);
                if (ifacePort == null) {
                    ifacePort = this.getInterfacePortById(ifacePortId, rRepositoryModel);
                    logger.debug((Object)"InterfacePort found in repository and not in service architecture. Hence, the model looks wrong!");
                }
                if (ifacePort != null) {
                    systemCall.setCalledInterfacePort(ifacePort);
                } else {
                    systemCall.setCalledInterfacePort(null);
                    logger.debug((Object)("Cannot re-set ifaceport reference for systemcall=" + systemCall));
                }
                String operationId = systemCall.getOperation().getId();
                Operation operation2 = operation = ifacePort != null ? this.getOperationById(operationId, ifacePort) : null;
                if (operation != null) {
                    systemCall.setOperation(operation);
                    continue;
                }
                systemCall.setOperation(null);
                logger.debug((Object)("Cannot re-set operation reference for systemcall=" + systemCall));
            }
            try {
                rUsageModel.save(null);
            }
            catch (IOException e) {
                throw new ResourceException(0, usageModel.getFullPath(), e.getMessage(), (Throwable)e);
            }
        }

        private URI getModelURI(IFile file) {
            return URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)false);
        }

        private InterfacePort getInterfacePortById(String id, Resource rModel) {
            TreeIterator it = EcoreUtil.getAllContents((Resource)rModel, (boolean)true);
            while (it.hasNext()) {
                EObject eo = (EObject)it.next();
                if (!(eo instanceof InterfacePort) || !id.equals(((InterfacePort)eo).getId())) continue;
                return (InterfacePort)eo;
            }
            return null;
        }

        private Operation getOperationById(String id, InterfacePort ifacePort) {
            EList operations = ifacePort.getInterfaceType().getSignatures();
            for (Operation op : operations) {
                if (!id.equals(op.getId())) continue;
                return op;
            }
            return null;
        }
    }
}

