/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.model;

import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQWorkspaceController;
import eu.qimpress.ide.backbone.core.model.InitializationException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractQController<T extends IQElement>
implements IQWorkspaceController {
    private static final Logger logger = Logger.getLogger(AbstractQController.class);
    protected T element;
    private boolean initializationInProgress = false;

    public AbstractQController(T element) {
        this.element = element;
    }

    @Override
    public synchronized Job init(boolean fork, boolean waitForFinish) throws InitializationException {
        this.initializationInProgress = true;
        this.preInit();
        try {
            if (fork) {
                InitializationJob job = new InitializationJob();
                job.schedule();
                if (waitForFinish) {
                    try {
                        job.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                InitializationJob initializationJob = job;
                return initializationJob;
            }
            try {
                this.doInit((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException interruptedException) {
                logger.error((Object)("Canceled initialization of element: " + this.element));
            }
            catch (Exception e) {
                logger.error((Object)("Cannot initialize element: " + this.element), (Throwable)e);
                throw new InitializationException(e);
            }
            return null;
        }
        finally {
            this.initializationInProgress = false;
        }
    }

    protected abstract void doInit(IProgressMonitor var1) throws CoreException, InvocationTargetException, InterruptedException;

    protected void preInit() {
    }

    public boolean isInitializationInProgress() {
        return this.initializationInProgress;
    }

    private class InitializationJob
    extends Job {
        private static final String JOB_NAME_PREFIX = "Initialization job of ";

        public InitializationJob() {
            super(JOB_NAME_PREFIX + (Object)((Object)AbstractQController.this.element.getElementType()));
            this.setSystem(true);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("", 1);
                try {
                    AbstractQController.this.doInit(monitor);
                }
                catch (InterruptedException interruptedException) {
                    logger.warn((Object)("Cancel of element initialization: " + AbstractQController.this.element));
                    Status status = new Status(8, "eu.qimpress.ide.backbone.core", "Canceled");
                    AbstractQController.this.initializationInProgress = false;
                    monitor.done();
                    return status;
                }
                catch (Exception e) {
                    logger.error((Object)("Cannot initialize element: " + AbstractQController.this.element), (Throwable)e);
                    Status status = new Status(4, "eu.qimpress.ide.backbone.core", e.getMessage());
                    AbstractQController.this.initializationInProgress = false;
                    monitor.done();
                    return status;
                }
            }
            finally {
                AbstractQController.this.initializationInProgress = false;
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

