/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core;

import eu.qimpress.ide.backbone.core.internal.listeners.AlternativeResourceChangedListener;
import eu.qimpress.ide.backbone.core.internal.listeners.ModelResourceChangedListener;
import eu.qimpress.ide.backbone.core.internal.listeners.QImpressProjectlResourceChangedListener;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class QImpressCore
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "eu.qimpress.ide.backbone.core";
    private static QImpressCore plugin;
    private ModelResourceChangedListener modelResourceChangedListener = new ModelResourceChangedListener();
    private QImpressProjectlResourceChangedListener qImpressProjectlResourceChangedListener = new QImpressProjectlResourceChangedListener();
    private AlternativeResourceChangedListener alternativeResourceChangedListener = new AlternativeResourceChangedListener();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.modelResourceChangedListener);
        workspace.addResourceChangeListener((IResourceChangeListener)this.qImpressProjectlResourceChangedListener, 7);
        workspace.addResourceChangeListener((IResourceChangeListener)this.alternativeResourceChangedListener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.modelResourceChangedListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.qImpressProjectlResourceChangedListener);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.alternativeResourceChangedListener);
        plugin = null;
        super.stop(context);
    }

    public static QImpressCore getDefault() {
        return plugin;
    }

    public static IQElement create(IResource resource) {
        return QImpressApplicationModelManager.create(resource, null);
    }

    public static IQElement create(IResource resource, IQProject project) {
        return QImpressApplicationModelManager.create(resource, project);
    }

    public static IQApplicationModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return QImpressApplicationModelManager.getManager().getQAppModel();
    }

    public static IQProject create(IProject project) {
        if (project == null) {
            return null;
        }
        IQApplicationModel qAppModel = QImpressApplicationModelManager.getManager().getQAppModel();
        return qAppModel.getQProject(project);
    }

    public static IQElement create(IFolder folder) {
        return QImpressApplicationModelManager.create(folder, null);
    }

    public static IQElement create(IFile file) {
        return QImpressApplicationModelManager.create(file, null);
    }

    public static IQAlternative getAlternativeById(String id) {
        IQElement element = QImpressApplicationModelManager.getManager().getQAppModel().getElementByID(id);
        if (element != null && element.getElementType() == IQElement.ElementType.Q_ALTERNATIVE) {
            return (IQAlternative)element;
        }
        return null;
    }

    public static IQModel getModelByFile(IFile file) {
        return QImpressApplicationModelManager.getModelByResource(file);
    }

    public static IProject getProject(URI platformURI) {
        IProject result = null;
        if (platformURI.isPlatform()) {
            String projectName = URI.decode((String)platformURI.segment(1));
            IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
            result = wRoot.getProject(projectName);
        } else if (platformURI.isFile()) {
            Path filePath = new Path(platformURI.toFileString());
            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            filePath = filePath.makeRelativeTo(workspacePath);
            String projectName = filePath.segment(0);
            result = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return result;
    }

    public static String getAlternativeId(URI resourceURI) {
        String result = null;
        if (resourceURI.isPlatform()) {
            result = URI.decode((String)resourceURI.segment(3));
        } else if (resourceURI.isFile()) {
            Path filePath = new Path(resourceURI.toFileString());
            IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            filePath = filePath.makeRelativeTo(workspacePath);
            result = filePath.segment(2);
        }
        return result;
    }

    public static String getAlternativeId(IPath resourceLocation) {
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        resourceLocation = resourceLocation.makeRelativeTo(workspacePath);
        return resourceLocation.segment(2);
    }

    public static IQProject getQProject(IProject project) {
        return QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
    }

    public static IQProject getQProject(URI platformURI) {
        IProject project = QImpressCore.getProject(platformURI);
        return QImpressCore.getQProject(project);
    }

    public static IQProject getQProject(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return QImpressCore.getQProject(project);
    }

    public static IQProject getQProject(EObject eObject) {
        return QImpressCore.getQProject(eObject.eResource().getURI());
    }

    public static boolean isGlobalAlternative(IQAlternative alternative) {
        String alternativeID = alternative.getInfo().getId();
        return "0".equals(alternativeID);
    }

    public static IQModel getResultModelByEObject(EObject eObject) throws RepositoryException {
        IQRepository repo = QImpressCore.getQProject(eObject).getRepository();
        IQModel model = repo.getResultModel();
        return model;
    }
}

