/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.wizards;

import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.operations.InitializeQImpressProjectOperation;
import eu.qimpress.ide.backbone.core.utils.ProjectUtils;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class QImPrESSNewProjectWizard
extends BasicNewProjectResourceWizard {
    private static final Logger logger = Logger.getLogger(QImPrESSNewProjectWizard.class);
    public static final String WIZARD_ID = "eu.qimpress.ide.backbone.core.ui.QImPrESSNewProjectWizardID";

    public boolean performFinish() {
        if (super.performFinish()) {
            final IProject project = this.getNewProject();
            try {
                logger.trace((Object)"Trying to toggle Q-ImPrESS nature");
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask("", 2);
                                InitializeQImpressProjectOperation initOperation = new InitializeQImpressProjectOperation(project);
                                initOperation.run(monitor);
                                ProjectUtils.toggleNature((IProject)project);
                            }
                            catch (RepositoryException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                this.getContainer().run(false, false, (IRunnableWithProgress)operation);
                this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                        try {
                            workbench.showPerspective("eu.qimpress.ide.perspective.QIPerspectiveID", window);
                        }
                        catch (WorkbenchException e) {
                            logger.warn((Object)"Cannot open Q-ImPrESS perspective.", (Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)("Cannot toggle Q-Impress nature for project " + project), (Throwable)e);
                MessageDialog.openError((Shell)this.getShell(), (String)"Q-ImPrESS project creation failed", (String)"Q-ImPrESS nature toggling failed - see log for details");
            }
            return true;
        }
        return false;
    }
}

