/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorContentProvider;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorLabelProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;

public class QProjectViewer
extends CheckboxTreeViewer {
    private List<IQProject> selectedProjects = null;

    public QProjectViewer(Composite parent, int style) {
        this(parent, style, true);
    }

    public IQProject getFirstSelectedProject() {
        if (this.selectedProjects == null || this.selectedProjects.size() == 0) {
            return null;
        }
        return this.selectedProjects.get(0);
    }

    public QProjectViewer(Composite parent, int style, final boolean singleSelection) {
        super(parent, style);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (singleSelection) {
                    if (!event.getChecked()) {
                        QProjectViewer.this.setCheckedElements(new Object[0]);
                        QProjectViewer.this.selectedProjects = new ArrayList();
                    } else {
                        QProjectViewer.this.setCheckedElements(new Object[]{event.getElement()});
                        QProjectViewer.this.selectedProjects = new ArrayList();
                        IQProject project = QImpressApplicationModelManager.getManager().getQAppModel().getQProject((IProject)event.getElement());
                        QProjectViewer.this.selectedProjects.add(project);
                    }
                } else {
                    Object[] checkedElements = QProjectViewer.this.getCheckedElements();
                    QProjectViewer.this.selectedProjects = new ArrayList();
                    int i = 0;
                    while (i < QProjectViewer.this.getCheckedElements().length) {
                        IQProject project = QImpressApplicationModelManager.getManager().getQAppModel().getQProject((IProject)checkedElements[i]);
                        QProjectViewer.this.selectedProjects.add(project);
                        ++i;
                    }
                }
            }
        });
        this.setContentProvider((IContentProvider)new QAppNavigatorContentProvider(QAppNavigatorContentProvider.ContentFilterEnum.FILTER_PROJECTS_ONLY.val()));
        this.setInput(QImpressApplicationModelManager.getManager().getQAppModel());
        this.setLabelProvider((IBaseLabelProvider)new QAppNavigatorLabelProvider());
    }

    public void selectElement(IQProject project) {
        this.setCheckedElements(new Object[]{project});
        this.selectedProjects = new ArrayList<IQProject>();
        this.selectedProjects.add(project);
    }

    public List<IQProject> getSelectedProjects() {
        if (this.selectedProjects == null) {
            return Collections.emptyList();
        }
        return this.selectedProjects;
    }
}

